/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.extras.internal.contrib.blogofbug.swing.components;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import org.pushingpixels.radiance.theming.extras.internal.contrib.blogofbug.swing.components.RichComponent;
import org.pushingpixels.radiance.theming.extras.internal.contrib.blogofbug.utility.ImageUtilities;

public class ReflectedImageLabel
extends JLabel
implements RichComponent {
    private String text = "";
    private BufferedImage bufferedImage = null;
    private static final Font reference = new Font("Arial", 1, 14);
    private AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 1.0f);

    @Deprecated
    public ReflectedImageLabel(Image image, int width, int height) {
        this.setRichImage(image);
    }

    @Deprecated
    public ReflectedImageLabel(Image image, String text, int width, int height) {
        this.setRichImage(image);
        this.setRichText(text);
    }

    public ReflectedImageLabel(Image image, String text) {
        this(image, text, image.getWidth(null), image.getHeight(null));
    }

    public ReflectedImageLabel(String imageURL) {
        try {
            this.setRichImage(new URL(imageURL));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public ReflectedImageLabel(String imageURL, int width, int height) {
        try {
            this.setRichImage(new URL(imageURL));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public ReflectedImageLabel(String imageURL, String text, int width, int height) {
        this(imageURL, width, height);
        this.text = text;
    }

    @Deprecated
    public void setLabel(String text) {
        this.text = text;
    }

    protected void setupImage(Image image) {
        if (image == null) {
            return;
        }
        BufferedImage originalImage = ImageUtilities.createCompatibleImage(image.getWidth(null), (int)((double)image.getHeight(null) * 1.5));
        Graphics2D g = originalImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        BufferedImage reflection = ImageUtilities.createCompatibleImage(image.getWidth(null), image.getHeight(null));
        g = reflection.createGraphics();
        int drawHeight = image.getHeight(null);
        AffineTransform tranform = AffineTransform.getScaleInstance(1.0, -1.0);
        tranform.translate(0.0, -drawHeight);
        AffineTransform oldTransform = g.getTransform();
        g.setTransform(tranform);
        g.drawImage(image, 0, 0, image.getWidth(null), drawHeight, 0, 0, image.getWidth(null), image.getHeight(null), null);
        g.setTransform(oldTransform);
        GradientPaint painter = new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.5f), 0.0f, (float)drawHeight / 2.0f, new Color(0.0f, 0.0f, 0.0f, 1.0f));
        g.setComposite(AlphaComposite.DstOut);
        g.setPaint(painter);
        g.fill(new Rectangle2D.Double(0.0, 0.0, image.getWidth(null), drawHeight));
        g.dispose();
        g = originalImage.createGraphics();
        g.drawImage((Image)reflection, 0, drawHeight, null);
        g.dispose();
        this.bufferedImage = originalImage;
        this.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
    }

    @Override
    public void setAlpha(float alphaLevel) {
        this.alphaComposite = AlphaComposite.getInstance(3, alphaLevel);
    }

    @Deprecated
    public void setImage(Image image) {
        this.setupImage(image);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = (int)((double)d.height * 1.5);
        return d;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.getX() + this.getWidth() < 0 && this.getY() + this.getHeight() < 0) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        BufferedImage image = this.bufferedImage;
        int drawHeight = (int)((double)this.getHeight() / 1.5);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        Composite oldAc = g.getComposite();
        g.setComposite(this.alphaComposite);
        g.drawImage(image, 0, 0, this.getWidth(), this.getHeight(), 0, 0, ((Image)image).getWidth(null), ((Image)image).getHeight(null), null);
        if (this.text != null && this.text.length() > 0) {
            Graphics2D g2d = (Graphics2D)graphics;
            Rectangle2D bounds = reference.getStringBounds(this.text, g2d.getFontRenderContext());
            double scaleFactor = (double)this.getWidth() / (double)((Image)image).getWidth(null);
            double scaleFactor2 = (double)this.getWidth() / bounds.getWidth();
            int fontSize = (int)Math.min(25.0 * scaleFactor, 14.0 * scaleFactor2);
            Font font = new Font("Arial", 1, fontSize);
            g2d.setFont(font);
            int dx = (this.getWidth() - (int)font.getStringBounds(this.text, g2d.getFontRenderContext()).getWidth()) / 2;
            int dy = drawHeight + 2 * (int)(bounds.getHeight() * scaleFactor);
            Color background = this.getBackground();
            int red = background.getRed();
            int green = background.getRed();
            int blue = background.getRed();
            graphics.setColor(new Color(red, green, blue, 96));
            FontMetrics fm = g2d.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(this.text, graphics);
            graphics.fillRoundRect(dx - (int)rect.getHeight() / 2, dy - g2d.getFontMetrics().getAscent(), (int)rect.getWidth() + (int)rect.getHeight(), fm.getAscent() + fm.getDescent(), (int)rect.getHeight(), (int)rect.getHeight());
            graphics.setColor(this.getForeground());
            graphics.drawString(this.text, dx, dy);
        }
        g.setComposite(oldAc);
    }

    @Override
    public void setRichImage(URL image) {
        this.setRichImage(ImageUtilities.loadCompatibleImage(image.toString()));
    }

    @Override
    public void setRichImage(File image) {
        try {
            this.setRichImage(image.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setRichImage(Image image) {
        this.setImage(image);
    }

    @Override
    public void prePaintImage() {
    }

    @Override
    public void setRichText(String text) {
        this.setLabel(text);
    }

    @Override
    public String getRichText() {
        return this.text;
    }
}

