/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api;

import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.internal.contrib.jgoodies.looks.LookUtils;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingComponentPlugin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.internal.RadiancePluginRepository;
import org.pushingpixels.radiance.theming.internal.ui.RadianceButtonUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceCheckBoxMenuItemUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceCheckBoxUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceComboBoxUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceDesktopIconUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceDesktopPaneUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceEditorPaneUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceFileChooserUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceFormattedTextFieldUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceInternalFrameUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceLabelUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceListUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceMenuBarUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceMenuItemUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceMenuUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceOptionPaneUI;
import org.pushingpixels.radiance.theming.internal.ui.RadiancePanelUI;
import org.pushingpixels.radiance.theming.internal.ui.RadiancePasswordFieldUI;
import org.pushingpixels.radiance.theming.internal.ui.RadiancePopupMenuSeparatorUI;
import org.pushingpixels.radiance.theming.internal.ui.RadiancePopupMenuUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceProgressBarUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceRadioButtonMenuItemUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceRadioButtonUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceRootPaneUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceScrollBarUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceScrollPaneUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceSeparatorUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceSliderUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceSpinnerUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceSplitPaneUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTabbedPaneUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTableHeaderUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTableUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTextAreaUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTextFieldUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTextPaneUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceToggleButtonUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceToolBarSeparatorUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceToolBarUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceToolTipUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTreeUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceViewportUI;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.MemoryAnalyzer;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public abstract class RadianceLookAndFeel
extends BasicLookAndFeel {
    private RadianceSkin skin;
    private String name;
    private AWTEventListener awtEventListener;

    protected RadianceLookAndFeel(RadianceSkin skin) {
        this.skin = skin;
        this.name = "Radiance " + skin.getDisplayName();
    }

    @Override
    public String getDescription() {
        return "Radiance Look and Feel by Kirill Grouchnikov";
    }

    @Override
    public String getID() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        Object[] uiDefaults = new Object[]{"ButtonUI", RadianceButtonUI.class.getName(), "CheckBoxUI", RadianceCheckBoxUI.class.getName(), "ComboBoxUI", RadianceComboBoxUI.class.getName(), "CheckBoxMenuItemUI", RadianceCheckBoxMenuItemUI.class.getName(), "DesktopIconUI", RadianceDesktopIconUI.class.getName(), "DesktopPaneUI", RadianceDesktopPaneUI.class.getName(), "EditorPaneUI", RadianceEditorPaneUI.class.getName(), "FileChooserUI", RadianceFileChooserUI.class.getName(), "FormattedTextFieldUI", RadianceFormattedTextFieldUI.class.getName(), "InternalFrameUI", RadianceInternalFrameUI.class.getName(), "LabelUI", RadianceLabelUI.class.getName(), "ListUI", RadianceListUI.class.getName(), "MenuUI", RadianceMenuUI.class.getName(), "MenuBarUI", RadianceMenuBarUI.class.getName(), "MenuItemUI", RadianceMenuItemUI.class.getName(), "OptionPaneUI", RadianceOptionPaneUI.class.getName(), "PanelUI", RadiancePanelUI.class.getName(), "PasswordFieldUI", RadiancePasswordFieldUI.class.getName(), "PopupMenuUI", RadiancePopupMenuUI.class.getName(), "PopupMenuSeparatorUI", RadiancePopupMenuSeparatorUI.class.getName(), "ProgressBarUI", RadianceProgressBarUI.class.getName(), "RadioButtonUI", RadianceRadioButtonUI.class.getName(), "RadioButtonMenuItemUI", RadianceRadioButtonMenuItemUI.class.getName(), "RootPaneUI", RadianceRootPaneUI.class.getName(), "ScrollBarUI", RadianceScrollBarUI.class.getName(), "ScrollPaneUI", RadianceScrollPaneUI.class.getName(), "SeparatorUI", RadianceSeparatorUI.class.getName(), "SliderUI", RadianceSliderUI.class.getName(), "SpinnerUI", RadianceSpinnerUI.class.getName(), "SplitPaneUI", RadianceSplitPaneUI.class.getName(), "TabbedPaneUI", RadianceTabbedPaneUI.class.getName(), "TableUI", RadianceTableUI.class.getName(), "TableHeaderUI", RadianceTableHeaderUI.class.getName(), "TextAreaUI", RadianceTextAreaUI.class.getName(), "TextFieldUI", RadianceTextFieldUI.class.getName(), "TextPaneUI", RadianceTextPaneUI.class.getName(), "ToggleButtonUI", RadianceToggleButtonUI.class.getName(), "ToolBarUI", RadianceToolBarUI.class.getName(), "ToolBarSeparatorUI", RadianceToolBarSeparatorUI.class.getName(), "ToolTipUI", RadianceToolTipUI.class.getName(), "TreeUI", RadianceTreeUI.class.getName(), "ViewportUI", RadianceViewportUI.class.getName()};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        RadianceThemingCortex.GlobalScope.initFontDefaults(table);
        this.skin.addCustomEntriesToTable(table);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (RadianceCommonCortex.getPlatform() != RadianceCommonCortex.Platform.MACOS || !LookUtils.IS_OS_MAC_MOJAVE_OR_LATER) {
            Object aaHint;
            Map desktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
            Object v0 = aaHint = desktopHints == null ? null : desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (aaHint != null && aaHint != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF && aaHint != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                table.put(RenderingHints.KEY_TEXT_ANTIALIASING, (Object)aaHint);
                table.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, desktopHints.get(RenderingHints.KEY_TEXT_LCD_CONTRAST));
            }
        }
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = super.getDefaults();
        RadiancePluginRepository.getInstance().processAllDefaultsEntriesComponentPlugins(table, this.skin);
        return table;
    }

    @Override
    public void initialize() {
        super.initialize();
        RadianceThemingCortex.GlobalScope.setSkin(this.skin, false);
        String traceFilename = (String)UIManager.get("radiance.theming.internal.traceFile");
        if (traceFilename != null) {
            MemoryAnalyzer.commence(1000L, traceFilename);
            for (RadianceThemingComponentPlugin plugin : RadiancePluginRepository.getInstance().getComponentPlugins()) {
                MemoryAnalyzer.enqueueUsage("Has plugin '" + plugin.getClass().getName() + "'");
            }
        }
        RadiancePluginRepository.getInstance().initializeAllComponentPlugins();
        this.awtEventListener = event -> {
            List<AWTEventListener> eventListeners = RadianceCoreUtilities.getAwtEventListeners();
            for (int i = eventListeners.size() - 1; i >= 0; --i) {
                eventListeners.get(i).eventDispatched(event);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 131096L);
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
        RadianceThemingCortex.GlobalScope.unsetSkin();
        RadianceCoreUtilities.stopThreads();
        RadiancePluginRepository.getInstance().uninitializeAllComponentPlugins();
        LazyResettableHashMap.reset();
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        return icon;
    }
}

