/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.radiance.theming.api.colorscheme.DerivedColorsResolverDark;
import org.pushingpixels.radiance.theming.api.colorscheme.DerivedColorsResolverLight;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.SchemeDerivedColors;
import org.pushingpixels.radiance.theming.internal.colorscheme.BlendBiColorScheme;
import org.pushingpixels.radiance.theming.internal.colorscheme.HueShiftColorScheme;
import org.pushingpixels.radiance.theming.internal.colorscheme.InvertedColorScheme;
import org.pushingpixels.radiance.theming.internal.colorscheme.NegatedColorScheme;
import org.pushingpixels.radiance.theming.internal.colorscheme.SaturatedColorScheme;
import org.pushingpixels.radiance.theming.internal.colorscheme.ShadeColorScheme;
import org.pushingpixels.radiance.theming.internal.colorscheme.ShiftColorScheme;
import org.pushingpixels.radiance.theming.internal.colorscheme.TintColorScheme;
import org.pushingpixels.radiance.theming.internal.colorscheme.ToneColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;

public abstract class BaseColorScheme
implements RadianceColorScheme {
    protected boolean isDark;
    protected String displayName;
    private SchemeDerivedColors derivedColorsResolver;

    protected BaseColorScheme(String displayName, boolean isDark) {
        this.displayName = displayName;
        this.isDark = isDark;
        this.derivedColorsResolver = this.isDark ? new DerivedColorsResolverDark(this) : new DerivedColorsResolverLight(this);
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isDark() {
        return this.isDark;
    }

    @Override
    public final RadianceColorScheme shift(Color backgroundShiftColor, double backgroundShiftFactor, Color foregroundShiftColor, double foregroundShiftFactor) {
        return new ShiftColorScheme(this, backgroundShiftColor, backgroundShiftFactor, foregroundShiftColor, foregroundShiftFactor, true);
    }

    @Override
    public final RadianceColorScheme shiftBackground(Color backgroundShiftColor, double backgroundShiftFactor) {
        return this.shift(backgroundShiftColor, backgroundShiftFactor, null, 0.0);
    }

    @Override
    public RadianceColorScheme tint(double tintFactor) {
        return new TintColorScheme(this, tintFactor);
    }

    @Override
    public RadianceColorScheme tone(double toneFactor) {
        return new ToneColorScheme(this, toneFactor);
    }

    @Override
    public RadianceColorScheme shade(double shadeFactor) {
        return new ShadeColorScheme(this, shadeFactor);
    }

    @Override
    public RadianceColorScheme saturate(double saturateFactor) {
        return new SaturatedColorScheme(this, saturateFactor);
    }

    @Override
    public RadianceColorScheme invert() {
        return new InvertedColorScheme(this);
    }

    @Override
    public RadianceColorScheme negate() {
        return new NegatedColorScheme(this);
    }

    @Override
    public RadianceColorScheme hueShift(double hueShiftFactor) {
        return new HueShiftColorScheme(this, hueShiftFactor);
    }

    @Override
    public RadianceColorScheme blendWith(RadianceColorScheme otherScheme, double likenessToThisScheme) {
        return new BlendBiColorScheme(this, otherScheme, likenessToThisScheme);
    }

    @Override
    public Color getBackgroundFillColor() {
        return this.derivedColorsResolver.getBackgroundFillColor();
    }

    @Override
    public Color getAccentedBackgroundFillColor() {
        return this.derivedColorsResolver.getAccentedBackgroundFillColor();
    }

    @Override
    public Color getFocusRingColor() {
        return this.derivedColorsResolver.getFocusRingColor();
    }

    @Override
    public Color getLineColor() {
        return this.derivedColorsResolver.getLineColor();
    }

    @Override
    public Color getSelectionForegroundColor() {
        return this.derivedColorsResolver.getSelectionForegroundColor();
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return this.derivedColorsResolver.getSelectionBackgroundColor();
    }

    @Override
    public Color getTextBackgroundFillColor() {
        return this.derivedColorsResolver.getTextBackgroundFillColor();
    }

    @Override
    public Color getSeparatorPrimaryColor() {
        return this.derivedColorsResolver.getSeparatorPrimaryColor();
    }

    @Override
    public Color getSeparatorSecondaryColor() {
        return this.derivedColorsResolver.getSeparatorSecondaryColor();
    }

    @Override
    public Color getMarkColor() {
        return this.derivedColorsResolver.getMarkColor();
    }

    @Override
    public Color getEchoColor() {
        return this.derivedColorsResolver.getEchoColor();
    }

    @Override
    public final RadianceColorScheme named(String colorSchemeDisplayName) {
        this.displayName = colorSchemeDisplayName;
        return this;
    }

    public String toString() {
        return this.getDisplayName() + " {\n    kind=" + (this.isDark() ? "Dark" : "Light") + "\n    colorUltraLight=" + RadianceColorUtilities.encode(this.getUltraLightColor()) + "\n    colorExtraLight=" + RadianceColorUtilities.encode(this.getExtraLightColor()) + "\n    colorLight=" + RadianceColorUtilities.encode(this.getLightColor()) + "\n    colorMid=" + RadianceColorUtilities.encode(this.getMidColor()) + "\n    colorDark=" + RadianceColorUtilities.encode(this.getDarkColor()) + "\n    colorUltraDark=" + RadianceColorUtilities.encode(this.getUltraDarkColor()) + "\n    colorForeground=" + RadianceColorUtilities.encode(this.getForegroundColor()) + "\n}";
    }
}

