/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.decoration;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.decoration.RadianceDecorationPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public abstract class ImageWrapperDecorationPainter
implements RadianceDecorationPainter {
    protected Image originalTile = null;
    protected RadianceDecorationPainter baseDecorationPainter;
    protected LinkedHashMap<String, BufferedImage> colorizedTileMap = new LinkedHashMap<String, BufferedImage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
            return this.size() > 10;
        }
    };
    protected float textureAlpha = 0.2f;

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        if (decorationAreaType == RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE || decorationAreaType == RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE) {
            this.paintTitleBackground(graphics, comp, decorationAreaType, width, height, skin);
        } else {
            this.paintExtraBackground(graphics, comp, decorationAreaType, width, height, skin);
        }
    }

    private void paintTitleBackground(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        RadianceColorScheme tileScheme = skin.getBackgroundColorScheme(decorationAreaType);
        if (this.baseDecorationPainter == null) {
            graphics.setColor(tileScheme.getMidColor());
            graphics.fillRect(0, 0, width, height);
        } else {
            this.baseDecorationPainter.paintDecorationArea(graphics, comp, decorationAreaType, width, height, skin);
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        this.tileArea(temp, comp, tileScheme, 0, 0, width, height);
        temp.dispose();
    }

    private void paintExtraBackground(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        Point offset = RadianceCoreUtilities.getOffsetInRootPaneCoords(comp);
        RadianceColorScheme tileScheme = skin.getBackgroundColorScheme(decorationAreaType);
        if (this.baseDecorationPainter != null) {
            this.baseDecorationPainter.paintDecorationArea(graphics, comp, decorationAreaType, width, height, skin);
        } else {
            graphics.setColor(tileScheme.getMidColor());
            graphics.fillRect(0, 0, width, height);
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        this.tileArea(temp, comp, tileScheme, offset.x, offset.y, width, height);
        temp.dispose();
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, Shape contour, RadianceColorScheme colorScheme) {
        Point offset = RadianceCoreUtilities.getOffsetInRootPaneCoords(comp);
        if (this.baseDecorationPainter != null) {
            this.baseDecorationPainter.paintDecorationArea(graphics, comp, decorationAreaType, contour, colorScheme);
        } else {
            graphics.setColor(colorScheme.getMidColor());
            graphics.fill(contour);
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        temp.setClip(contour);
        this.tileArea(temp, comp, colorScheme, offset.x, offset.y, comp.getWidth(), comp.getHeight());
        temp.dispose();
    }

    private void tileArea(Graphics2D g, Component comp, RadianceColorScheme tileScheme, int offsetTextureX, int offsetTextureY, int width, int height) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite(comp, this.textureAlpha, g));
        double scale = RadianceCommonCortex.getScaleFactor((Component)comp);
        BufferedImage colorizedTile = this.getColorizedTile(scale, tileScheme);
        int tileWidth = (int)((double)((Image)colorizedTile).getWidth(null) / scale);
        int tileHeight = (int)((double)((Image)colorizedTile).getHeight(null) / scale);
        offsetTextureX %= tileWidth;
        int currTileTop = -(offsetTextureY %= tileHeight);
        do {
            int currTileLeft = -offsetTextureX;
            do {
                graphics.drawImage(colorizedTile, currTileLeft, currTileTop, tileWidth, tileHeight, null);
            } while ((currTileLeft += tileWidth) < width);
        } while ((currTileTop += tileHeight) < height);
        graphics.dispose();
    }

    public void setBaseDecorationPainter(RadianceDecorationPainter baseDecorationPainter) {
        this.baseDecorationPainter = baseDecorationPainter;
    }

    public void setTextureAlpha(float textureAlpha) {
        this.textureAlpha = textureAlpha;
    }

    protected BufferedImage getColorizedTile(double scale, RadianceColorScheme scheme) {
        String key = scale + ":" + scheme.getDisplayName();
        BufferedImage result = this.colorizedTileMap.get(key);
        if (result == null) {
            int tileWidth = this.originalTile.getWidth(null);
            int tileHeight = this.originalTile.getHeight(null);
            BufferedImage tileBi = RadianceCoreUtilities.getBlankImage(scale, (int)((double)tileWidth / scale), (int)((double)tileHeight / scale));
            Graphics2D tile2D = tileBi.createGraphics();
            tile2D.drawImage(this.originalTile, 0, 0, (int)((double)tileWidth / scale), (int)((double)tileHeight / scale), null);
            tile2D.dispose();
            result = RadianceImageCreator.getColorSchemeImage(tileBi, scheme, 0.0f, 1.0f);
            this.colorizedTileMap.put(key, result);
        }
        return result;
    }
}

