/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.decoration;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.decoration.RadianceDecorationPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class MatteDecorationPainter
implements RadianceDecorationPainter {
    public static final String DISPLAY_NAME = "Matte";
    private static final int FLEX_POINT = 50;

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        RadianceColorScheme colorScheme = skin.getBackgroundColorScheme(decorationAreaType);
        if (decorationAreaType == RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE || decorationAreaType == RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE) {
            this.paintTitleBackground(graphics, width, height, colorScheme);
        } else {
            this.paintExtraBackground(graphics, comp, width, height, colorScheme);
        }
    }

    private void paintTitleBackground(Graphics2D graphics, int width, int height, RadianceColorScheme scheme) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        this.fill(g2d, scheme, 0, 0, 0, width, height);
        g2d.dispose();
    }

    private void paintExtraBackground(Graphics2D graphics, Component comp, int width, int height, RadianceColorScheme scheme) {
        Point offset = RadianceCoreUtilities.getOffsetInRootPaneCoords(comp);
        Graphics2D g2d = (Graphics2D)graphics.create();
        this.fill(g2d, scheme, offset.y, 0, 0, width, height);
        g2d.dispose();
    }

    protected void fill(Graphics2D graphics, RadianceColorScheme scheme, int offsetY, int x, int y, int width, int height) {
        Color startColor = scheme.getLightColor();
        Color endColor = RadianceColorUtilities.getInterpolatedColor(startColor, scheme.getMidColor(), 0.4f);
        int gradientHeight = Math.max(50, height + offsetY);
        Paint paint = gradientHeight == 50 ? new GradientPaint(0.0f, y - offsetY, startColor, 0.0f, y + gradientHeight - offsetY, endColor) : new LinearGradientPaint(0.0f, y - offsetY, 0.0f, y + height - offsetY, new float[]{0.0f, 50.0f / (float)gradientHeight, 1.0f}, new Color[]{startColor, endColor, endColor}, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        graphics.setPaint(paint);
        graphics.fillRect(x, y, width, height);
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, Shape contour, RadianceColorScheme colorScheme) {
        Point offset = RadianceCoreUtilities.getOffsetInRootPaneCoords(comp);
        Color startColor = colorScheme.getLightColor();
        Color endColor = RadianceColorUtilities.getInterpolatedColor(startColor, colorScheme.getMidColor(), 0.4f);
        int gradientHeight = Math.max(50, comp.getHeight() + offset.y);
        Paint paint = gradientHeight == 50 ? new GradientPaint(0.0f, -offset.y, startColor, 0.0f, gradientHeight - offset.y, endColor) : new LinearGradientPaint(0.0f, -offset.y, 0.0f, comp.getHeight() - offset.y, new float[]{0.0f, 50.0f / (float)gradientHeight, 1.0f}, new Color[]{startColor, endColor, endColor}, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        graphics.setPaint(paint);
        graphics.fill(contour);
    }
}

