/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.overlay;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.overlay.RadianceOverlayPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public final class BottomLineOverlayPainter
implements RadianceOverlayPainter {
    ColorSchemeSingleColorQuery colorSchemeQuery;

    public BottomLineOverlayPainter(ColorSchemeSingleColorQuery colorSchemeQuery) {
        this.colorSchemeQuery = colorSchemeQuery;
    }

    @Override
    public void paintOverlay(Graphics2D g, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        Component topMostWithSameDecorationAreaType = RadianceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceColorScheme colorScheme = skin.getBackgroundColorScheme(decorationAreaType);
            graphics1X.setColor(this.colorSchemeQuery.query(colorScheme));
            int bottomY = (int)(scaleFactor * (double)topMostWithSameDecorationAreaType.getHeight() - 1.0);
            graphics1X.drawLine(0, bottomY, scaledWidth, bottomY);
        });
        graphics.dispose();
    }

    @Override
    public String getDisplayName() {
        return "Bottom Line";
    }
}

