/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.overlay;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.overlay.RadianceOverlayPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public final class TopBezelOverlayPainter
implements RadianceOverlayPainter {
    ColorSchemeSingleColorQuery colorSchemeQueryTop;
    ColorSchemeSingleColorQuery colorSchemeQueryBottom;

    public TopBezelOverlayPainter(ColorSchemeSingleColorQuery colorSchemeQueryTop, ColorSchemeSingleColorQuery colorSchemeQueryBottom) {
        this.colorSchemeQueryTop = colorSchemeQueryTop;
        this.colorSchemeQueryBottom = colorSchemeQueryBottom;
    }

    @Override
    public void paintOverlay(Graphics2D g, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        Component topMostWithSameDecorationAreaType = RadianceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        Point inTopMost = SwingUtilities.convertPoint(comp, new Point(0, 0), topMostWithSameDecorationAreaType);
        int dy = inTopMost.y;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceColorScheme colorScheme = skin.getBackgroundColorScheme(decorationAreaType);
            graphics1X.setColor(this.colorSchemeQueryTop.query(colorScheme));
            int topY = -((int)(scaleFactor * (double)dy));
            graphics1X.drawLine(0, topY, scaledWidth, topY);
            graphics1X.setColor(this.colorSchemeQueryBottom.query(colorScheme));
            int bezelY = 1 - (int)(scaleFactor * (double)dy);
            graphics1X.drawLine(0, bezelY, scaledWidth, bezelY);
        });
        graphics.dispose();
    }

    @Override
    public String getDisplayName() {
        return "Top Bezel";
    }
}

