/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeCellRenderer;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.renderer.RadianceRenderer;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTreeUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;

@RadianceRenderer
public abstract class RadiancePanelTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private Set<JLabel> themeAwareLabels;
    private Map<JLabel, IconData> themeAwareLabelsWithIcons;

    public RadiancePanelTreeCellRenderer() {
        RadianceThemingCortex.ComponentOrParentChainScope.setColorizationFactor(this, 1.0);
        this.themeAwareLabels = new HashSet<JLabel>();
        this.themeAwareLabelsWithIcons = new HashMap<JLabel, IconData>();
    }

    protected void registerThemeAwareLabelsWithText(JLabel ... labels) {
        for (JLabel label : labels) {
            this.themeAwareLabels.add(label);
        }
    }

    protected void unregisterThemeAwareLabelsWithText(JLabel ... labels) {
        for (JLabel label : labels) {
            this.themeAwareLabels.remove(label);
        }
    }

    protected void registerThemeAwareLabelWithIcon(JLabel label, RadianceIcon.Factory radianceIconFactory, Dimension iconDimension) {
        this.themeAwareLabelsWithIcons.put(label, new IconData(radianceIconFactory, iconDimension));
    }

    protected void unregisterThemeAwareLabelWithIcon(JLabel label) {
        this.themeAwareLabelsWithIcons.remove(label);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Color labelForeground;
        this.setComponentOrientation(tree.getComponentOrientation());
        TreeUI treeUI = tree.getUI();
        if (treeUI instanceof RadianceTreeUI) {
            boolean isDropLocation;
            RadianceTreeUI ui = (RadianceTreeUI)treeUI;
            RadianceTreeUI.TreePathId treePathId = new RadianceTreeUI.TreePathId(tree.getPathForRow(row));
            StateTransitionTracker.ModelStateInfo modelStateInfo = ui.getModelStateInfo(treePathId);
            ComponentState currState = ui.getPathState(treePathId);
            JTree.DropLocation dropLocation = tree.getDropLocation();
            boolean bl = isDropLocation = dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row;
            if (!isDropLocation && modelStateInfo != null) {
                Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
                RadianceColorScheme colorScheme = this.getColorSchemeForState(tree, ui, currState);
                if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                    labelForeground = new ColorUIResource(colorScheme.getForegroundColor());
                } else {
                    float aggrRed = 0.0f;
                    float aggrGreen = 0.0f;
                    float aggrBlue = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState activeState = activeEntry.getKey();
                        float contribution = activeEntry.getValue().getContribution();
                        RadianceColorScheme scheme = this.getColorSchemeForState(tree, ui, activeState);
                        Color schemeFg = scheme.getForegroundColor();
                        aggrRed += (float)schemeFg.getRed() * contribution;
                        aggrGreen += (float)schemeFg.getGreen() * contribution;
                        aggrBlue += (float)schemeFg.getBlue() * contribution;
                    }
                    labelForeground = new ColorUIResource(new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue));
                }
            } else {
                RadianceColorScheme scheme = this.getColorSchemeForState(tree, ui, currState);
                if (isDropLocation) {
                    scheme = RadianceColorSchemeUtilities.getColorScheme(tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, currState);
                }
                labelForeground = new ColorUIResource(scheme.getForegroundColor());
            }
        } else {
            labelForeground = selected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground");
        }
        this.setEnabled(tree.isEnabled());
        this.setFont(tree.getFont());
        this.bindData(tree, value, row);
        this.onPreRender(tree, value, row);
        for (JLabel jLabel : this.themeAwareLabels) {
            jLabel.setForeground(labelForeground);
        }
        for (Map.Entry entry : this.themeAwareLabelsWithIcons.entrySet()) {
            JLabel label = (JLabel)entry.getKey();
            IconData iconData = (IconData)entry.getValue();
            RadianceIcon icon = iconData.iconFactory.createNewIcon();
            icon.setColorFilter(color -> labelForeground);
            icon.setDimension(iconData.iconSize);
            label.setIcon((Icon)icon);
        }
        return this;
    }

    protected abstract void bindData(JTree var1, Object var2, int var3);

    protected void onPreRender(JTree tree, Object value, int row) {
    }

    private RadianceColorScheme getColorSchemeForState(JTree tree, RadianceTreeUI ui, ComponentState activeState) {
        RadianceColorScheme scheme;
        RadianceColorScheme radianceColorScheme = scheme = activeState == ComponentState.ENABLED ? ui.getDefaultColorScheme() : RadianceColorSchemeUtilities.getColorScheme(tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, activeState);
        if (scheme == null) {
            scheme = RadianceColorSchemeUtilities.getColorScheme(tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, activeState);
        }
        return scheme;
    }

    private static class IconData {
        private RadianceIcon.Factory iconFactory;
        private Dimension iconSize;

        private IconData(RadianceIcon.Factory iconFactory, Dimension iconSize) {
            this.iconFactory = iconFactory;
            this.iconSize = iconSize;
        }
    }
}

