/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.shaper;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.api.shaper.RectangularButtonShaper;
import org.pushingpixels.radiance.theming.internal.utils.HashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalArrowButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceBorder;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceButtonBorder;

public class PillButtonShaper
implements RadianceButtonShaper,
RectangularButtonShaper {
    private static final LazyResettableHashMap<Shape> contours = new LazyResettableHashMap("PillButtonShaper");

    @Override
    public String getDisplayName() {
        return "Pill";
    }

    @Override
    public Shape getButtonOutline(AbstractButton button, float extraInsets, float width, float height, double scaleFactor, boolean isInner) {
        HashMapKey key;
        Shape result;
        Set<RadianceThemingSlices.Side> straightSides = RadianceCoreUtilities.getSides(button, "radiance.theming.internal.buttonStraightSide");
        float radius = (float)scaleFactor * this.getCornerRadius(button, extraInsets);
        if (isInner && (radius -= 1.0f) < 0.0f) {
            radius = 0.0f;
        }
        if ((result = contours.get(key = RadianceCoreUtilities.getHashKey(Float.valueOf(width), Float.valueOf(height), straightSides, Float.valueOf(radius), Float.valueOf(extraInsets)))) != null) {
            return result;
        }
        result = RadianceOutlineUtilities.getBaseOutline(button.getComponentOrientation(), width - 1.0f, height - 1.0f, radius, straightSides, extraInsets);
        contours.put(key, result);
        return result;
    }

    @Override
    public Border getButtonBorder(final AbstractButton button) {
        return new RadianceButtonBorder(PillButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component c) {
                int fontSize = RadianceSizeUtils.getComponentFontSize(button);
                Insets buttonInsets = RadianceSizeUtils.getButtonInsets(button, fontSize);
                float focusPadding = RadianceSizeUtils.getFocusRingPadding(button, fontSize);
                int lrPadding = RadianceCoreUtilities.hasText(button) ? RadianceSizeUtils.getTextButtonLRPadding(fontSize) : 0;
                ComponentOrientation orientation = c.getComponentOrientation();
                RadianceThemingSlices.Side leftSide = orientation.isLeftToRight() ? RadianceThemingSlices.Side.LEADING : RadianceThemingSlices.Side.TRAILING;
                RadianceThemingSlices.Side rightSide = orientation.isLeftToRight() ? RadianceThemingSlices.Side.TRAILING : RadianceThemingSlices.Side.LEADING;
                Set<RadianceThemingSlices.Side> openSides = RadianceCoreUtilities.getSides(button, "radiance.theming.internal.buttonOpenSide");
                int left = lrPadding + buttonInsets.left + (int)focusPadding + (openSides != null && openSides.contains((Object)leftSide) ? -1 : 0);
                int right = lrPadding + buttonInsets.right + (int)focusPadding + (openSides != null && openSides.contains((Object)rightSide) ? -1 : 0);
                int top = buttonInsets.top + (openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.TOP) ? -1 : 0);
                int bottom = buttonInsets.bottom + (openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.BOTTOM) ? -1 : 0);
                return new Insets(top, left, bottom, right);
            }
        };
    }

    @Override
    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = button.getIcon();
        boolean hasIcon = RadianceCoreUtilities.hasIcon(button);
        boolean hasText = RadianceCoreUtilities.hasText(button);
        Insets margin = button.getMargin();
        Dimension result = uiPreferredSize;
        boolean hasNoMinSizeProperty = RadianceCoreUtilities.hasNoMinSizeProperty(button);
        if (!hasNoMinSizeProperty && hasText) {
            int baseWidth = uiPreferredSize.width;
            baseWidth = Math.max(baseWidth + uiPreferredSize.height, RadianceSizeUtils.getMinButtonWidth(RadianceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(baseWidth, uiPreferredSize.height);
            int baseHeight = result.height;
            result = new Dimension(result.width, baseHeight);
        } else if (hasNoMinSizeProperty && margin != null) {
            result = new Dimension(result.width + margin.left + margin.right, result.height + margin.top + margin.bottom);
        }
        int extraPadding = RadianceSizeUtils.getExtraPadding(RadianceSizeUtils.getComponentFontSize(button));
        int iconPaddingWidth = 6 + 2 * extraPadding;
        int iconPaddingHeight = 6 + 2 * extraPadding;
        if (margin != null) {
            iconPaddingWidth = Math.max(iconPaddingWidth, margin.left + margin.right);
            iconPaddingHeight = Math.max(iconPaddingHeight, margin.top + margin.bottom);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - (double)iconPaddingHeight) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - (double)iconPaddingWidth) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (RadianceCoreUtilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + iconPaddingWidth, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + iconPaddingHeight);
        }
        if (result.height % 2 != 0) {
            ++result.height;
        }
        return result;
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !RadianceCoreUtilities.isComboBoxButton(button) && RadianceCoreUtilities.hasText(button);
    }

    @Override
    public boolean isProportionate() {
        return true;
    }

    @Override
    public float getCornerRadius(AbstractButton button, float insets) {
        Border parentBorder;
        float width = (float)button.getWidth() - 2.0f * insets;
        float height = (float)button.getHeight() - 2.0f * insets;
        boolean isRoundCorners = PillButtonShaper.isRoundButton(button);
        float radius = RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(button));
        if (button.getClass().isAnnotationPresent(RadianceInternalArrowButton.class) && (parentBorder = ((JComponent)button.getParent()).getBorder()) instanceof RadianceBorder) {
            radius *= ((RadianceBorder)parentBorder).getRadiusScaleFactor();
        }
        if (isRoundCorners) {
            radius = width > height ? height / 2.0f : width / 2.0f;
        }
        if (RadianceCoreUtilities.isToolBarButton(button)) {
            radius = RadianceCoreUtilities.getToolbarButtonCornerRadius(button, insets);
        }
        return radius;
    }
}

