/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.skin;

import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceColorSchemeBundle;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.border.DelegateFractionBasedBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.decoration.MarbleNoiseDecorationPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.MatteFillPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.SpecularRectangularFillPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.TopShadowOverlayPainter;
import org.pushingpixels.radiance.theming.api.shaper.ClassicButtonShaper;

public class AutumnSkin
extends RadianceSkin {
    public static final String NAME = "Autumn";

    public AutumnSkin() {
        RadianceColorScheme enabledScheme;
        RadianceSkin.ColorSchemes schemes = RadianceSkin.getColorSchemes(this.getClass().getClassLoader().getResourceAsStream("org/pushingpixels/radiance/theming/api/skin/autumn.colorschemes"));
        RadianceColorScheme activeScheme = schemes.get("Autumn Active");
        RadianceColorScheme disabledScheme = enabledScheme = schemes.get("Autumn Enabled");
        RadianceColorSchemeBundle defaultSchemeBundle = new RadianceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        defaultSchemeBundle.registerAlpha(0.6f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(disabledScheme, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(activeScheme, ComponentState.DISABLED_SELECTED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, RadianceThemingSlices.DecorationAreaType.NONE);
        RadianceColorSchemeBundle titlePaneSchemeBundle = new RadianceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        titlePaneSchemeBundle.registerAlpha(0.6f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        titlePaneSchemeBundle.registerColorScheme(disabledScheme, ComponentState.DISABLED_UNSELECTED);
        titlePaneSchemeBundle.registerColorScheme(activeScheme, ComponentState.DISABLED_SELECTED);
        RadianceColorScheme borderScheme = enabledScheme.saturate(0.2f);
        titlePaneSchemeBundle.registerColorScheme(borderScheme, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        this.registerDecorationAreaSchemeBundle(titlePaneSchemeBundle, activeScheme, RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE, RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
        RadianceColorScheme backgroundScheme = schemes.get("Autumn Background");
        this.registerAsDecorationArea(activeScheme, RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE, RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE, RadianceThemingSlices.DecorationAreaType.HEADER);
        this.registerAsDecorationArea(backgroundScheme, RadianceThemingSlices.DecorationAreaType.CONTROL_PANE, RadianceThemingSlices.DecorationAreaType.FOOTER, RadianceThemingSlices.DecorationAreaType.TOOLBAR);
        this.addOverlayPainter(TopShadowOverlayPainter.getInstance(50), RadianceThemingSlices.DecorationAreaType.TOOLBAR);
        BottomLineOverlayPainter bottomLineOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.DARK);
        this.addOverlayPainter(bottomLineOverlayPainter, RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE, RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE, RadianceThemingSlices.DecorationAreaType.HEADER);
        this.buttonShaper = new ClassicButtonShaper();
        this.fillPainter = new SpecularRectangularFillPainter(new MatteFillPainter(), 1.0f);
        this.borderPainter = new CompositeBorderPainter(NAME, new DelegateFractionBasedBorderPainter("Autumn Outer", new ClassicBorderPainter(), new int[]{-1, -1, -1}, scheme -> scheme.shade(0.1f)), new DelegateFractionBasedBorderPainter("Autumn Inner", new ClassicBorderPainter(), new int[]{-1, -1, -1}, scheme -> scheme.tint(0.8f)));
        this.highlightFillPainter = new ClassicFillPainter();
        MarbleNoiseDecorationPainter decorationPainter = new MarbleNoiseDecorationPainter();
        decorationPainter.setTextureAlpha(0.7f);
        this.decorationPainter = decorationPainter;
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

