/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.UIDefaults;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingComponentPlugin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSkinPlugin;
import org.pushingpixels.radiance.theming.internal.plugin.BaseSkinPlugin;
import org.pushingpixels.radiance.theming.internal.plugin.ColorChooserPlugin;

public class RadiancePluginRepository {
    private Set<RadianceThemingComponentPlugin> componentPlugins = new HashSet<RadianceThemingComponentPlugin>();
    private Set<RadianceThemingSkinPlugin> skinPlugins = new HashSet<RadianceThemingSkinPlugin>();
    private static RadiancePluginRepository instance = new RadiancePluginRepository();

    public static RadiancePluginRepository getInstance() {
        if (RadiancePluginRepository.instance.componentPlugins.isEmpty()) {
            RadiancePluginRepository.instance.componentPlugins.add(new ColorChooserPlugin());
        }
        if (RadiancePluginRepository.instance.skinPlugins.isEmpty()) {
            RadiancePluginRepository.instance.skinPlugins.add(new BaseSkinPlugin());
        }
        return instance;
    }

    public synchronized void registerComponentPlugin(RadianceThemingComponentPlugin componentPlugin) {
        this.componentPlugins.add(componentPlugin);
    }

    public synchronized void unregisterComponentPlugin(RadianceThemingComponentPlugin componentPlugin) {
        this.componentPlugins.remove(componentPlugin);
    }

    public synchronized void registerSkinPlugin(RadianceThemingSkinPlugin skinPlugin) {
        this.skinPlugins.add(skinPlugin);
    }

    public synchronized void unregisterSkinPlugin(RadianceThemingSkinPlugin skinPlugin) {
        this.skinPlugins.remove(skinPlugin);
    }

    public synchronized Set<RadianceThemingComponentPlugin> getComponentPlugins() {
        return Collections.unmodifiableSet(this.componentPlugins);
    }

    public synchronized Set<RadianceThemingSkinPlugin> getSkinPlugins() {
        return Collections.unmodifiableSet(this.skinPlugins);
    }

    public void initializeAllComponentPlugins() {
        for (RadianceThemingComponentPlugin componentPlugin : this.componentPlugins) {
            componentPlugin.initialize();
        }
    }

    public void uninitializeAllComponentPlugins() {
        for (RadianceThemingComponentPlugin componentPlugin : this.componentPlugins) {
            componentPlugin.uninitialize();
        }
    }

    public void processAllDefaultsEntriesComponentPlugins(UIDefaults table, RadianceSkin skin) {
        for (RadianceThemingComponentPlugin componentPlugin : this.componentPlugins) {
            Object[] defaults = componentPlugin.getDefaults(skin);
            if (defaults == null) continue;
            table.putDefaults(defaults);
        }
    }
}

