/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.blade;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeTransitionAwareIcon;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAware;

@TransitionAware
public class BladeArrowButtonTransitionAwareIcon
implements Icon {
    private int iconWidth;
    private int iconHeight;
    private BladeTransitionAwareIcon.Delegate delegate;
    private JComponent component;
    private BladeTransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate;
    private BladeTransitionAwareIcon.ColorSchemeAssociationKindDelegate colorSchemeAssociationKindDelegate;
    private BladeColorScheme mutableColorScheme = new BladeColorScheme();

    public BladeArrowButtonTransitionAwareIcon(AbstractButton button, Dimension iconDimension, int orientation) {
        this(button, () -> (TransitionAwareUI)((Object)button.getUI()), iconDimension, orientation);
    }

    public BladeArrowButtonTransitionAwareIcon(final JComponent component, BladeTransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate, final Dimension iconDimension, final int orientation) {
        this.component = component;
        this.transitionAwareUIDelegate = transitionAwareUIDelegate;
        this.delegate = new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                int fontSize = RadianceSizeUtils.getComponentFontSize(component);
                BladeArrowIconUtils.drawArrow(g, fontSize, this.getIconDimension(), orientation, scheme, alpha);
            }

            @Override
            public Dimension getIconDimension() {
                return iconDimension;
            }
        };
        this.iconWidth = iconDimension.width;
        this.iconHeight = iconDimension.height;
        this.colorSchemeAssociationKindDelegate = state -> component instanceof JMenu && state.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) ? RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT : RadianceThemingSlices.ColorSchemeAssociationKind.MARK;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        StateTransitionTracker stateTransitionTracker = this.transitionAwareUIDelegate.getTransitionAwareUI().getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        float iconAlpha = RadianceColorSchemeUtilities.getAlpha(c, modelStateInfo.getCurrModelState());
        BladeUtils.populateColorScheme(this.mutableColorScheme, modelStateInfo, currState, BladeUtils.getDefaultColorSchemeDelegate(this.component, this.colorSchemeAssociationKindDelegate), false);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        this.delegate.drawColorSchemeIcon(graphics, this.mutableColorScheme, iconAlpha);
        graphics.dispose();
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }
}

