/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.blade;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class BladeArrowIconUtils {
    public static void drawArrow(Graphics2D g, int fontSize, Dimension boundingBox, int direction, RadianceColorScheme colorScheme, float alpha) {
        float origWidth = RadianceSizeUtils.getArrowIconWidth(fontSize);
        float origHeight = RadianceSizeUtils.getArrowIconHeight(fontSize);
        float width = origWidth;
        float height = origHeight;
        if (direction == 0) {
            height *= 2.0f;
        }
        float strokeWidth = RadianceSizeUtils.getArrowStrokeWidth(fontSize);
        int dx = (int)((float)boundingBox.width - width) / 2;
        int dy = (int)((float)boundingBox.height - height) / 2;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(dx, dy);
        BladeArrowIconUtils.drawArrow(graphics, width, height, strokeWidth, direction, colorScheme, alpha);
        graphics.dispose();
    }

    public static void drawArrow(Graphics2D g, float width, float height, float strokeWidth, int direction, RadianceColorScheme scheme, float alpha) {
        if (direction == 3 || direction == 7) {
            float tmp = width;
            width = height;
            height = tmp;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Color arrowColor = scheme.getMarkColor();
        graphics.setColor(RadianceColorUtilities.getAlphaColor(arrowColor, (int)(255.0f * alpha)));
        BasicStroke stroke = new BasicStroke(strokeWidth, 1, 0);
        graphics.setStroke(stroke);
        if (direction == 0) {
            float smallHeight = (height - strokeWidth) / 2.0f;
            BladeArrowIconUtils.drawArrow(graphics, width, smallHeight, strokeWidth, 1, scheme, alpha);
            graphics.translate(0, (int)((double)height / 2.0));
            BladeArrowIconUtils.drawArrow(graphics, width, smallHeight, strokeWidth, 5, scheme, alpha);
        } else {
            float cushion = strokeWidth / 2.0f;
            GeneralPath gp = new GeneralPath();
            switch (direction) {
                case 5: {
                    gp.moveTo(cushion, cushion);
                    gp.lineTo(0.5f * width, height - cushion - 1.0f);
                    gp.lineTo(width - cushion, cushion);
                    break;
                }
                case 1: {
                    gp.moveTo(cushion, height - cushion - 1.0f);
                    gp.lineTo(0.5f * width, cushion);
                    gp.lineTo(width - cushion, height - cushion - 1.0f);
                    break;
                }
                case 3: {
                    gp.moveTo(cushion, cushion);
                    gp.lineTo(width - 1.0f - cushion, 0.5f * height);
                    gp.lineTo(cushion, height - cushion);
                    break;
                }
                case 7: {
                    gp.moveTo(width - 1.0f - cushion, cushion);
                    gp.lineTo(cushion, 0.5f * height);
                    gp.lineTo(width - 1.0f - cushion, height - cushion);
                }
            }
            graphics.draw(gp);
        }
        graphics.dispose();
    }

    public static Dimension getArrowIconDimension(int fontSize, int direction) {
        float origHeight;
        float origWidth = RadianceSizeUtils.getArrowIconWidth(fontSize);
        float height = origHeight = RadianceSizeUtils.getArrowIconHeight(fontSize);
        if (direction == 0) {
            height *= 2.0f;
        }
        int finalWidth = (int)(Math.max(origWidth, origHeight) + 2.0f);
        int finalHeight = (int)(Math.max(origWidth, height) + 2.0f);
        return new Dimension(finalWidth, finalHeight);
    }

    public static Icon getArrowIcon(JComponent component, final int direction, final RadianceColorScheme scheme, final float alpha) {
        final int fontSize = RadianceSizeUtils.getComponentFontSize(component);
        final Dimension iconSize = BladeArrowIconUtils.getArrowIconDimension(fontSize, direction);
        return new Icon(){

            @Override
            public int getIconWidth() {
                return iconSize.width;
            }

            @Override
            public int getIconHeight() {
                return iconSize.height;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D graphics = (Graphics2D)g.create();
                graphics.translate(x, y);
                BladeArrowIconUtils.drawArrow(graphics, fontSize, iconSize, direction, scheme, alpha);
                graphics.dispose();
            }
        };
    }

    public static void drawDoubleArrow(Graphics2D g, float fullWidth, float fullHeight, float arrowGap, float strokeWidth, int direction, RadianceColorScheme colorScheme, float alpha) {
        boolean toggle = direction == 7 || direction == 3;
        int singleArrowWidth = toggle ? (int)fullHeight : (int)fullWidth;
        int singleArrowHeight = toggle ? (int)(fullWidth - arrowGap) : (int)(fullHeight - arrowGap);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (!toggle) {
            BladeArrowIconUtils.drawArrow(graphics, singleArrowWidth, singleArrowHeight, strokeWidth, direction, colorScheme, alpha);
            graphics.translate(0, (int)arrowGap);
            BladeArrowIconUtils.drawArrow(graphics, singleArrowWidth, singleArrowHeight, strokeWidth, direction, colorScheme, alpha);
        } else {
            BladeArrowIconUtils.drawArrow(graphics, singleArrowWidth, singleArrowHeight, strokeWidth, direction, colorScheme, alpha);
            graphics.translate((int)arrowGap, 0);
            BladeArrowIconUtils.drawArrow(graphics, singleArrowWidth, singleArrowHeight, strokeWidth, direction, colorScheme, alpha);
        }
        graphics.dispose();
    }
}

