/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.blade;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeTransitionAwareIcon;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAware;

@TransitionAware
public class BladeHighlightableTransitionAwareIcon
implements Icon {
    private int iconWidth;
    private int iconHeight;
    private BladeTransitionAwareIcon.Delegate delegate;
    private JComponent component;
    private BladeTransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate;
    private BladeColorScheme mutableColorScheme = new BladeColorScheme();
    private BladeTransitionAwareIcon.ColorSchemeAssociationKindDelegate colorSchemeAssociationKindDelegate;

    public BladeHighlightableTransitionAwareIcon(JComponent component, BladeTransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate, BladeTransitionAwareIcon.Delegate delegate, RadianceThemingSlices.ComponentStateFacet facetForHighlights) {
        this.component = component;
        this.transitionAwareUIDelegate = transitionAwareUIDelegate;
        this.delegate = delegate;
        this.colorSchemeAssociationKindDelegate = state -> state.isFacetActive(facetForHighlights) ? RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT : RadianceThemingSlices.ColorSchemeAssociationKind.MARK;
        Dimension dimension = this.delegate.getIconDimension();
        this.iconWidth = dimension.width;
        this.iconHeight = dimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        StateTransitionTracker stateTransitionTracker = this.transitionAwareUIDelegate.getTransitionAwareUI().getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        float iconAlpha = RadianceColorSchemeUtilities.getAlpha(c, modelStateInfo.getCurrModelState());
        BladeUtils.populateColorScheme(this.mutableColorScheme, modelStateInfo, currState, BladeUtils.getDefaultColorSchemeDelegate(this.component, this.colorSchemeAssociationKindDelegate), false);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        this.delegate.drawColorSchemeIcon(graphics, this.mutableColorScheme, iconAlpha);
        graphics.dispose();
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }
}

