/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.blade;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JTree;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.FlatBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class BladeIconUtils {
    public static void drawCheckBox(Graphics2D g, JComponent component, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int dimension, ComponentState componentState, RadianceColorScheme fillColorScheme, RadianceColorScheme markColorScheme, RadianceColorScheme borderColorScheme, float checkMarkVisibility, float checkMarkFlatness, boolean isCheckMarkFadingOut, float alpha) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)dimension, (int)dimension, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            float finalCheckMarkVisibility;
            float cornerRadius = (float)scaleFactor * RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(component));
            int contourDim = scaledWidth - 1;
            Shape contourOuter = RadianceOutlineUtilities.getBaseOutline(component.getComponentOrientation(), contourDim, contourDim, cornerRadius, null, 0.0f);
            RadianceFillPainter finalFillPainter = componentState.isActive() ? fillPainter : SimplisticSoftBorderReverseFillPainter.INSTANCE;
            graphics1X.setComposite(BladeIconUtils.getAlphaComposite(alpha));
            Shape contourFill = RadianceOutlineUtilities.getBaseOutline(component.getComponentOrientation(), contourDim + 1, contourDim + 1, cornerRadius, null, 0.5f);
            finalFillPainter.paintContourBackground(graphics1X, component, contourDim, contourDim, contourFill, fillColorScheme);
            Shape contourInner = borderPainter.isPaintingInnerContour() ? RadianceOutlineUtilities.getBaseOutline(component.getComponentOrientation(), contourDim, contourDim, cornerRadius, null, 1.0f) : null;
            borderPainter.paintBorder(graphics1X, component, contourDim, contourDim, contourOuter, contourInner, borderColorScheme);
            float f = finalCheckMarkVisibility = isCheckMarkFadingOut && checkMarkVisibility > 0.0f ? 1.0f : checkMarkVisibility;
            if ((double)finalCheckMarkVisibility > 0.0) {
                Graphics2D graphicsForCheckMark = (Graphics2D)graphics1X.create();
                if (isCheckMarkFadingOut) {
                    graphicsForCheckMark.setComposite(BladeIconUtils.getAlphaComposite(alpha * checkMarkVisibility));
                }
                BladeIconUtils.drawCheckMarkAtScale1X(graphicsForCheckMark, scaledWidth, markColorScheme, checkMarkFlatness);
                graphicsForCheckMark.dispose();
            }
        });
        graphics.dispose();
    }

    private static void drawCheckMarkAtScale1X(Graphics2D graphics1X, int dimension, RadianceColorScheme scheme, float checkMarkFlatness) {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.25f * (float)dimension, 0.47f * (float)dimension + 0.03f * (float)dimension * checkMarkFlatness);
        path.lineTo(0.48f * (float)dimension, 0.72f * (float)dimension - 0.22f * (float)dimension * checkMarkFlatness);
        path.lineTo(0.76f * (float)dimension, 0.27f * (float)dimension + 0.23f * (float)dimension * checkMarkFlatness);
        graphics1X.setColor(scheme.getMarkColor());
        BasicStroke stroke = new BasicStroke(0.15f * (float)dimension, 1, 1);
        graphics1X.setStroke(stroke);
        graphics1X.draw(path);
    }

    public static void drawRadioButton(Graphics2D g, AbstractButton button, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int dimension, ComponentState componentState, RadianceColorScheme fillColorScheme, RadianceColorScheme markColorScheme, RadianceColorScheme borderColorScheme, float checkMarkVisibility, float alpha) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)dimension, (int)dimension, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            int contourDim = scaledWidth;
            Ellipse2D.Float contourOuter = new Ellipse2D.Float(0.0f, 0.0f, contourDim, contourDim);
            RadianceFillPainter finalFillPainter = componentState.isActive() ? fillPainter : SimplisticSoftBorderReverseFillPainter.INSTANCE;
            graphics1X.setComposite(BladeIconUtils.getAlphaComposite(alpha));
            finalFillPainter.paintContourBackground(graphics1X, button, contourDim, contourDim, new Ellipse2D.Float(0.5f, 0.5f, contourDim, contourDim), fillColorScheme);
            Ellipse2D.Float contourInner = borderPainter.isPaintingInnerContour() ? new Ellipse2D.Float(1.0f, 1.0f, (float)contourDim - 2.0f, (float)contourDim - 2.0f) : null;
            borderPainter.paintBorder(graphics1X, button, contourDim, contourDim, contourOuter, contourInner, borderColorScheme);
            float rc = (float)contourDim / 2.0f + 0.5f;
            float radius = (float)contourDim / 4.5f;
            Ellipse2D.Double markOval = new Ellipse2D.Double(rc - radius, rc - radius, 2.0f * radius, 2.0f * radius);
            Graphics2D graphicsForCheckMark = (Graphics2D)graphics1X.create();
            if ((double)checkMarkVisibility > 0.0) {
                graphicsForCheckMark.setComposite(BladeIconUtils.getAlphaComposite(alpha * checkMarkVisibility));
                graphicsForCheckMark.setColor(markColorScheme.getMarkColor());
            } else {
                graphicsForCheckMark.setComposite(BladeIconUtils.getAlphaComposite(alpha * 0.3f));
                graphicsForCheckMark.setPaint(new GradientPaint(rc + radius, rc - radius, fillColorScheme.getDarkColor(), rc - radius, rc + radius, fillColorScheme.getLightColor()));
            }
            graphicsForCheckMark.fill(markOval);
            graphicsForCheckMark.dispose();
        });
        graphics.dispose();
    }

    public static void drawSliderThumbHorizontal(Graphics2D g, JSlider slider, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int width, int height, RadianceColorScheme fillColorScheme, RadianceColorScheme borderColorScheme, float alpha) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            graphics1X.setComposite(BladeIconUtils.getAlphaComposite(alpha));
            fillPainter.paintContourBackground(graphics1X, slider, scaledWidth, scaledHeight, RadianceOutlineUtilities.getTriangleButtonOutline(scaledWidth, scaledHeight, 2.0f * (float)scaleFactor, 1.5f), fillColorScheme);
            GeneralPath contourOuter = RadianceOutlineUtilities.getTriangleButtonOutline(scaledWidth, scaledHeight, 2.0f * (float)scaleFactor, 1.0f);
            GeneralPath contourInner = RadianceOutlineUtilities.getTriangleButtonOutline(scaledWidth, scaledHeight, 2.0f * (float)scaleFactor, 2.0f);
            borderPainter.paintBorder(graphics1X, slider, scaledWidth, scaledHeight, contourOuter, contourInner, borderColorScheme);
        });
        graphics.dispose();
    }

    public static void drawSliderThumbVertical(Graphics2D g, JSlider slider, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int width, int height, RadianceColorScheme fillColorScheme, RadianceColorScheme borderColorScheme, float alpha) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)height, (int)width, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            AffineTransform at = AffineTransform.getTranslateInstance(0.0, scaledHeight);
            at.rotate(-1.5707963267948966);
            graphics1X.transform(at);
            if (!slider.getComponentOrientation().isLeftToRight()) {
                AffineTransform mirror = AffineTransform.getTranslateInstance(scaledWidth, scaledHeight);
                mirror.rotate(Math.PI);
                graphics1X.transform(mirror);
            }
            graphics1X.setComposite(BladeIconUtils.getAlphaComposite(alpha));
            fillPainter.paintContourBackground(graphics1X, slider, scaledWidth, scaledHeight, RadianceOutlineUtilities.getTriangleButtonOutline(scaledWidth, scaledHeight, 2.0f * (float)scaleFactor, 1.5f), fillColorScheme);
            GeneralPath contourOuter = RadianceOutlineUtilities.getTriangleButtonOutline(scaledWidth, scaledHeight, 2.0f * (float)scaleFactor, 1.0f);
            GeneralPath contourInner = RadianceOutlineUtilities.getTriangleButtonOutline(scaledWidth, scaledHeight, 2.0f * (float)scaleFactor, 2.0f);
            borderPainter.paintBorder(graphics1X, slider, scaledWidth, scaledHeight, contourOuter, contourInner, borderColorScheme);
        });
        graphics.dispose();
    }

    public static void drawSliderThumbRound(Graphics2D g, JSlider slider, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int dimension, RadianceColorScheme fillColorScheme, RadianceColorScheme borderColorScheme, float alpha) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)dimension, (int)dimension, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            graphics1X.setComposite(BladeIconUtils.getAlphaComposite(alpha));
            fillPainter.paintContourBackground(graphics1X, slider, scaledWidth, scaledHeight, new Ellipse2D.Float(0.5f, 0.5f, (float)scaledWidth - 2.0f, (float)scaledHeight - 2.0f), fillColorScheme);
            Ellipse2D.Float contourOuter = new Ellipse2D.Float(0.0f, 0.0f, (float)scaledWidth - 1.0f, (float)scaledHeight - 1.0f);
            Ellipse2D.Float contourInner = new Ellipse2D.Float(1.0f, 1.0f, (float)scaledWidth - 3.0f, (float)scaledHeight - 3.0f);
            borderPainter.paintBorder(graphics1X, slider, scaledWidth, scaledHeight, contourOuter, contourInner, borderColorScheme);
        });
        graphics.dispose();
    }

    public static void drawTreeIcon(Graphics2D g, JTree tree, int size, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme, RadianceColorScheme markScheme, boolean isCollapsed) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)size, (int)size, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceFillPainter fillPainter = SimplisticSoftBorderReverseFillPainter.INSTANCE;
            FlatBorderPainter borderPainter = new FlatBorderPainter();
            Shape contour = RadianceOutlineUtilities.getBaseOutline(tree.getComponentOrientation(), scaledWidth, scaledHeight, (float)scaleFactor * RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(tree)) / 1.5f, null, 1.0f);
            fillPainter.paintContourBackground(graphics1X, tree, scaledWidth, scaledHeight, contour, fillScheme);
            borderPainter.paintBorder(graphics1X, tree, scaledWidth, scaledHeight, contour, null, borderScheme);
            Color signColor = markScheme.getForegroundColor();
            graphics1X.setColor(signColor);
            float mid = scaledWidth / 2;
            float length = 7 * scaledWidth / 12;
            graphics1X.setStroke(new BasicStroke(1.0f, 2, 1));
            graphics1X.draw(new Line2D.Float(mid - length / 2.0f, mid, mid + length / 2.0f, mid));
            if (isCollapsed) {
                graphics1X.draw(new Line2D.Float(mid, mid - length / 2.0f, mid, mid + length / 2.0f));
            }
        });
        graphics.dispose();
    }

    public static void drawCloseIcon(Graphics2D g, int iconSize, float primaryStrokeWidth, RadianceColorScheme scheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int start = iconSize / 4;
        int end = iconSize - start;
        Color primaryColor = scheme.getMarkColor();
        BasicStroke primaryStroke = new BasicStroke(primaryStrokeWidth, 1, 1);
        graphics.setStroke(primaryStroke);
        graphics.setColor(primaryColor);
        graphics.drawLine(start, start, end, end);
        graphics.drawLine(start, end, end, start);
        graphics.dispose();
    }

    public static void drawIconifyIcon(Graphics2D g, int iconSize, RadianceColorScheme scheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int start = iconSize / 4 - 2;
        int end = 3 * iconSize / 4;
        int size = end - start - 2;
        Color primaryColor = scheme.getMarkColor();
        graphics.setColor(primaryColor);
        graphics.fillRect(start + 2, end - 1, size, 3);
        graphics.dispose();
    }

    public static void drawMaximizeIcon(Graphics2D g, int iconSize, RadianceColorScheme scheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int start = iconSize / 4 - 1;
        int end = iconSize - start;
        Color primaryColor = scheme.getMarkColor();
        graphics.setColor(primaryColor);
        graphics.fillRect(start, start, end - start, 2);
        graphics.fillRect(start, start, 1, end - start);
        graphics.fillRect(end - 1, start, 1, end - start);
        graphics.fillRect(start, end - 1, end - start, 1);
        graphics.dispose();
    }

    public static void drawRestoreIcon(Graphics2D g, int iconSize, RadianceColorScheme scheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int start = iconSize / 4 - 1;
        int end = iconSize - start;
        int smallSquareSize = end - start - 3;
        Color primaryColor = scheme.getMarkColor();
        graphics.setColor(primaryColor);
        int mainStartX = start;
        int mainStartY = end - smallSquareSize;
        graphics.fillRect(mainStartX, mainStartY, smallSquareSize, 2);
        graphics.fillRect(mainStartX, mainStartY, 1, smallSquareSize);
        graphics.fillRect(mainStartX + smallSquareSize - 1, mainStartY, 1, smallSquareSize);
        graphics.fillRect(mainStartX, mainStartY + smallSquareSize - 1, smallSquareSize, 1);
        int secondaryStartX = mainStartX + 3;
        int secondaryStartY = mainStartY - 3;
        graphics.fillRect(secondaryStartX, secondaryStartY, smallSquareSize, 2);
        graphics.fillRect(secondaryStartX + smallSquareSize - 1, secondaryStartY, 1, smallSquareSize);
        graphics.fillRect(mainStartX + smallSquareSize + 1, secondaryStartY + smallSquareSize - 1, 2, 1);
        graphics.dispose();
    }

    public static void drawHexaMarker(Graphics2D g, int value, RadianceColorScheme colorScheme) {
        boolean isDark = colorScheme.isDark();
        Color offColor = isDark ? RadianceColorUtilities.getInterpolatedColor(colorScheme.getUltraLightColor(), Color.white, 0.7) : RadianceColorUtilities.deriveByBrightness(colorScheme.getMidColor(), -0.6f);
        Color onColor = isDark ? RadianceColorUtilities.getInterpolatedColor(colorScheme.getUltraLightColor(), Color.white, 0.2) : colorScheme.getForegroundColor();
        boolean bit1 = ((value %= 16) & 1) != 0;
        boolean bit2 = (value & 2) != 0;
        boolean bit3 = (value & 4) != 0;
        boolean bit4 = (value & 8) != 0;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(bit1 ? onColor : offColor);
        graphics.fillOval(5, 5, 4, 4);
        graphics.setColor(bit2 ? onColor : offColor);
        graphics.fillOval(5, 0, 4, 4);
        graphics.setColor(bit3 ? onColor : offColor);
        graphics.fillOval(0, 5, 4, 4);
        graphics.setColor(bit4 ? onColor : offColor);
        graphics.fillOval(0, 0, 4, 4);
        graphics.dispose();
    }

    private static AlphaComposite getAlphaComposite(float alpha) {
        float finalAlpha = alpha;
        if (finalAlpha < 0.0f) {
            finalAlpha = 0.0f;
        } else if (finalAlpha > 1.0f) {
            finalAlpha = 1.0f;
        }
        return AlphaComposite.getInstance(3, finalAlpha);
    }

    private static class SimplisticSoftBorderReverseFillPainter
    extends FractionBasedFillPainter {
        public static final RadianceFillPainter INSTANCE = new SimplisticSoftBorderReverseFillPainter();

        private SimplisticSoftBorderReverseFillPainter() {
            super("Simplistic Soft Border Reverse", new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRALIGHT, scheme -> RadianceColorUtilities.getInterpolatedColor(scheme.getMidColor(), scheme.getUltraLightColor(), 0.5), ColorSchemeSingleColorQuery.MID});
        }
    }
}

