/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.blade;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAware;

@TransitionAware
public class BladeTransitionAwareIcon
implements Icon {
    private static ColorSchemeAssociationKindDelegate MARK_DELEGATE = state -> RadianceThemingSlices.ColorSchemeAssociationKind.MARK;
    private TransitionAwareUIDelegate transitionAwareUIDelegate;
    private Delegate delegate;
    private ColorSchemeAssociationKindDelegate colorSchemeAssociationKindDelegate;
    private int iconWidth;
    private int iconHeight;
    private BladeColorScheme mutableColorScheme = new BladeColorScheme();

    public BladeTransitionAwareIcon(AbstractButton button, Delegate delegate) {
        this(button == null ? null : () -> (TransitionAwareUI)((Object)button.getUI()), delegate, null);
    }

    public BladeTransitionAwareIcon(TransitionAwareUIDelegate transitionAwareUIDelegate, Delegate delegate, ColorSchemeAssociationKindDelegate colorSchemeAssociationKindDelegate) {
        this.transitionAwareUIDelegate = transitionAwareUIDelegate;
        this.delegate = delegate;
        this.colorSchemeAssociationKindDelegate = colorSchemeAssociationKindDelegate != null ? colorSchemeAssociationKindDelegate : MARK_DELEGATE;
        Dimension iconDimension = this.delegate.getIconDimension();
        this.iconWidth = iconDimension.width;
        this.iconHeight = iconDimension.height;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        StateTransitionTracker.ModelStateInfo modelStateInfo;
        float iconAlpha = 0.0f;
        if (this.transitionAwareUIDelegate != null) {
            StateTransitionTracker stateTransitionTracker = this.transitionAwareUIDelegate.getTransitionAwareUI().getTransitionTracker();
            modelStateInfo = stateTransitionTracker.getModelStateInfo();
            iconAlpha = RadianceColorSchemeUtilities.getAlpha(c, modelStateInfo.getCurrModelState());
        } else if (c instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)c;
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)ab.getUI());
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            modelStateInfo = stateTransitionTracker.getModelStateInfo();
            iconAlpha = RadianceColorSchemeUtilities.getAlpha(c, modelStateInfo.getCurrModelState());
        } else {
            return;
        }
        ComponentState currState = modelStateInfo.getCurrModelState();
        boolean isComponentNeverPainted = RadianceCoreUtilities.isComponentNeverPainted(c);
        if (isComponentNeverPainted && currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ENABLE)) {
            currState = ComponentState.ENABLED;
        }
        BladeUtils.populateColorScheme(this.mutableColorScheme, modelStateInfo, currState, BladeUtils.getDefaultColorSchemeDelegate(c, this.colorSchemeAssociationKindDelegate), false);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        this.delegate.drawColorSchemeIcon(graphics, this.mutableColorScheme, iconAlpha);
        graphics.dispose();
    }

    @FunctionalInterface
    public static interface TransitionAwareUIDelegate {
        public TransitionAwareUI getTransitionAwareUI();
    }

    @FunctionalInterface
    public static interface ColorSchemeAssociationKindDelegate {
        public RadianceThemingSlices.ColorSchemeAssociationKind getColorSchemeAssociationKind(ComponentState var1);
    }

    public static interface Delegate {
        public void drawColorSchemeIcon(Graphics2D var1, RadianceColorScheme var2, float var3);

        public Dimension getIconDimension();
    }
}

