/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.colorscheme;

import java.awt.Color;
import org.pushingpixels.radiance.theming.api.colorscheme.BaseColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;

public class BlendBiColorScheme
extends BaseColorScheme {
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private RadianceColorScheme firstScheme;
    private RadianceColorScheme secondScheme;
    private double firstSchemeLikeness;

    public BlendBiColorScheme(RadianceColorScheme firstScheme, RadianceColorScheme secondScheme, double firstSchemeLikeness) {
        super("Blended " + firstScheme.getDisplayName() + " & " + secondScheme.getDisplayName() + " " + firstSchemeLikeness, firstScheme.isDark());
        this.firstScheme = firstScheme;
        this.secondScheme = secondScheme;
        this.firstSchemeLikeness = firstSchemeLikeness;
        this.foregroundColor = new Color(RadianceColorUtilities.getInterpolatedRGB(firstScheme.getForegroundColor(), secondScheme.getForegroundColor(), firstSchemeLikeness));
        this.mainUltraDarkColor = new Color(RadianceColorUtilities.getInterpolatedRGB(firstScheme.getUltraDarkColor(), secondScheme.getUltraDarkColor(), firstSchemeLikeness));
        this.mainDarkColor = new Color(RadianceColorUtilities.getInterpolatedRGB(firstScheme.getDarkColor(), secondScheme.getDarkColor(), firstSchemeLikeness));
        this.mainMidColor = new Color(RadianceColorUtilities.getInterpolatedRGB(firstScheme.getMidColor(), secondScheme.getMidColor(), firstSchemeLikeness));
        this.mainLightColor = new Color(RadianceColorUtilities.getInterpolatedRGB(firstScheme.getLightColor(), secondScheme.getLightColor(), firstSchemeLikeness));
        this.mainExtraLightColor = new Color(RadianceColorUtilities.getInterpolatedRGB(firstScheme.getExtraLightColor(), secondScheme.getExtraLightColor(), firstSchemeLikeness));
        this.mainUltraLightColor = new Color(RadianceColorUtilities.getInterpolatedRGB(firstScheme.getUltraLightColor(), secondScheme.getUltraLightColor(), firstSchemeLikeness));
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    @Override
    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    @Override
    public Color getLightColor() {
        return this.mainLightColor;
    }

    @Override
    public Color getMidColor() {
        return this.mainMidColor;
    }

    @Override
    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    @Override
    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public double getFirstSchemeLikeness() {
        return this.firstSchemeLikeness;
    }

    public RadianceColorScheme getFirstScheme() {
        return this.firstScheme;
    }

    public RadianceColorScheme getSecondScheme() {
        return this.secondScheme;
    }
}

