/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.colorscheme;

import java.awt.Color;
import org.pushingpixels.radiance.theming.api.colorscheme.BaseColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;

public class SaturatedColorScheme
extends BaseColorScheme {
    private double saturationFactor;
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private RadianceColorScheme origScheme;

    public SaturatedColorScheme(RadianceColorScheme origScheme, double saturationFactor) {
        super("Saturated (" + (int)(100.0 * saturationFactor) + "%) " + origScheme.getDisplayName(), origScheme.isDark());
        this.saturationFactor = saturationFactor;
        this.origScheme = origScheme;
        this.foregroundColor = origScheme.getForegroundColor();
        this.mainUltraDarkColor = RadianceColorUtilities.getSaturatedColor(origScheme.getUltraDarkColor(), saturationFactor);
        this.mainDarkColor = RadianceColorUtilities.getSaturatedColor(origScheme.getDarkColor(), saturationFactor);
        this.mainMidColor = RadianceColorUtilities.getSaturatedColor(origScheme.getMidColor(), saturationFactor);
        this.mainLightColor = RadianceColorUtilities.getSaturatedColor(origScheme.getLightColor(), saturationFactor);
        this.mainExtraLightColor = RadianceColorUtilities.getSaturatedColor(origScheme.getExtraLightColor(), saturationFactor);
        this.mainUltraLightColor = RadianceColorUtilities.getSaturatedColor(origScheme.getUltraLightColor(), saturationFactor);
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    @Override
    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    @Override
    public Color getLightColor() {
        return this.mainLightColor;
    }

    @Override
    public Color getMidColor() {
        return this.mainMidColor;
    }

    @Override
    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    @Override
    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public RadianceColorScheme getOrigScheme() {
        return this.origScheme;
    }

    public double getSaturationFactor() {
        return this.saturationFactor;
    }
}

