/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.painter;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.decoration.RadianceDecorationPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class DecorationPainterUtils {
    private static final String DECORATION_AREA_TYPE = "radiance.theming.internal.painter.decorationAreaType";
    public static final String POPUP_ORIGINATOR_LINK = "radiance.theming.internal.popupOriginatorLink";

    public static void setDecorationType(JComponent comp, RadianceThemingSlices.DecorationAreaType type) {
        comp.putClientProperty(DECORATION_AREA_TYPE, type);
    }

    public static void clearDecorationType(JComponent comp) {
        if (comp != null) {
            comp.putClientProperty(DECORATION_AREA_TYPE, null);
        }
    }

    public static RadianceThemingSlices.DecorationAreaType getDecorationType(Component comp) {
        Component invoker;
        JPopupMenu popupMenu = null;
        JComponent popupOriginator = null;
        for (Component c = comp; c != null; c = c.getParent()) {
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                Object prop = jc.getClientProperty(DECORATION_AREA_TYPE);
                if (prop instanceof RadianceThemingSlices.DecorationAreaType) {
                    return (RadianceThemingSlices.DecorationAreaType)prop;
                }
                Object invokerProp = jc.getClientProperty(POPUP_ORIGINATOR_LINK);
                if (invokerProp instanceof PopupOriginatorLink) {
                    popupOriginator = ((PopupOriginatorLink)invokerProp).getPopupOriginator();
                }
            }
            if (!(c instanceof JPopupMenu)) continue;
            popupMenu = (JPopupMenu)c;
        }
        if (popupMenu != null && popupMenu != (invoker = popupMenu.getInvoker())) {
            return DecorationPainterUtils.getDecorationType(popupMenu.getInvoker());
        }
        if (popupOriginator != null) {
            return DecorationPainterUtils.getDecorationType(popupOriginator);
        }
        return RadianceThemingSlices.DecorationAreaType.NONE;
    }

    public static RadianceThemingSlices.DecorationAreaType getImmediateDecorationType(Component comp) {
        JComponent jc;
        Object prop;
        Component c = comp;
        if (c instanceof JComponent && (prop = (jc = (JComponent)c).getClientProperty(DECORATION_AREA_TYPE)) instanceof RadianceThemingSlices.DecorationAreaType) {
            return (RadianceThemingSlices.DecorationAreaType)prop;
        }
        return null;
    }

    public static void paintDecorationBackground(Graphics g, Component c, boolean force) {
        RadianceThemingSlices.DecorationAreaType decorationType = RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(c);
        DecorationPainterUtils.paintDecorationBackground(g, c, decorationType, force);
    }

    private static void paintDecorationBackground(Graphics g, Component c, RadianceThemingSlices.DecorationAreaType decorationType, boolean force) {
        boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("radiance.theming.internal.widget.previewMode"));
        }
        if (!(force || isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        if (c.getHeight() == 0 || c.getWidth() == 0) {
            return;
        }
        RadianceSkin skin = RadianceCoreUtilities.getSkin(c);
        RadianceDecorationPainter painter = skin.getDecorationPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        painter.paintDecorationArea(g2d, c, decorationType, c.getWidth(), c.getHeight(), skin);
        g2d.dispose();
    }

    public static void paintDecorationArea(Graphics g, Component c, Shape contour, RadianceThemingSlices.DecorationAreaType decorationType, RadianceColorScheme colorScheme, boolean force) {
        boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("radiance.theming.internal.widget.previewMode"));
        }
        if (!(force || isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        if (c.getHeight() == 0 || c.getWidth() == 0) {
            return;
        }
        RadianceSkin skin = RadianceCoreUtilities.getSkin(c);
        RadianceDecorationPainter painter = skin.getDecorationPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        painter.paintDecorationArea(g2d, c, decorationType, contour, colorScheme);
        g2d.dispose();
    }

    public static interface PopupOriginatorLink {
        public JComponent getPopupOriginator();
    }
}

