/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.painter;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.CellRendererPane;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class HighlightPainterUtils {
    public static void paintHighlight(Graphics g, CellRendererPane rendererPane, Component c, Rectangle rect, float borderAlpha, Set<RadianceThemingSlices.Side> openSides, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme) {
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        Component compForQuerying = rendererPane != null ? rendererPane : c;
        RadianceSkin skin = RadianceCoreUtilities.getSkin(compForQuerying);
        RadianceFillPainter highlightPainter = skin.getHighlightFillPainter();
        RadianceBorderPainter highlightBorderPainter = RadianceCoreUtilities.getHighlightBorderPainter(compForQuerying);
        Graphics2D g2d = (Graphics2D)g.create();
        if (openSides == null) {
            openSides = EnumSet.noneOf(RadianceThemingSlices.Side.class);
        }
        HighlightPainterUtils.paintHighlight(g2d, c, rect, borderAlpha, openSides, fillScheme, borderScheme, highlightPainter, highlightBorderPainter);
        g2d.dispose();
    }

    private static void paintHighlight(Graphics g, Component c, Rectangle rect, float borderAlpha, Set<RadianceThemingSlices.Side> openSides, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme, RadianceFillPainter highlightPainter, RadianceBorderPainter highlightBorderPainter) {
        Graphics2D g2d = (Graphics2D)g.create();
        highlightPainter.paintContourBackground(g2d, c, rect.width, rect.height, rect, fillScheme);
        g2d.translate(rect.x, rect.y);
        HighlightPainterUtils.paintHighlightBorder1X(g2d, c, rect.width, rect.height, borderAlpha, openSides, highlightBorderPainter, borderScheme);
        g2d.dispose();
    }

    public static void paintHighlightBorder1X(Graphics2D g, Component comp, int width, int height, float borderAlpha, Set<RadianceThemingSlices.Side> openSides, RadianceBorderPainter highlightBorderPainter, RadianceColorScheme borderScheme) {
        if (borderAlpha <= 0.0f) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            ComponentOrientation orientation = comp.getComponentOrientation();
            RadianceThemingSlices.Side leftSide = orientation.isLeftToRight() ? RadianceThemingSlices.Side.LEADING : RadianceThemingSlices.Side.TRAILING;
            RadianceThemingSlices.Side rightSide = orientation.isLeftToRight() ? RadianceThemingSlices.Side.TRAILING : RadianceThemingSlices.Side.LEADING;
            int openDelta = (int)(scaleFactor * 6.0);
            int deltaLeft = openSides.contains((Object)leftSide) ? openDelta : 0;
            int deltaRight = openSides.contains((Object)rightSide) ? openDelta : 0;
            int deltaTop = openSides.contains((Object)RadianceThemingSlices.Side.TOP) ? openDelta : 0;
            int deltaBottom = openSides.contains((Object)RadianceThemingSlices.Side.BOTTOM) ? openDelta : 0;
            Path2D contour = HighlightPainterUtils.getBorderPath(orientation, scaledWidth, scaledHeight, 0.0f, openSides);
            graphics1X.setComposite(WidgetUtilities.getAlphaComposite(comp, borderAlpha, graphics1X));
            Path2D contourInner = HighlightPainterUtils.getBorderPath(orientation, scaledWidth, scaledHeight, 1.0f, openSides);
            highlightBorderPainter.paintBorder(graphics1X, comp, scaledWidth + deltaLeft + deltaRight, scaledHeight + deltaTop + deltaBottom, contour, contourInner, borderScheme);
            graphics1X.translate(deltaLeft, deltaTop);
        });
        graphics.dispose();
    }

    private static Path2D getBorderPath(ComponentOrientation orientation, int width, int height, float insets, Set<RadianceThemingSlices.Side> openSides) {
        RadianceThemingSlices.Side leftSide = orientation.isLeftToRight() ? RadianceThemingSlices.Side.LEADING : RadianceThemingSlices.Side.TRAILING;
        RadianceThemingSlices.Side rightSide = orientation.isLeftToRight() ? RadianceThemingSlices.Side.TRAILING : RadianceThemingSlices.Side.LEADING;
        Path2D.Float result = new Path2D.Float();
        ((Path2D)result).moveTo(insets, insets);
        if (openSides.contains((Object)RadianceThemingSlices.Side.TOP)) {
            ((Path2D)result).moveTo((float)width - 1.0f - insets, insets);
        } else {
            ((Path2D)result).lineTo((float)width - 1.0f - insets, insets);
        }
        if (openSides.contains((Object)rightSide)) {
            ((Path2D)result).moveTo((float)width - 1.0f - insets, (float)height - 1.0f - insets);
        } else {
            ((Path2D)result).lineTo((float)width - 1.0f - insets, (float)height - 1.0f - insets);
        }
        if (openSides.contains((Object)RadianceThemingSlices.Side.BOTTOM)) {
            ((Path2D)result).moveTo(insets, (float)height - 1.0f - insets);
        } else {
            ((Path2D)result).lineTo(insets, (float)height - 1.0f - insets);
        }
        if (openSides.contains((Object)leftSide)) {
            ((Path2D)result).moveTo(insets, insets);
        } else {
            ((Path2D)result).lineTo(insets, insets);
        }
        return result;
    }
}

