/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class SeparatorPainterUtils {
    public static void paintSeparator(JSeparator separator, Graphics graphics, int width, int height, int orientation) {
        int fadeLength = RadianceCoreUtilities.getSeparatorAppearance(separator) == RadianceThemingSlices.SeparatorAppearance.SOFT ? 10 : 0;
        SeparatorPainterUtils.paintSeparator(separator, graphics, width, height, orientation, true, fadeLength);
    }

    public static void paintSeparator(Component c, Graphics graphics, int width, int height, int orientation, boolean hasShadow, int maxGradLength) {
        SeparatorPainterUtils.paintSeparator(c, graphics, width, height, orientation, hasShadow, maxGradLength, maxGradLength, false);
    }

    public static void paintSeparator(Component c, Graphics g, int width, int height, int orientation, boolean hasShadow, int maxGradLengthStart, int maxGradLengthEnd, boolean toEnforceAlphaColors) {
        boolean isParentAPopup;
        RadianceColorScheme compScheme = null;
        Container parent = c.getParent();
        boolean bl = isParentAPopup = parent instanceof JPopupMenu || parent instanceof JComponent && ((JComponent)parent).getClientProperty("radiance.theming.internal.popupOriginatorLink") != null;
        if (isParentAPopup && (compScheme = RadianceColorSchemeUtilities.getDirectColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED)) == null) {
            compScheme = RadianceCoreUtilities.getSkin(c).getBackgroundColorScheme(RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(c));
        }
        if (compScheme == null) {
            compScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        }
        SeparatorPainterUtils.paintSeparator(c, g, compScheme, width, height, orientation, hasShadow, maxGradLengthStart, maxGradLengthEnd, toEnforceAlphaColors);
    }

    public static void paintSeparator(Component c, Graphics g, RadianceColorScheme scheme, int width, int height, int orientation, boolean hasShadow, int maxGradLengthStart, int maxGradLengthEnd, boolean toEnforceAlphaColors) {
        if (orientation == 0) {
            height = 1;
        }
        if (orientation == 1) {
            width = 1;
        }
        if (width == 0 || height == 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceThemingSlices.DecorationAreaType decorationAreaType = RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(c);
            RadianceSkin skin = RadianceCoreUtilities.getSkin(c);
            boolean toUseAlphaColors = decorationAreaType == RadianceThemingSlices.DecorationAreaType.NONE ? false : skin.isRegisteredAsDecorationArea(decorationAreaType) || !skin.getOverlayPainters(decorationAreaType).isEmpty();
            toUseAlphaColors = toUseAlphaColors || toEnforceAlphaColors;
            Color backgroundFill = RadianceColorUtilities.getBackgroundFillColor(c);
            Color primary = scheme.getSeparatorPrimaryColor();
            Color secondary = scheme.getSeparatorSecondaryColor();
            Color primaryZero = toUseAlphaColors ? RadianceColorUtilities.getAlphaColor(primary, 0) : RadianceColorUtilities.getInterpolatedColor(primary, backgroundFill, 0.0);
            Color secondaryZero = toUseAlphaColors ? RadianceColorUtilities.getAlphaColor(secondary, 0) : RadianceColorUtilities.getInterpolatedColor(secondary, backgroundFill, 0.0);
            graphics1X.setStroke(new BasicStroke(1.0f, 0, 1));
            if (orientation == 1) {
                int gradStart = Math.min(maxGradLengthStart, scaledHeight / 2);
                int gradEnd = Math.min(maxGradLengthEnd, scaledHeight / 2);
                float gradStartFraction = (float)gradStart / (float)scaledHeight;
                float gradEndFraction = (float)(scaledHeight - gradEnd) / (float)scaledHeight;
                float regularX = Math.max(0.0f, (float)scaledWidth / 2.0f - 1.0f);
                int stopsCount = (gradStartFraction > 0.0f ? 1 : 0) + 1 + (gradEndFraction > gradStartFraction ? 1 : 0) + (gradEndFraction < 1.0f ? 1 : 0);
                float[] stops = new float[stopsCount];
                Color[] colors = new Color[stopsCount];
                int stopIndex = 0;
                if (gradStartFraction > 0.0f) {
                    stops[stopIndex] = 0.0f;
                    colors[stopIndex] = primaryZero;
                    ++stopIndex;
                }
                stops[stopIndex] = gradStartFraction;
                colors[stopIndex] = primary;
                ++stopIndex;
                if (gradEndFraction > gradStartFraction) {
                    stops[stopIndex] = gradEndFraction;
                    colors[stopIndex] = primary;
                    ++stopIndex;
                }
                if (gradEndFraction < 1.0f) {
                    stops[stopIndex] = 1.0f;
                    colors[stopIndex] = primaryZero;
                }
                LinearGradientPaint primaryPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, scaledHeight, stops, colors);
                graphics1X.setPaint(primaryPaint);
                graphics1X.draw(new Line2D.Float(regularX, 0.0f, regularX, scaledHeight));
                if (hasShadow) {
                    float shadowX = regularX + 1.0f;
                    stopIndex = 0;
                    if (gradStartFraction > 0.0f) {
                        stops[stopIndex] = 0.0f;
                        colors[stopIndex] = secondaryZero;
                        ++stopIndex;
                    }
                    stops[stopIndex] = gradStartFraction;
                    colors[stopIndex] = secondary;
                    ++stopIndex;
                    if (gradEndFraction > gradStartFraction) {
                        stops[stopIndex] = gradEndFraction;
                        colors[stopIndex] = secondary;
                        ++stopIndex;
                    }
                    if (gradEndFraction < 1.0f) {
                        stops[stopIndex] = 1.0f;
                        colors[stopIndex] = secondaryZero;
                    }
                    LinearGradientPaint secondaryPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, scaledHeight, stops, colors);
                    graphics1X.setPaint(secondaryPaint);
                    graphics1X.draw(new Line2D.Float(shadowX, 0.0f, shadowX, scaledHeight));
                }
            } else {
                int gradStart = Math.min(maxGradLengthStart, scaledWidth / 2);
                int gradEnd = Math.min(maxGradLengthEnd, scaledWidth / 2);
                graphics1X.translate(0, Math.max(0, scaledHeight / 2 - 1));
                float gradStartFraction = (float)gradStart / (float)scaledWidth;
                float gradEndFraction = (float)(scaledWidth - gradEnd) / (float)scaledWidth;
                float regularY = Math.max(0.0f, (float)scaledHeight / 2.0f - 1.0f);
                int stopsCount = (gradStartFraction > 0.0f ? 1 : 0) + 1 + (gradEndFraction > gradStartFraction ? 1 : 0) + (gradEndFraction < 1.0f ? 1 : 0);
                float[] stops = new float[stopsCount];
                Color[] colors = new Color[stopsCount];
                int stopIndex = 0;
                if (gradStartFraction > 0.0f) {
                    stops[stopIndex] = 0.0f;
                    colors[stopIndex] = primaryZero;
                    ++stopIndex;
                }
                stops[stopIndex] = gradStartFraction;
                colors[stopIndex] = primary;
                ++stopIndex;
                if (gradEndFraction > gradStartFraction) {
                    stops[stopIndex] = gradEndFraction;
                    colors[stopIndex] = primary;
                    ++stopIndex;
                }
                if (gradEndFraction < 1.0f) {
                    stops[stopIndex] = 1.0f;
                    colors[stopIndex] = primaryZero;
                }
                LinearGradientPaint primaryPaint = new LinearGradientPaint(0.0f, 0.0f, scaledWidth, 0.0f, stops, colors);
                graphics1X.setPaint(primaryPaint);
                graphics1X.draw(new Line2D.Float(0.0f, regularY, scaledWidth, regularY));
                if (hasShadow) {
                    float shadowY = regularY + 1.0f;
                    stopIndex = 0;
                    if (gradStartFraction > 0.0f) {
                        stops[stopIndex] = 0.0f;
                        colors[stopIndex] = secondaryZero;
                        ++stopIndex;
                    }
                    stops[stopIndex] = gradStartFraction;
                    colors[stopIndex] = secondary;
                    ++stopIndex;
                    if (gradEndFraction > gradStartFraction) {
                        stops[stopIndex] = gradEndFraction;
                        colors[stopIndex] = secondary;
                        ++stopIndex;
                    }
                    if (gradEndFraction < 1.0f) {
                        stops[stopIndex] = 1.0f;
                        colors[stopIndex] = secondaryZero;
                    }
                    LinearGradientPaint secondaryPaint = new LinearGradientPaint(0.0f, 0.0f, scaledWidth, 0.0f, stops, colors);
                    graphics1X.setPaint(secondaryPaint);
                    graphics1X.draw(new Line2D.Float(0.0f, shadowY, scaledWidth, shadowY));
                }
            }
        });
        graphics.dispose();
    }

    public static void paintVerticalLines(Graphics g, Component c, RadianceColorScheme scheme, int y, Collection<Integer> x, int height, float fadeStartFraction) {
        if (x.isEmpty()) {
            return;
        }
        int minX = Collections.min(x);
        int maxX = Collections.max(x);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(minX, y);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)(maxX - minX + 1), (int)height, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            Color backgroundFill = RadianceColorUtilities.getBackgroundFillColor(c);
            Color primary = scheme.getSeparatorPrimaryColor();
            Color secondary = scheme.getSeparatorSecondaryColor();
            Color primaryZero = RadianceColorUtilities.getInterpolatedColor(primary, backgroundFill, 0.0);
            Color secondaryZero = RadianceColorUtilities.getInterpolatedColor(secondary, backgroundFill, 0.0);
            graphics1X.setStroke(new BasicStroke(1.0f, 0, 1));
            Iterator iterator = x.iterator();
            while (iterator.hasNext()) {
                int lineX = (Integer)iterator.next();
                int xOffset = (int)(scaleFactor * (double)(lineX - minX));
                LinearGradientPaint forePaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, scaledHeight, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{primary, primary, primaryZero});
                graphics1X.setPaint(forePaint);
                graphics1X.drawLine(xOffset, 0, xOffset, scaledHeight);
                LinearGradientPaint backPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, scaledHeight, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{secondary, secondary, secondaryZero});
                graphics1X.setPaint(backPaint);
                graphics1X.drawLine(xOffset + 1, 0, xOffset + 1, scaledHeight);
            }
        });
    }

    public static void paintHorizontalLines(Graphics g, Component c, RadianceColorScheme scheme, int x, Collection<Integer> y, int width, float fadeStartFraction, boolean isLtr) {
        if (y.isEmpty()) {
            return;
        }
        int minY = Collections.min(y);
        int maxY = Collections.max(y);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, minY);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)(maxY - minY + 1), (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            Color backgroundFill = RadianceColorUtilities.getBackgroundFillColor(c);
            Color primary = scheme.getSeparatorPrimaryColor();
            Color secondary = scheme.getSeparatorSecondaryColor();
            Color primaryZero = RadianceColorUtilities.getInterpolatedColor(primary, backgroundFill, 0.0);
            Color secondaryZero = RadianceColorUtilities.getInterpolatedColor(secondary, backgroundFill, 0.0);
            graphics1X.setStroke(new BasicStroke(1.0f, 0, 1));
            Iterator iterator = y.iterator();
            while (iterator.hasNext()) {
                int lineY = (Integer)iterator.next();
                int yOffset = (int)(scaleFactor * (double)(lineY - minY));
                LinearGradientPaint forePaint = new LinearGradientPaint(0.0f, 0.0f, scaledWidth, 0.0f, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{isLtr ? primary : primaryZero, primary, isLtr ? primaryZero : primary});
                graphics1X.setPaint(forePaint);
                graphics1X.drawLine(0, yOffset, scaledWidth, yOffset);
                LinearGradientPaint backPaint = new LinearGradientPaint(0.0f, 0.0f, scaledWidth, 0.0f, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{isLtr ? secondary : secondaryZero, secondary, isLtr ? secondaryZero : secondary});
                graphics1X.setPaint(backPaint);
                graphics1X.drawLine(0, yOffset + 1, scaledWidth, yOffset + 1);
            }
        });
    }
}

