/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.blade.BladeIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceRadioButtonUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RolloverButtonListener;

public class RadianceCheckBoxUI
extends RadianceRadioButtonUI {
    private static final String propertyPrefix = "CheckBox.";

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceCheckBoxUI((JToggleButton)comp);
    }

    protected RadianceCheckBoxUI(JToggleButton button) {
        super(button);
    }

    @Override
    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.button.setRolloverEnabled(true);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(RadianceSizeUtils.getCheckBoxBorder(RadianceSizeUtils.getComponentFontSize(b), b.getComponentOrientation().isLeftToRight()));
        }
    }

    @Override
    protected void updateIcon() {
        int fontSize = RadianceSizeUtils.getComponentFontSize(this.button);
        final int checkMarkSize = RadianceSizeUtils.getCheckBoxMarkSize(fontSize);
        this.radianceIcon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                StateTransitionTracker.ModelStateInfo modelStateInfo = RadianceCheckBoxUI.this.stateTransitionTracker.getModelStateInfo();
                RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(RadianceCheckBoxUI.this.button);
                RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(RadianceCheckBoxUI.this.button);
                ComponentState currState = modelStateInfo.getCurrModelState();
                float visibility = RadianceCheckBoxUI.this.stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.SELECTION);
                boolean isCheckMarkFadingOut = !currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION);
                float alpha = RadianceColorSchemeUtilities.getAlpha(RadianceCheckBoxUI.this.button, currState);
                BladeUtils.populateColorScheme(RadianceCheckBoxUI.this.mutableFillColorScheme, RadianceCheckBoxUI.this.button, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, false);
                BladeUtils.populateColorScheme(RadianceCheckBoxUI.this.mutableBorderColorScheme, RadianceCheckBoxUI.this.button, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, false);
                BladeUtils.populateColorScheme(RadianceCheckBoxUI.this.mutableMarkColorScheme, RadianceCheckBoxUI.this.button, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, false);
                Graphics2D graphics = (Graphics2D)g.create();
                graphics.translate(x, y);
                BladeIconUtils.drawCheckBox(graphics, RadianceCheckBoxUI.this.button, fillPainter, borderPainter, checkMarkSize, currState, RadianceCheckBoxUI.this.mutableFillColorScheme, RadianceCheckBoxUI.this.mutableMarkColorScheme, RadianceCheckBoxUI.this.mutableBorderColorScheme, visibility, 0.0f, isCheckMarkFadingOut, alpha);
                graphics.dispose();
            }

            @Override
            public int getIconWidth() {
                return checkMarkSize;
            }

            @Override
            public int getIconHeight() {
                return checkMarkSize;
            }
        };
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b, this.stateTransitionTracker);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JCheckBox checkBox = (JCheckBox)c;
        return RadianceMetricsUtilities.getPreferredCheckButtonSize(checkBox, ((RadianceCheckBoxUI)checkBox.getUI()).getDefaultIcon());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }
}

