/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopPaneUI;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostPaintingUtils;

public class RadianceDesktopPaneUI
extends BasicDesktopPaneUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceDesktopPaneUI();
    }

    protected RadianceDesktopPaneUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Border curr = this.desktop.getBorder();
        if (curr == null || curr instanceof UIResource) {
            this.desktop.setBorder(new BorderUIResource(new EmptyBorder(0, 0, 0, 0)));
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!c.isShowing()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c, g));
        if (RadianceCoreUtilities.isOpaque(c)) {
            Color back = c.getBackground();
            if (back instanceof UIResource) {
                graphics.setColor(UIManager.getColor("Panel.background"));
                graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            BackgroundPaintingUtils.updateIfOpaque(graphics, c);
        }
        super.paint(graphics, c);
        GhostPaintingUtils.paintGhostImages(c, graphics);
        graphics.dispose();
    }
}

