/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.animation.api.swing.EventDispatchThreadTimelineCallbackAdapter;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.renderer.RadianceDefaultListCellRenderer;
import org.pushingpixels.radiance.theming.api.renderer.RadiancePanelListCellRenderer;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.painter.HighlightPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceStripingUtils;
import org.pushingpixels.radiance.theming.internal.utils.UpdateOptimizationAware;
import org.pushingpixels.radiance.theming.internal.utils.UpdateOptimizationInfo;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceListUI
extends BasicListUI
implements UpdateOptimizationAware {
    private Map<Integer, Object> selectedIndices = new HashMap<Integer, Object>();
    private int rolledOverIndex = -1;
    private PropertyChangeListener radiancePropertyChangeListener;
    private ListSelectionListener radianceListSelectionListener;
    private RolloverFadeListener radianceFadeRolloverListener;
    private ComponentListener radianceComponentListener;
    private StateTransitionMultiTracker<Integer> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    private ListDataListener radianceListDataListener;
    private UpdateOptimizationInfo updateInfo;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceListUI();
    }

    protected RadianceListUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.syncModelContents();
    }

    @Override
    protected void uninstallDefaults() {
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.stateTransitionMultiTracker.clear();
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceListSelectionListener = new RadianceListSelectionListener();
        this.list.getSelectionModel().addListSelectionListener(this.radianceListSelectionListener);
        this.radianceFadeRolloverListener = new RolloverFadeListener();
        this.list.addMouseMotionListener(this.radianceFadeRolloverListener);
        this.list.addMouseListener(this.radianceFadeRolloverListener);
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    ListModel oldModel = (ListModel)propertyChangeEvent.getOldValue();
                    if (oldModel != null) {
                        oldModel.removeListDataListener(this.radianceListDataListener);
                    }
                    ListModel newModel = (ListModel)propertyChangeEvent.getNewValue();
                    this.radianceListDataListener = new RadianceListDataListener();
                    newModel.addListDataListener(this.radianceListDataListener);
                    this.syncModelContents();
                });
            }
            if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    ListSelectionModel oldModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                    if (oldModel != null) {
                        oldModel.removeListSelectionListener(this.radianceListSelectionListener);
                    }
                    ListSelectionModel newModel = (ListSelectionModel)propertyChangeEvent.getNewValue();
                    this.radianceListSelectionListener = new RadianceListSelectionListener();
                    newModel.addListSelectionListener(this.radianceListSelectionListener);
                    this.syncModelContents();
                });
            }
        };
        this.list.addPropertyChangeListener(this.radiancePropertyChangeListener);
        this.radianceComponentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                RadianceListUI.this.fadeOutRolloverIndication();
                RadianceListUI.this.resetRolloverIndex();
            }
        };
        this.list.addComponentListener(this.radianceComponentListener);
        this.radianceListDataListener = new RadianceListDataListener();
        this.list.getModel().addListDataListener(this.radianceListDataListener);
    }

    @Override
    protected void uninstallListeners() {
        this.list.getModel().removeListDataListener(this.radianceListDataListener);
        this.radianceListDataListener = null;
        this.list.getSelectionModel().removeListSelectionListener(this.radianceListSelectionListener);
        this.radianceListSelectionListener = null;
        this.list.removeMouseMotionListener(this.radianceFadeRolloverListener);
        this.list.removeMouseListener(this.radianceFadeRolloverListener);
        this.radianceFadeRolloverListener = null;
        this.list.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        this.list.removeComponentListener(this.radianceComponentListener);
        this.radianceComponentListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer<Object> cellRenderer, ListModel<Object> dataModel, ListSelectionModel selModel, int leadIndex) {
        JList.DropLocation dropLocation;
        StateTransitionTracker.ModelStateInfo modelStateInfo;
        StateTransitionTracker tracker;
        boolean isRadianceRenderer;
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        boolean bl = isRadianceRenderer = rendererComponent instanceof RadianceDefaultListCellRenderer || rendererComponent instanceof RadiancePanelListCellRenderer;
        if (!isRadianceRenderer) {
            super.paintCell(g, row, rowBounds, cellRenderer, dataModel, selModel, leadIndex);
            return;
        }
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.list, g));
        Color background = rendererComponent.getBackground();
        if (!(background instanceof UIResource || background == null || this.list.getBackground().equals(background) && !this.updateInfo.isInDecorationArea)) {
            g2d.setColor(background);
            g2d.fillRect(cx, cy, cw, ch);
        }
        if ((tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)row)) != null) {
            tracker.getModel().setEnabled(this.list.isEnabled() && rendererComponent.isEnabled());
        }
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = (modelStateInfo = this.getModelStateInfo(row)) == null ? null : modelStateInfo.getStateContributionMap();
        ComponentState currState = modelStateInfo == null ? this.getCellState(row, rendererComponent) : modelStateInfo.getCurrModelState();
        boolean hasHighlights = false;
        if (rendererComponent.isEnabled()) {
            if (activeStates != null) {
                Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry;
                Iterator<Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo>> iterator = activeStates.entrySet().iterator();
                while (iterator.hasNext() && !(hasHighlights = this.updateInfo.getHighlightAlpha((stateEntry = iterator.next()).getKey()) * stateEntry.getValue().getContribution() > 0.0f)) {
                }
            } else {
                boolean bl2 = hasHighlights = this.updateInfo.getHighlightAlpha(currState) > 0.0f;
            }
        }
        if ((dropLocation = this.list.getDropLocation()) != null && !dropLocation.isInsert() && dropLocation.getIndex() == row) {
            RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(this.list, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, currState);
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.list, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, currState);
            Rectangle cellRect = new Rectangle(cx, cy, cw, ch);
            HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, cellRect, 0.8f, null, fillScheme, borderScheme);
        } else if (hasHighlights) {
            Rectangle cellRect = new Rectangle(cx, cy, cw, ch);
            if (activeStates == null) {
                float alpha = this.updateInfo.getHighlightAlpha(currState);
                if (alpha > 0.0f) {
                    RadianceColorScheme fillScheme = this.updateInfo.getHighlightColorScheme(currState);
                    RadianceColorScheme borderScheme = this.updateInfo.getHighlightBorderColorScheme(currState);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(this.list, alpha, g));
                    HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, cellRect, 0.8f, null, fillScheme, borderScheme);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.list, g));
                }
            } else {
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry : activeStates.entrySet()) {
                    ComponentState activeState = stateEntry.getKey();
                    float alpha = this.updateInfo.getHighlightAlpha(activeState) * stateEntry.getValue().getContribution();
                    if (alpha == 0.0f) continue;
                    RadianceColorScheme fillScheme = this.updateInfo.getHighlightColorScheme(activeState);
                    RadianceColorScheme borderScheme = this.updateInfo.getHighlightBorderColorScheme(activeState);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(this.list, alpha, g));
                    HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, cellRect, 0.8f, null, fillScheme, borderScheme);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.list, g));
                }
            }
        }
        this.rendererPane.paintComponent(g2d, rendererComponent, this.list, cx, cy, cw, ch, true);
        g2d.dispose();
    }

    public ComponentState getCellState(int cellIndex, Component rendererComponent) {
        StateTransitionTracker tracker;
        boolean isEnabled = this.list.isEnabled();
        if (rendererComponent != null) {
            boolean bl = isEnabled = isEnabled && rendererComponent.isEnabled();
        }
        if ((tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)cellIndex)) == null) {
            boolean isRollover = this.rolledOverIndex >= 0 && this.rolledOverIndex == cellIndex;
            boolean isSelected = this.selectedIndices.containsKey(cellIndex);
            return ComponentState.getState(isEnabled, isRollover, isSelected);
        }
        ComponentState fromTracker = tracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState(isEnabled, fromTracker.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), fromTracker.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
    }

    public StateTransitionTracker.ModelStateInfo getModelStateInfo(int row) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)row);
        if (tracker == null) {
            return null;
        }
        return tracker.getModelStateInfo();
    }

    public void resetRolloverIndex() {
        this.rolledOverIndex = -1;
    }

    private void fadeOutRolloverIndication() {
        if (this.rolledOverIndex < 0) {
            return;
        }
        StateTransitionTracker tracker = this.getTracker(this.rolledOverIndex, true, this.list.isSelectedIndex(this.rolledOverIndex));
        tracker.getModel().setRollover(false);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g, c);
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        RadianceStripingUtils.setup(c);
        this.updateInfo = new UpdateOptimizationInfo(c);
        this.paint(g2d, c);
        RadianceStripingUtils.tearDown(c);
        g2d.dispose();
        this.updateInfo = null;
    }

    private void syncModelContents() {
        if (this.list == null) {
            return;
        }
        this.stateTransitionMultiTracker.clear();
        this.selectedIndices.clear();
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            if (!this.list.isSelectedIndex(i)) continue;
            this.selectedIndices.put(i, this.list.getModel().getElementAt(i));
        }
        this.list.repaint();
    }

    private StateTransitionTracker getTracker(int row, boolean initialRollover, boolean initialSelected) {
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)row);
        if (tracker == null) {
            DefaultButtonModel model = new DefaultButtonModel();
            model.setSelected(initialSelected);
            model.setRollover(initialRollover);
            tracker = new StateTransitionTracker((JComponent)this.list, model);
            tracker.registerModelListeners();
            tracker.setRepaintCallback(() -> new CellRepaintCallback(this.list, row));
            tracker.setName("row " + row);
            this.stateTransitionMultiTracker.addTracker((Comparable<Integer>)row, tracker);
        }
        return tracker;
    }

    @Override
    public UpdateOptimizationInfo getUpdateOptimizationInfo() {
        return this.updateInfo;
    }

    private class CellRepaintCallback
    extends EventDispatchThreadTimelineCallbackAdapter {
        protected JList list;
        private int cellIndex;

        private CellRepaintCallback(JList list, int cellIndex) {
            this.list = list;
            this.cellIndex = cellIndex;
        }

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintCell();
        }

        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintCell();
        }

        private void repaintCell() {
            if (RadianceListUI.this.list == null) {
                return;
            }
            try {
                RadianceListUI.this.maybeUpdateLayoutState();
                int cellCount = this.list.getModel().getSize();
                if (cellCount > 0 && this.cellIndex < cellCount) {
                    Rectangle rect = RadianceListUI.this.getCellBounds(this.list, this.cellIndex, this.cellIndex);
                    this.list.repaint(rect);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RadianceListUI.this.fadeOutRolloverIndication();
            RadianceListUI.this.resetRolloverIndex();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!RadianceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!RadianceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            boolean isRadianceRenderer;
            ListCellRenderer cellRenderer = RadianceListUI.this.list.getCellRenderer();
            boolean bl = isRadianceRenderer = cellRenderer instanceof RadianceDefaultListCellRenderer || cellRenderer instanceof RadiancePanelListCellRenderer;
            if (!isRadianceRenderer) {
                RadianceListUI.this.fadeOutRolloverIndication();
                RadianceListUI.this.resetRolloverIndex();
                return;
            }
            int roIndex = RadianceListUI.this.list.locationToIndex(e.getPoint());
            if (roIndex >= 0 && roIndex < RadianceListUI.this.list.getModel().getSize() && !RadianceListUI.this.list.getCellBounds(roIndex, roIndex).contains(e.getPoint())) {
                roIndex = -1;
            }
            if (roIndex < 0 || roIndex >= RadianceListUI.this.list.getModel().getSize()) {
                RadianceListUI.this.fadeOutRolloverIndication();
                RadianceListUI.this.resetRolloverIndex();
            } else {
                if (RadianceListUI.this.rolledOverIndex >= 0 && RadianceListUI.this.rolledOverIndex == roIndex) {
                    return;
                }
                RadianceListUI.this.fadeOutRolloverIndication();
                StateTransitionTracker tracker = RadianceListUI.this.getTracker(roIndex, false, RadianceListUI.this.list.isSelectedIndex(roIndex));
                tracker.getModel().setRollover(true);
                RadianceListUI.this.rolledOverIndex = roIndex;
            }
        }
    }

    private final class RadianceListDataListener
    implements ListDataListener {
        private RadianceListDataListener() {
        }

        private void _syncModelContents() {
            SwingUtilities.invokeLater(() -> RadianceListUI.this.syncModelContents());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this._syncModelContents();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this._syncModelContents();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this._syncModelContents();
        }
    }

    private class RadianceListSelectionListener
    implements ListSelectionListener {
        private RadianceListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SwingUtilities.invokeLater(() -> {
                this.handleListSelectionChange(e);
                if (RadianceListUI.this.list != null) {
                    RadianceListUI.this.list.repaint();
                }
            });
        }

        private void handleListSelectionChange(ListSelectionEvent e) {
            boolean isRadianceRenderer;
            if (RadianceListUI.this.list == null) {
                return;
            }
            if (WidgetUtilities.hasNoAnimations(RadianceListUI.this.list, RadianceThemingSlices.AnimationFacet.SELECTION)) {
                return;
            }
            ListCellRenderer cellRenderer = RadianceListUI.this.list.getCellRenderer();
            boolean bl = isRadianceRenderer = cellRenderer instanceof RadianceDefaultListCellRenderer || cellRenderer instanceof RadiancePanelListCellRenderer;
            if (!isRadianceRenderer) {
                RadianceListUI.this.syncModelContents();
                return;
            }
            HashSet<StateTransitionTracker> initiatedTrackers = new HashSet<StateTransitionTracker>();
            boolean fadeCanceled = false;
            for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                StateTransitionTracker tracker;
                if (i >= RadianceListUI.this.list.getModel().getSize()) continue;
                if (RadianceListUI.this.list.isSelectedIndex(i)) {
                    if (RadianceListUI.this.selectedIndices.containsKey(i)) continue;
                    RadianceListUI.this.selectedIndices.put(i, RadianceListUI.this.list.getModel().getElementAt(i));
                    if (fadeCanceled) continue;
                    tracker = RadianceListUI.this.getTracker(i, i == RadianceListUI.this.rolledOverIndex, false);
                    tracker.getModel().setSelected(true);
                    initiatedTrackers.add(tracker);
                    if (initiatedTrackers.size() <= 25) continue;
                    RadianceListUI.this.stateTransitionMultiTracker.clear();
                    initiatedTrackers.clear();
                    fadeCanceled = true;
                    continue;
                }
                if (!RadianceListUI.this.selectedIndices.containsKey(i)) continue;
                if (RadianceListUI.this.selectedIndices.get(i) == RadianceListUI.this.list.getModel().getElementAt(i) && !fadeCanceled) {
                    tracker = RadianceListUI.this.getTracker(i, i == RadianceListUI.this.rolledOverIndex, true);
                    tracker.getModel().setSelected(false);
                    initiatedTrackers.add(tracker);
                    if (initiatedTrackers.size() > 25) {
                        RadianceListUI.this.stateTransitionMultiTracker.clear();
                        initiatedTrackers.clear();
                        fadeCanceled = true;
                    }
                }
                RadianceListUI.this.selectedIndices.remove(i);
            }
        }
    }
}

