/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPanelUI;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostPaintingUtils;

public class RadiancePanelUI
extends BasicPanelUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadiancePanelUI();
    }

    protected RadiancePanelUI() {
    }

    @Override
    protected void installDefaults(JPanel p) {
        Color backgroundFillColor;
        super.installDefaults(p);
        Color backgr = p.getBackground();
        if ((backgr == null || backgr instanceof UIResource) && (backgroundFillColor = RadianceColorUtilities.getBackgroundFillColor(p)) != null) {
            p.setBackground(new ColorUIResource(backgroundFillColor));
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (this.toPaintBackground(c)) {
            BackgroundPaintingUtils.update(g, c, false);
        }
        super.paint(g, c);
        GhostPaintingUtils.paintGhostImages(c, g);
    }

    private boolean toPaintBackground(JComponent c) {
        return RadianceCoreUtilities.isOpaque(c);
    }
}

