/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.RadianceThemingWidgetRepository;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RolloverControlListener;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostPaintingUtils;

public class RadianceScrollBarUI
extends BasicScrollBarUI
implements TransitionAwareUI {
    private ButtonModel thumbModel;
    private BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();
    private RolloverControlListener radianceThumbRolloverListener;
    private StateTransitionTracker compositeStateTransitionTracker;
    private PropertyChangeListener radiancePropertyListener;
    private int scrollBarWidth;
    private AdjustmentListener radianceAdjustmentListener;
    private Set<RadianceThemingWidget<JComponent>> themingWidgets;
    private static int THUMB_DELTA = 2;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceScrollBarUI(comp);
    }

    protected RadianceScrollBarUI(JComponent b) {
        this.thumbModel = new DefaultButtonModel();
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        b.setOpaque(false);
    }

    @Override
    public void installUI(JComponent c) {
        this.themingWidgets = RadianceThemingWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return null;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return null;
    }

    private void drawThumbVertical(Graphics2D g, Rectangle thumbBounds) {
        int width = Math.max(1, thumbBounds.width);
        int delta = Math.max(0, (int)(0.4 * (double)width));
        if (delta % 2 == 1) {
            --delta;
        }
        int height = Math.max(1, thumbBounds.height);
        int hoffset = (thumbBounds.width - (width -= delta)) / 2;
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.compositeStateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        BladeUtils.populateColorScheme(this.mutableFillColorScheme, this.scrollbar, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, true);
        BladeUtils.populateColorScheme(this.mutableBorderColorScheme, this.scrollbar, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, false);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)thumbBounds.x, (int)thumbBounds.y, (int)height, (int)width, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceFillPainter painter = RadianceCoreUtilities.getFillPainter(this.scrollbar);
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(this.scrollbar);
            float radius = scaledHeight / 2;
            Shape contour = RadianceOutlineUtilities.getBaseOutline(this.scrollbar.getComponentOrientation(), scaledWidth, scaledHeight, radius, null, 1.0f);
            AffineTransform at = AffineTransform.getRotateInstance(-1.5707963267948966);
            at.translate(-y - scaledWidth, (double)x + (double)hoffset * scaleFactor);
            graphics1X.transform(at);
            painter.paintContourBackground(graphics1X, this.scrollbar, scaledWidth, scaledHeight, contour, this.mutableFillColorScheme);
            borderPainter.paintBorder(graphics1X, this.scrollbar, scaledWidth, scaledHeight, contour, null, this.mutableBorderColorScheme);
        });
        graphics.dispose();
    }

    private void drawThumbHorizontal(Graphics2D g, Rectangle thumbBounds) {
        int width = Math.max(1, thumbBounds.width);
        int height = Math.max(1, thumbBounds.height);
        int delta = Math.max(0, (int)(0.4 * (double)height));
        if (delta % 2 == 1) {
            --delta;
        }
        int voffset = (thumbBounds.height - (height -= delta)) / 2;
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.compositeStateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        BladeUtils.populateColorScheme(this.mutableFillColorScheme, this.scrollbar, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, true);
        BladeUtils.populateColorScheme(this.mutableBorderColorScheme, this.scrollbar, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, false);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)thumbBounds.x, (int)thumbBounds.y, (int)width, (int)height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceFillPainter painter = RadianceCoreUtilities.getFillPainter(this.scrollbar);
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(this.scrollbar);
            float radius = scaledHeight / 2;
            Shape contour = RadianceOutlineUtilities.getBaseOutline(this.scrollbar.getComponentOrientation(), scaledWidth, scaledHeight, radius, null, 1.0f);
            graphics1X.translate((double)x, (double)y + (double)voffset * scaleFactor);
            painter.paintContourBackground(graphics1X, this.scrollbar, scaledWidth, scaledHeight, contour, this.mutableFillColorScheme);
            borderPainter.paintBorder(graphics1X, this.scrollbar, scaledWidth, scaledHeight, contour, null, this.mutableBorderColorScheme);
        });
        graphics.dispose();
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Graphics2D graphics = (Graphics2D)g.create();
        if (this.scrollbar.getOrientation() == 1) {
            graphics.translate(trackBounds.x, trackBounds.y - THUMB_DELTA);
        } else {
            graphics.translate(trackBounds.x - THUMB_DELTA, trackBounds.y);
        }
        graphics.setColor(RadianceColorUtilities.getBackgroundFillColorScrollBar(this.scrollbar));
        graphics.fillRect(0, 0, this.scrollbar.getWidth(), this.scrollbar.getHeight());
        GhostPaintingUtils.paintGhostImages(this.scrollbar, g);
        graphics.dispose();
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Graphics2D graphics = (Graphics2D)g.create();
        this.thumbModel.setSelected(this.thumbModel.isSelected() || this.isDragging);
        this.thumbModel.setEnabled(c.isEnabled());
        boolean isVertical = this.scrollbar.getOrientation() == 1;
        Rectangle adjustedBounds = new Rectangle(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
        if (isVertical) {
            this.drawThumbVertical(graphics, adjustedBounds);
        } else {
            this.drawThumbHorizontal(graphics, adjustedBounds);
        }
        graphics.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        BackgroundPaintingUtils.update(graphics, c, false);
        float alpha = RadianceColorSchemeUtilities.getAlpha(this.scrollbar, ComponentState.getState(this.thumbModel, this.scrollbar));
        graphics.setComposite(WidgetUtilities.getAlphaComposite(c, alpha, g));
        super.paint(graphics, c);
        graphics.dispose();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.scrollBarWidth = RadianceSizeUtils.getScrollBarWidth(RadianceSizeUtils.getComponentFontSize(this.scrollbar));
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults() {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallDefaults();
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installComponents() {
        this.compositeStateTransitionTracker = new StateTransitionTracker((JComponent)this.scrollbar, this.thumbModel);
        this.compositeStateTransitionTracker.registerModelListeners();
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installComponents();
        }
    }

    @Override
    protected void uninstallComponents() {
        this.compositeStateTransitionTracker.unregisterModelListeners();
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallComponents();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceThumbRolloverListener = new RolloverControlListener(this, this.thumbModel);
        this.scrollbar.addMouseListener(this.radianceThumbRolloverListener);
        this.scrollbar.addMouseMotionListener(this.radianceThumbRolloverListener);
        this.radiancePropertyListener = propertyChangeEvent -> {
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> this.scrollbar.updateUI());
            }
        };
        this.scrollbar.addPropertyChangeListener(this.radiancePropertyListener);
        this.radianceAdjustmentListener = adjustmentEvent -> {
            RadianceCoreUtilities.testComponentStateChangeThreadingViolation(this.scrollbar);
            Container parent = this.scrollbar.getParent();
            if (parent instanceof JScrollPane) {
                JScrollPane jsp = (JScrollPane)parent;
                JScrollBar hor = jsp.getHorizontalScrollBar();
                JScrollBar ver = jsp.getVerticalScrollBar();
                JScrollBar other = null;
                if (this.scrollbar == hor) {
                    other = ver;
                }
                if (this.scrollbar == ver) {
                    other = hor;
                }
                if (other != null && other.isVisible()) {
                    other.repaint();
                }
                this.scrollbar.repaint();
            }
        };
        this.scrollbar.addAdjustmentListener(this.radianceAdjustmentListener);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.scrollbar.removeMouseListener(this.radianceThumbRolloverListener);
        this.scrollbar.removeMouseMotionListener(this.radianceThumbRolloverListener);
        this.radianceThumbRolloverListener = null;
        this.scrollbar.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        this.scrollbar.removeAdjustmentListener(this.radianceAdjustmentListener);
        this.radianceAdjustmentListener = null;
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallListeners();
        }
        super.uninstallListeners();
    }

    @Override
    public boolean isInside(MouseEvent me) {
        Rectangle trackB = this.getTrackBounds();
        if (trackB == null) {
            return false;
        }
        return trackB.contains(me.getX(), me.getY());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.compositeStateTransitionTracker;
    }

    @Override
    public void scrollByBlock(int direction) {
        int oldValue = this.scrollbar.getValue();
        int blockIncrement = this.scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = this.scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = this.scrollbar.getMinimum();
        }
        this.scrollbar.setValue(newValue);
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        this.layoutVScrollbarNone(sb);
    }

    @Override
    protected void layoutHScrollbar(JScrollBar sb) {
        this.layoutHScrollbarNone(sb);
    }

    protected void layoutVScrollbarNone(JScrollBar sb) {
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonY = sbSize.height - sbInsets.bottom - THUMB_DELTA;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        float trackH = sbSize.height - sbInsetsH - THUMB_DELTA;
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = incrButtonY - (thumbH -= THUMB_DELTA) + THUMB_DELTA;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = THUMB_DELTA + (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
        }
        int itrackY = THUMB_DELTA;
        int itrackH = incrButtonY - itrackY - 2 * THUMB_DELTA;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > incrButtonY) {
                thumbY = incrButtonY - thumbH;
            }
            if (thumbY < 0) {
                thumbY = 0;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutHScrollbarNone(JScrollBar sb) {
        int thumbX;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb.getComponentOrientation().isLeftToRight();
        int incrButtonX = ltr ? sbSize.width - sbInsets.right - THUMB_DELTA : sbInsets.left + THUMB_DELTA;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        float trackW = sbSize.width - sbInsetsW - THUMB_DELTA;
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? incrButtonX - (thumbW -= THUMB_DELTA) + THUMB_DELTA : sbInsets.left + THUMB_DELTA;
        if (value < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            thumbX = ltr ? THUMB_DELTA + (int)(0.5f + thumbRange * ((value - min) / (range - extent))) : THUMB_DELTA + (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
        }
        if (ltr) {
            int itrackX = sbInsets.left + THUMB_DELTA;
            int itrackW = incrButtonX - itrackX - 2 * THUMB_DELTA;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        } else {
            int itrackX = incrButtonX + THUMB_DELTA;
            int itrackW = sbSize.width - itrackX - 2 * THUMB_DELTA;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        }
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (ltr) {
                if (thumbX + thumbW > incrButtonX) {
                    thumbX = incrButtonX - thumbW;
                }
                if (thumbX < 0) {
                    thumbX = 1;
                }
            } else if (thumbX + thumbW > sbSize.width - sbInsets.left) {
                thumbX = sbSize.width - sbInsets.left - thumbW;
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new RadianceTrackListener();
    }

    @Override
    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return null;
    }

    private void updateThumbState(int x, int y) {
        Rectangle rect = this.getThumbBounds();
        this.setThumbRollover(rect.contains(x, y));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, Math.max(48, 5 * this.scrollBarWidth));
        }
        return new Dimension(Math.max(48, 5 * this.scrollBarWidth), this.scrollBarWidth);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        GhostPaintingUtils.paintGhostImages(c, g);
    }

    protected class RadianceTrackListener
    extends BasicScrollBarUI.TrackListener {
        private transient int direction;

        protected RadianceTrackListener() {
            super(RadianceScrollBarUI.this);
            this.direction = 1;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (RadianceScrollBarUI.this.isDragging) {
                RadianceScrollBarUI.this.updateThumbState(e.getX(), e.getY());
            }
            if (SwingUtilities.isRightMouseButton(e) || !RadianceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!RadianceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            Rectangle r = RadianceScrollBarUI.this.getTrackBounds();
            RadianceScrollBarUI.this.scrollbar.repaint(r.x, r.y, r.width, r.height);
            RadianceScrollBarUI.this.trackHighlight = 0;
            RadianceScrollBarUI.this.isDragging = false;
            this.offset = 0;
            RadianceScrollBarUI.this.scrollTimer.stop();
            RadianceScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || !RadianceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!RadianceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!RadianceScrollBarUI.this.scrollbar.hasFocus() && RadianceScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                RadianceScrollBarUI.this.scrollbar.requestFocus();
            }
            RadianceScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (RadianceScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (RadianceScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().x;
                    }
                }
                RadianceScrollBarUI.this.isDragging = true;
                return;
            }
            if (RadianceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                switch (RadianceScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = ((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().height / 2;
                        break;
                    }
                    case 0: {
                        this.offset = ((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().width / 2;
                    }
                }
                RadianceScrollBarUI.this.isDragging = true;
                this.setValueFrom(e);
                return;
            }
            RadianceScrollBarUI.this.isDragging = false;
            Dimension sbSize = RadianceScrollBarUI.this.scrollbar.getSize();
            this.direction = 1;
            switch (RadianceScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (RadianceScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.height / 2;
                        this.direction = this.currentMouseY < scrollbarCenter ? -1 : 1;
                        break;
                    }
                    int thumbY = ((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().y;
                    this.direction = this.currentMouseY < thumbY ? -1 : 1;
                    break;
                }
                case 0: {
                    if (RadianceScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.width / 2;
                        this.direction = this.currentMouseX < scrollbarCenter ? -1 : 1;
                    } else {
                        int thumbX = ((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().x;
                        int n = this.direction = this.currentMouseX < thumbX ? -1 : 1;
                    }
                    if (RadianceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) break;
                    this.direction = -this.direction;
                }
            }
            RadianceScrollBarUI.this.scrollByBlock(this.direction);
            RadianceScrollBarUI.this.scrollTimer.stop();
            RadianceScrollBarUI.this.scrollListener.setDirection(this.direction);
            RadianceScrollBarUI.this.scrollListener.setScrollByBlock(true);
            this.startScrollTimerIfNecessary();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || !RadianceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!RadianceScrollBarUI.this.scrollbar.isEnabled() || RadianceScrollBarUI.this.getThumbBounds().isEmpty()) {
                return;
            }
            if (RadianceScrollBarUI.this.isDragging) {
                this.setValueFrom(e);
            } else {
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                RadianceScrollBarUI.this.updateThumbState(this.currentMouseX, this.currentMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        private void setValueFrom(MouseEvent e) {
            int thumbPos;
            int thumbMax;
            int thumbMin;
            boolean active = RadianceScrollBarUI.this.isThumbRollover();
            BoundedRangeModel model = RadianceScrollBarUI.this.scrollbar.getModel();
            Rectangle thumbR = RadianceScrollBarUI.this.getThumbBounds();
            if (RadianceScrollBarUI.this.scrollbar.getOrientation() == 1) {
                thumbMin = THUMB_DELTA;
                thumbMax = ((RadianceScrollBarUI)RadianceScrollBarUI.this).scrollbar.getSize().height - ((RadianceScrollBarUI)RadianceScrollBarUI.this).scrollbar.getInsets().bottom - thumbR.height - THUMB_DELTA;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getY() - this.offset));
                RadianceScrollBarUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
            } else {
                thumbMin = THUMB_DELTA;
                thumbMax = ((RadianceScrollBarUI)RadianceScrollBarUI.this).scrollbar.getSize().width - ((RadianceScrollBarUI)RadianceScrollBarUI.this).scrollbar.getInsets().right - thumbR.width - THUMB_DELTA;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getX() - this.offset));
                RadianceScrollBarUI.this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
            }
            if (thumbPos == thumbMax) {
                if (RadianceScrollBarUI.this.scrollbar.getOrientation() == 1 || RadianceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    RadianceScrollBarUI.this.scrollbar.setValue(model.getMaximum() - model.getExtent());
                } else {
                    RadianceScrollBarUI.this.scrollbar.setValue(model.getMinimum());
                }
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                int value = RadianceScrollBarUI.this.scrollbar.getOrientation() == 1 || RadianceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight() ? (int)(0.5 + (double)(thumbValue / thumbRange * valueRange)) : (int)(0.5 + (double)((float)(thumbMax - thumbPos) / thumbRange * valueRange));
                RadianceScrollBarUI.this.scrollbar.setValue(value + model.getMinimum());
            }
            RadianceScrollBarUI.this.setThumbRollover(active);
        }

        private void startScrollTimerIfNecessary() {
            if (RadianceScrollBarUI.this.scrollTimer.isRunning()) {
                return;
            }
            switch (RadianceScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (this.direction > 0) {
                        if (((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().y + ((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().height >= ((RadianceTrackListener)((RadianceScrollBarUI)RadianceScrollBarUI.this).trackListener).currentMouseY) break;
                        RadianceScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().y <= ((RadianceTrackListener)((RadianceScrollBarUI)RadianceScrollBarUI.this).trackListener).currentMouseY) break;
                    RadianceScrollBarUI.this.scrollTimer.start();
                    break;
                }
                case 0: {
                    if (this.direction > 0) {
                        if (((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().x + ((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().width >= ((RadianceTrackListener)((RadianceScrollBarUI)RadianceScrollBarUI.this).trackListener).currentMouseX) break;
                        RadianceScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((RadianceScrollBarUI)RadianceScrollBarUI.this).getThumbBounds().x <= ((RadianceTrackListener)((RadianceScrollBarUI)RadianceScrollBarUI.this).trackListener).currentMouseX) break;
                    RadianceScrollBarUI.this.scrollTimer.start();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!RadianceScrollBarUI.this.isDragging) {
                RadianceScrollBarUI.this.updateThumbState(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!RadianceScrollBarUI.this.isDragging) {
                RadianceScrollBarUI.this.setThumbRollover(false);
            }
        }
    }
}

