/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.table.JTableHeader;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.animation.api.callback.TimelineCallback;
import org.pushingpixels.radiance.animation.api.swing.EventDispatchThreadTimelineCallbackAdapter;
import org.pushingpixels.radiance.animation.api.swing.SwingComponentTimeline;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;
import org.pushingpixels.radiance.theming.internal.RadianceThemingWidgetRepository;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTableHeaderUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTreeUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class RadianceScrollPaneUI
extends BasicScrollPaneUI {
    private PropertyChangeListener radiancePropertyChangeListener;
    private ChangeListener radianceVerticalScrollbarChangeListener;
    private Timeline horizontalScrollTimeline;
    private Set<RadianceThemingWidget<JComponent>> themingWidgets;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceScrollPaneUI();
    }

    protected RadianceScrollPaneUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.themingWidgets = RadianceThemingWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        SwingUtilities.invokeLater(() -> this.installTableHeaderCornerFiller(scrollpane));
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults(JScrollPane c) {
        Component upperLeft;
        Component upperRight = c.getCorner("UPPER_RIGHT_CORNER");
        if (upperRight instanceof UIResource) {
            c.setCorner("UPPER_RIGHT_CORNER", null);
        }
        if ((upperLeft = c.getCorner("UPPER_LEFT_CORNER")) instanceof UIResource) {
            c.setCorner("UPPER_LEFT_CORNER", null);
        }
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallDefaults();
        }
        super.uninstallDefaults(c);
    }

    @Override
    protected void installListeners(final JScrollPane c) {
        super.installListeners(c);
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            Color newBackgr;
            if ("background".equals(propertyChangeEvent.getPropertyName()) && !((newBackgr = (Color)propertyChangeEvent.getNewValue()) instanceof UIResource)) {
                JScrollBar horizontal;
                JScrollBar vertical = this.scrollpane.getVerticalScrollBar();
                if (vertical != null && vertical.getBackground() instanceof UIResource) {
                    vertical.setBackground(newBackgr);
                }
                if ((horizontal = this.scrollpane.getHorizontalScrollBar()) != null && horizontal.getBackground() instanceof UIResource) {
                    horizontal.setBackground(newBackgr);
                }
            }
            if ("columnHeader".equals(propertyChangeEvent.getPropertyName()) || "componentOrientation".equals(propertyChangeEvent.getPropertyName()) || "ancestor".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.scrollpane != null) {
                        this.installTableHeaderCornerFiller(this.scrollpane);
                    }
                });
            }
        };
        c.addPropertyChangeListener(this.radiancePropertyChangeListener);
        this.radianceVerticalScrollbarChangeListener = changeEvent -> {
            if (c.getHorizontalScrollBar() != null && c.getHorizontalScrollBar().isVisible() && c.getViewport().getView() instanceof JTree) {
                JTree tree = (JTree)c.getViewport().getView();
                if (AnimationConfigurationManager.getInstance().isAnimationAllowed(RadianceThemingSlices.AnimationFacet.TREE_SMART_SCROLL_ANIMATION, tree)) {
                    int finalDelta;
                    int currPivotX;
                    Rectangle viewportRect;
                    RadianceTreeUI treeUI = (RadianceTreeUI)tree.getUI();
                    int pivotX = treeUI.getPivotRendererX(viewportRect = c.getViewport().getViewRect());
                    int delta = pivotX - (currPivotX = viewportRect.x);
                    int finalX = viewportRect.x + delta;
                    if (finalX < 0) {
                        delta -= finalX;
                    }
                    if (Math.abs(finalDelta = delta) > viewportRect.width / 6) {
                        if (this.horizontalScrollTimeline != null) {
                            this.horizontalScrollTimeline.abort();
                        }
                        this.horizontalScrollTimeline = ((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)SwingComponentTimeline.componentBuilder((Component)tree).addCallback((TimelineCallback)new EventDispatchThreadTimelineCallbackAdapter(){

                            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                                if ((double)timelinePosition >= 0.5) {
                                    int nudge = (int)((double)finalDelta * ((double)timelinePosition - 0.5));
                                    c.getViewport().setViewPosition(new Point(viewportRect.x + nudge, viewportRect.y));
                                }
                            }
                        })).setEase(durationFraction -> {
                            if ((double)durationFraction < 0.5) {
                                return 0.5f * durationFraction;
                            }
                            return 0.25f + (durationFraction - 0.5f) * 0.75f / 0.5f;
                        })).setDuration(2L * AnimationConfigurationManager.getInstance().getTimelineDuration())).build();
                        this.horizontalScrollTimeline.play();
                    }
                }
            }
        };
        c.getVerticalScrollBar().getModel().addChangeListener(this.radianceVerticalScrollbarChangeListener);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        c.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        JScrollPane jsp = (JScrollPane)c;
        jsp.getVerticalScrollBar().getModel().removeChangeListener(this.radianceVerticalScrollbarChangeListener);
        this.radianceVerticalScrollbarChangeListener = null;
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallListeners();
        }
        super.uninstallListeners(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g, c);
        JScrollPane jsp = (JScrollPane)c;
        LayoutManager lm = jsp.getLayout();
        ScrollPaneLayout scrollLm = null;
        if (lm instanceof ScrollPaneLayout) {
            scrollLm = (ScrollPaneLayout)lm;
        }
        if (scrollLm != null) {
            HashSet<Component> corners = new HashSet<Component>();
            if (scrollLm.getCorner("LOWER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("LOWER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_RIGHT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_RIGHT_CORNER"));
            }
            if (RadianceCoreUtilities.isOpaque(c)) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(RadianceColorUtilities.getBackgroundFillColorScrollBar(this.scrollpane.getVerticalScrollBar()));
                for (Component corner : corners) {
                    g2d.fill(corner.getBounds());
                }
                JScrollBar horizontal = this.scrollpane.getHorizontalScrollBar();
                JScrollBar vertical = this.scrollpane.getVerticalScrollBar();
                if (horizontal != null && vertical != null) {
                    if (this.scrollpane.getComponentOrientation().isLeftToRight()) {
                        if (scrollLm.getCorner("LOWER_RIGHT_CORNER") == null) {
                            g2d.fillRect(horizontal.getX() + horizontal.getWidth(), horizontal.getY(), vertical.getWidth(), horizontal.getHeight());
                        }
                    } else if (scrollLm.getCorner("LOWER_LEFT_CORNER") == null) {
                        g2d.fillRect(0, horizontal.getY(), vertical.getWidth(), horizontal.getHeight());
                    }
                }
            }
        }
        super.paint(g, c);
    }

    private void installTableHeaderCornerFiller(JScrollPane scrollpane) {
        boolean canReplace;
        JViewport columnHeader = scrollpane.getColumnHeader();
        if (columnHeader == null) {
            return;
        }
        Component columnHeaderComp = columnHeader.getView();
        if (!(columnHeaderComp instanceof JTableHeader)) {
            return;
        }
        JTableHeader tableHeader = (JTableHeader)columnHeaderComp;
        TableHeaderUI tableHeaderUI = tableHeader.getUI();
        if (!(tableHeaderUI instanceof RadianceTableHeaderUI)) {
            return;
        }
        RadianceTableHeaderUI ui = (RadianceTableHeaderUI)tableHeaderUI;
        JComponent scrollPaneCornerFiller = ui.getScrollPaneCornerFiller();
        String cornerKey = scrollpane.getComponentOrientation().isLeftToRight() ? "UPPER_RIGHT_CORNER" : "UPPER_LEFT_CORNER";
        Component cornerComp = scrollpane.getCorner(cornerKey);
        boolean bl = canReplace = cornerComp == null || cornerComp instanceof UIResource;
        if (canReplace) {
            scrollpane.setCorner(cornerKey, scrollPaneCornerFiller);
        }
    }
}

