/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.animation.api.callback.TimelineCallback;
import org.pushingpixels.radiance.animation.api.swing.EventDispatchThreadTimelineCallbackAdapter;
import org.pushingpixels.radiance.animation.api.swing.SwingComponentTimeline;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.api.tabbed.BaseTabCloseListener;
import org.pushingpixels.radiance.theming.api.tabbed.MultipleTabCloseListener;
import org.pushingpixels.radiance.theming.api.tabbed.TabCloseCallback;
import org.pushingpixels.radiance.theming.api.tabbed.TabCloseListener;
import org.pushingpixels.radiance.theming.api.tabbed.VetoableMultipleTabCloseListener;
import org.pushingpixels.radiance.theming.api.tabbed.VetoableTabCloseListener;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;
import org.pushingpixels.radiance.theming.internal.RadianceThemingWidgetRepository;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeTransitionAwareIcon;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalArrowButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceTabbedPaneUI
extends BasicTabbedPaneUI {
    private Point radianceMouseLocation;
    private Map<Component, Timeline> modifiedTimelines;
    private int currSelectedIndex = -1;
    private StateTransitionMultiTracker<Integer> stateTransitionMultiTracker;
    private Set<RadianceThemingWidget<JComponent>> themingWidgets;
    private MouseRolloverHandler radianceRolloverHandler;
    private TabbedContainerListener radianceContainerListener;
    private ChangeListener radianceSelectionListener;
    private boolean radianceContentOpaque;
    private Map<Integer, Color> tabTextColorMap;
    private BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableMarkColorScheme = new BladeColorScheme();

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceTabbedPaneUI();
    }

    protected RadianceTabbedPaneUI() {
        this.stateTransitionMultiTracker = new StateTransitionMultiTracker();
        this.tabTextColorMap = new HashMap<Integer, Color>();
    }

    @Override
    public void installUI(JComponent c) {
        this.themingWidgets = RadianceThemingWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceRolloverHandler = new MouseRolloverHandler();
        this.tabPane.addMouseMotionListener(this.radianceRolloverHandler);
        this.tabPane.addMouseListener(this.radianceRolloverHandler);
        this.radianceContainerListener = new TabbedContainerListener();
        this.radianceContainerListener.trackExistingTabs();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Component tabComp = this.tabPane.getComponentAt(i);
            if (!RadianceCoreUtilities.isTabModified(tabComp)) continue;
            this.trackTabModification(i, tabComp);
        }
        this.tabPane.addContainerListener(this.radianceContainerListener);
        this.radianceSelectionListener = changeEvent -> SwingUtilities.invokeLater(() -> {
            StateTransitionTracker tracker;
            if (this.tabPane == null) {
                return;
            }
            int selected = this.tabPane.getSelectedIndex();
            if (this.currSelectedIndex >= 0 && this.currSelectedIndex < this.tabPane.getTabCount() && this.tabPane.isEnabledAt(this.currSelectedIndex)) {
                tracker = this.getTracker(this.currSelectedIndex, this.getRolloverTabIndex() == this.currSelectedIndex, true);
                tracker.getModel().setSelected(false);
            }
            this.currSelectedIndex = selected;
            if (selected >= 0 && selected < this.tabPane.getTabCount() && this.tabPane.isEnabledAt(selected)) {
                tracker = this.getTracker(selected, this.getRolloverTabIndex() == selected, false);
                tracker.getModel().setSelected(true);
            }
        });
        this.tabPane.getModel().addChangeListener(this.radianceSelectionListener);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.radianceRolloverHandler != null) {
            this.tabPane.removeMouseMotionListener(this.radianceRolloverHandler);
            this.tabPane.removeMouseListener(this.radianceRolloverHandler);
            this.radianceRolloverHandler = null;
        }
        if (this.radianceContainerListener != null) {
            for (Map.Entry entry : this.radianceContainerListener.listeners.entrySet()) {
                Component comp = (Component)entry.getKey();
                for (PropertyChangeListener pcl : (List)entry.getValue()) {
                    comp.removePropertyChangeListener(pcl);
                }
            }
            this.radianceContainerListener.listeners.clear();
            this.tabPane.removeContainerListener(this.radianceContainerListener);
            this.radianceContainerListener = null;
        }
        this.tabPane.getModel().removeChangeListener(this.radianceSelectionListener);
        this.radianceSelectionListener = null;
        for (RadianceThemingWidget radianceThemingWidget : this.themingWidgets) {
            radianceThemingWidget.uninstallListeners();
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.radianceContentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        this.modifiedTimelines = new HashMap<Component, Timeline>();
        this.currSelectedIndex = this.tabPane.getSelectedIndex();
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults() {
        for (Timeline timeline : this.modifiedTimelines.values()) {
            timeline.cancel();
        }
        this.modifiedTimelines.clear();
        for (RadianceThemingWidget radianceThemingWidget : this.themingWidgets) {
            radianceThemingWidget.uninstallDefaults();
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installComponents();
        }
    }

    @Override
    protected void uninstallComponents() {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallComponents();
        }
        super.uninstallComponents();
    }

    private static void paintTabBackgroundAt1X(Graphics2D graphics1X, JTabbedPane tabPane, int tabIndex, double scaleFactor, int width, int height, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme, Color tabColor) {
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(tabPane);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(tabPane);
        int dy = 3;
        EnumSet<RadianceThemingSlices.Side> straightSides = EnumSet.of(RadianceThemingSlices.Side.BOTTOM);
        float cornerRadius = (float)scaleFactor * RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(tabPane));
        Shape contour = RadianceOutlineUtilities.getBaseOutline(tabPane.getComponentOrientation(), --width, height + dy, cornerRadius, straightSides, 1.0f);
        graphics1X.setColor(tabColor);
        graphics1X.fill(contour);
        Graphics2D clipped = (Graphics2D)graphics1X.create();
        clipped.clipRect(0, 0, width, (int)(0.2f * (float)height));
        clipped.setColor(fillPainter.getRepresentativeColor(fillScheme));
        clipped.fill(contour);
        clipped.dispose();
        Shape contourInner = borderPainter.isPaintingInnerContour() ? RadianceOutlineUtilities.getBaseOutline(tabPane.getComponentOrientation(), width, height + dy, cornerRadius - 1.0f, straightSides, 2.0f) : null;
        borderPainter.paintBorder(graphics1X, tabPane, width, height + dy, contour, contourInner, borderScheme);
        RadianceColorScheme blendedBorderScheme = RadianceColorSchemeUtilities.getColorScheme(tabPane, tabIndex, RadianceThemingSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
        Color lineColor = borderPainter.getRepresentativeColor(blendedBorderScheme);
        Color lineColorFullTransparency = RadianceColorUtilities.getAlphaColor(lineColor, 0);
        graphics1X.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{lineColorFullTransparency, lineColorFullTransparency, lineColor}));
        graphics1X.draw(contour);
    }

    private void paintRotationAwareTabBackground(Graphics2D g, JTabbedPane tabPane, int tabIndex, int width, int height, int tabPlacement, RadianceColorScheme colorScheme, RadianceColorScheme borderScheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            Color tabColor;
            Component compForBackground = tabPane.getTabComponentAt(tabIndex);
            if (compForBackground == null) {
                compForBackground = tabPane.getComponentAt(tabIndex);
            }
            if (compForBackground == null) {
                compForBackground = tabPane;
            }
            if ((tabColor = compForBackground.getBackground()) instanceof UIResource) {
                tabColor = RadianceColorUtilities.getBackgroundFillColor(compForBackground);
            }
            if (tabPlacement == 3) {
                AffineTransform transform = AffineTransform.getTranslateInstance(scaledWidth, scaledHeight);
                transform.rotate(Math.PI);
                graphics1X.transform(transform);
            }
            RadianceTabbedPaneUI.paintTabBackgroundAt1X(graphics1X, tabPane, tabIndex, scaleFactor, scaledWidth, scaledHeight, colorScheme, borderScheme, tabColor);
        });
    }

    private void paintCloseButtonImage(Graphics2D g, JTabbedPane tabPane, int width, int height, boolean toPaintBorder, RadianceColorScheme fillScheme, RadianceColorScheme markScheme) {
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(tabPane);
        if (fillPainter == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            if (toPaintBorder) {
                Shape contour = RadianceOutlineUtilities.getBaseOutline(tabPane.getComponentOrientation(), scaledWidth, scaledHeight, 1.0f, null);
                fillPainter.paintContourBackground(graphics1X, tabPane, scaledWidth, scaledHeight, contour, fillScheme);
                RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(tabPane);
                borderPainter.paintBorder(graphics1X, tabPane, scaledWidth, scaledHeight, contour, null, markScheme);
            }
            BladeIconUtils.drawCloseIcon(graphics1X, scaledWidth, RadianceSizeUtils.getTabCloseButtonStrokeWidth(tabPane), markScheme);
        });
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean isRollover;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)this.tabPane, g));
        boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
        ComponentState currState = this.getTabState(tabIndex, false);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(tabIndex);
        boolean bl = isRollover = this.getRolloverTab() == tabIndex;
        if (!isSelected && !isRollover && modelStateInfo == null) {
            return;
        }
        graphics.clip(new Rectangle(x, y, --w, h));
        float finalAlpha = 0.0f;
        StateTransitionTracker tabTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)tabIndex);
        if (!isSelected && modelStateInfo != null) {
            finalAlpha += tabTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.ROLLOVER);
        } else if (isRollover || isSelected) {
            finalAlpha = 1.0f;
        }
        finalAlpha *= RadianceColorSchemeUtilities.getAlpha(this.tabPane.getComponentAt(tabIndex), currState);
        Component comp = this.tabPane.getComponentAt(tabIndex);
        boolean isTabModified = RadianceCoreUtilities.isTabModified(comp);
        boolean toMarkModifiedCloseButton = RadianceCoreUtilities.toAnimateCloseIconOfModifiedTab(this.tabPane, tabIndex);
        graphics.translate(x, y);
        if (isTabModified && isEnabled && !toMarkModifiedCloseButton) {
            BladeUtils.populateModificationAwareColorScheme(this.mutableFillColorScheme, this.modifiedTimelines.get(comp).getTimelinePosition());
            RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, RadianceThemingSlices.ColorSchemeAssociationKind.TAB_BORDER, currState);
            this.paintRotationAwareTabBackground(graphics, this.tabPane, tabIndex, w, h, tabPlacement, this.mutableFillColorScheme, baseBorderScheme);
        } else {
            BladeUtils.populateColorScheme(this.mutableFillColorScheme, this.tabPane, tabIndex, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.TAB, false);
            BladeUtils.populateColorScheme(this.mutableBorderColorScheme, this.tabPane, tabIndex, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.TAB_BORDER, false);
            this.paintRotationAwareTabBackground(graphics, this.tabPane, tabIndex, w, h, tabPlacement, this.mutableFillColorScheme, this.mutableBorderColorScheme);
        }
        graphics.translate(-x, -y);
        if (RadianceCoreUtilities.hasCloseButton(this.tabPane, tabIndex) && isEnabled) {
            float alpha;
            float f = alpha = isSelected || isRollover ? 1.0f : 0.0f;
            if (!isSelected && tabTracker != null) {
                alpha = tabTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.ROLLOVER);
            }
            if ((double)alpha > 0.0) {
                graphics.setComposite(WidgetUtilities.getAlphaComposite(this.tabPane, finalAlpha * alpha, g));
                Rectangle orig = this.getCloseButtonRectangleForDraw(tabIndex, x, y, w, h);
                boolean toPaintCloseBorder = false;
                if (isRollover && this.radianceMouseLocation != null) {
                    Rectangle rect;
                    Rectangle bounds = new Rectangle();
                    bounds = this.getTabBounds(tabIndex, bounds);
                    if (this.toRotateTabsOnPlacement(tabPlacement)) {
                        bounds = new Rectangle(bounds.x, bounds.y, bounds.height, bounds.width);
                    }
                    if ((rect = this.getCloseButtonRectangleForEvents(tabIndex, bounds.x, bounds.y, bounds.width, bounds.height)).contains(this.radianceMouseLocation)) {
                        toPaintCloseBorder = true;
                    }
                }
                graphics.translate(orig.x, orig.y);
                if (isTabModified && isEnabled && toMarkModifiedCloseButton) {
                    BladeUtils.populateModificationAwareColorScheme(this.mutableFillColorScheme, this.modifiedTimelines.get(comp).getTimelinePosition());
                    RadianceColorScheme baseMarkScheme = RadianceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, this.getTabState(tabIndex, true));
                    this.paintCloseButtonImage(graphics, this.tabPane, orig.width, orig.height, toPaintCloseBorder, this.mutableFillColorScheme, baseMarkScheme);
                } else {
                    BladeUtils.populateColorScheme(this.mutableFillColorScheme, this.tabPane, tabIndex, modelStateInfo, this.getTabState(tabIndex, true), RadianceThemingSlices.ColorSchemeAssociationKind.TAB, true);
                    BladeUtils.populateColorScheme(this.mutableMarkColorScheme, this.tabPane, tabIndex, modelStateInfo, this.getTabState(tabIndex, true), RadianceThemingSlices.ColorSchemeAssociationKind.FILL, true);
                    this.paintCloseButtonImage(graphics, this.tabPane, orig.width, orig.height, toPaintCloseBorder, this.mutableFillColorScheme, this.mutableMarkColorScheme);
                }
            }
        }
        graphics.dispose();
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected JButton createScrollButton(final int direction) {
        TabbedPaneScrollButton ssb = new TabbedPaneScrollButton();
        RadianceThemingCortex.ComponentOrParentScope.setButtonIgnoreMinimumSize(ssb, Boolean.TRUE);
        RadianceThemingCortex.ComponentScope.setButtonStraightSides(ssb, EnumSet.allOf(RadianceThemingSlices.Side.class));
        BladeTransitionAwareIcon icon = new BladeTransitionAwareIcon(ssb, new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                int fontSize = RadianceSizeUtils.getComponentFontSize(RadianceTabbedPaneUI.this.tabPane);
                BladeArrowIconUtils.drawArrow(g, fontSize, this.getIconDimension(), direction, scheme, alpha);
            }

            @Override
            public Dimension getIconDimension() {
                int fontSize = RadianceSizeUtils.getComponentFontSize(RadianceTabbedPaneUI.this.tabPane);
                return BladeArrowIconUtils.getArrowIconDimension(fontSize, direction);
            }
        });
        ssb.setIcon(icon);
        return ssb;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        boolean toSwap = this.toRotateTabsOnPlacement(tabPlacement);
        if (toSwap) {
            return this.getTabExtraWidth(tabIndex) + super.calculateTabWidth(tabPlacement, tabIndex, this.getFontMetrics());
        }
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        boolean toSwap = this.toRotateTabsOnPlacement(tabPlacement);
        if (toSwap) {
            return super.calculateTabHeight(tabPlacement, tabIndex, metrics.getHeight());
        }
        return this.getTabExtraWidth(tabIndex) + super.calculateTabWidth(tabPlacement, tabIndex, metrics);
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        if (this.toRotateTabsOnPlacement(tabPlacement)) {
            return super.calculateMaxTabHeight(tabPlacement);
        }
        int result = 0;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            result = Math.max(result, this.calculateTabHeight(tabPlacement, i, this.getFontMetrics().getHeight()));
        }
        return result;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        boolean toSwap = this.toRotateTabsOnPlacement(tabPlacement);
        if (toSwap) {
            return super.getTabRunOverlay(tabPlacement);
        }
        return 0;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (this.tabPane.getLayout().getClass() == TabbedPaneLayout.class) {
            this.paintTabArea(g, tabPlacement, selectedIndex);
        }
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        Graphics2D g2d = (Graphics2D)g.create(x, y, w, h);
        BackgroundPaintingUtils.update(g2d, c, false);
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean toSwap = this.toRotateTabsOnPlacement(tabPlacement);
        if (toSwap) {
            Graphics2D tempG = (Graphics2D)g.create();
            Rectangle tabRect = rects[tabIndex];
            Rectangle correctRect = new Rectangle(tabRect.x, tabRect.y, tabRect.height, tabRect.width);
            if (tabPlacement == 2) {
                tempG.rotate(-1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(-tabRect.height, 0);
            } else {
                tempG.rotate(1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(0.0, -tabRect.getWidth());
            }
            tempG.setColor(Color.red);
            rects[tabIndex] = correctRect;
            super.paintTab(tempG, tabPlacement, rects, tabIndex, iconRect, textRect);
            rects[tabIndex] = tabRect;
            tempG.dispose();
        } else if (this.tabPane.getLayout().getClass() == TabbedPaneLayout.class) {
            super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        } else {
            Graphics2D g2d = (Graphics2D)g.create();
            RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.tabPane.getFont());
            super.paintTab(g2d, tabPlacement, rects, tabIndex, iconRect, textRect);
            g2d.dispose();
        }
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.radianceContentOpaque) {
            int width = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
            if (tabPlacement == 1 || tabPlacement == 3) {
                width = Math.max(width, this.tabPane.getWidth());
            }
            int height = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
            if (this.toRotateTabsOnPlacement(tabPlacement)) {
                height = Math.max(height, this.tabPane.getHeight());
            }
            Graphics2D g2d = (Graphics2D)g.create(0, 0, width, height);
            BackgroundPaintingUtils.update(g2d, this.tabPane, true);
            g2d.dispose();
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    protected Rectangle getCloseButtonRectangleForDraw(int tabIndex, int x, int y, int width, int height) {
        int dimension = RadianceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        int borderDelta = (int)Math.ceil(3.0f + RadianceSizeUtils.getBorderStrokeWidth(this.tabPane));
        int xs = this.tabPane.getComponentOrientation().isLeftToRight() ? x + width - dimension - borderDelta : x + borderDelta;
        int ys = y + (height - dimension) / 2 + 1;
        if (this.tabPane.getTabPlacement() == 3) {
            ys -= 2;
        }
        return new Rectangle(xs, ys, dimension, dimension);
    }

    protected Rectangle getCloseButtonRectangleForEvents(int tabIndex, int x, int y, int w, int h) {
        Point2D transCorner;
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean toSwap = this.toRotateTabsOnPlacement(tabPlacement);
        if (!toSwap) {
            return this.getCloseButtonRectangleForDraw(tabIndex, x, y, w, h);
        }
        int dimension = RadianceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        Rectangle rectForDraw = this.getCloseButtonRectangleForDraw(tabIndex, x, y, h, w);
        AffineTransform trans = new AffineTransform();
        if (tabPlacement == 2) {
            trans.rotate(-1.5707963267948966, x, y);
            trans.translate(-h, 0.0);
            Point2D.Double origCorner = new Point2D.Double(rectForDraw.getMaxX(), rectForDraw.getMinY());
            transCorner = trans.transform(origCorner, null);
        } else {
            trans.rotate(1.5707963267948966, x, y);
            trans.translate(0.0, -w);
            Point2D.Double origCorner = new Point2D.Double(rectForDraw.getMinX(), rectForDraw.getMaxY());
            transCorner = trans.transform(origCorner, null);
        }
        return new Rectangle((int)transCorner.getX(), (int)transCorner.getY(), dimension, dimension);
    }

    protected void ensureCurrentLayout() {
        LayoutManager lm;
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid() && (lm = this.tabPane.getLayout()) instanceof BasicTabbedPaneUI.TabbedPaneLayout) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)lm;
            layout.calculateLayoutInfo();
        }
    }

    protected void tryCloseTabs(int tabIndex, RadianceThemingSlices.TabCloseKind tabCloseKind) {
        if (tabCloseKind == null) {
            return;
        }
        if (tabCloseKind == RadianceThemingSlices.TabCloseKind.NONE) {
            return;
        }
        if (tabCloseKind == RadianceThemingSlices.TabCloseKind.ALL_BUT_THIS) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                if (i == tabIndex) continue;
                indexes.add(i);
            }
            this.tryCloseTabs(indexes);
            return;
        }
        if (tabCloseKind == RadianceThemingSlices.TabCloseKind.ALL) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                indexes.add(i);
            }
            this.tryCloseTabs(indexes);
            return;
        }
        this.tryCloseTab(tabIndex);
    }

    protected void tryCloseTab(int tabIndex) {
        Component component = this.tabPane.getComponentAt(tabIndex);
        HashSet<Component> componentSet = new HashSet<Component>();
        componentSet.add(component);
        boolean isVetoed = false;
        for (BaseTabCloseListener listener : RadianceThemingCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            BaseTabCloseListener vetoableListener;
            if (listener instanceof VetoableTabCloseListener) {
                vetoableListener = (VetoableTabCloseListener)listener;
                boolean bl = isVetoed = isVetoed || vetoableListener.vetoTabClosing(this.tabPane, component);
            }
            if (!(listener instanceof VetoableMultipleTabCloseListener)) continue;
            vetoableListener = (VetoableMultipleTabCloseListener)listener;
            isVetoed = isVetoed || vetoableListener.vetoTabsClosing(this.tabPane, componentSet);
        }
        if (isVetoed) {
            return;
        }
        for (BaseTabCloseListener listener : RadianceThemingCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            if (listener instanceof TabCloseListener) {
                ((TabCloseListener)listener).tabClosing(this.tabPane, component);
            }
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosing(this.tabPane, componentSet);
        }
        this.tabPane.remove(tabIndex);
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener listener : RadianceThemingCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            if (listener instanceof TabCloseListener) {
                ((TabCloseListener)listener).tabClosed(this.tabPane, component);
            }
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosed(this.tabPane, componentSet);
        }
    }

    protected void tryCloseTabs(Set<Integer> tabIndexes) {
        HashSet<Component> componentSet = new HashSet<Component>();
        for (int tabIndex : tabIndexes) {
            componentSet.add(this.tabPane.getComponentAt(tabIndex));
        }
        boolean isVetoed = false;
        for (BaseTabCloseListener listener : RadianceThemingCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof VetoableMultipleTabCloseListener)) continue;
            VetoableMultipleTabCloseListener vetoableListener = (VetoableMultipleTabCloseListener)listener;
            isVetoed = isVetoed || vetoableListener.vetoTabsClosing(this.tabPane, componentSet);
        }
        if (isVetoed) {
            return;
        }
        for (BaseTabCloseListener listener : RadianceThemingCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosing(this.tabPane, componentSet);
        }
        for (Component toRemove : componentSet) {
            this.tabPane.remove(toRemove);
        }
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener listener : RadianceThemingCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosed(this.tabPane, componentSet);
        }
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        int delta = 0;
        if (RadianceCoreUtilities.hasCloseButton(this.tabPane, tabIndex)) {
            delta = this.tabPane.getComponentOrientation().isLeftToRight() ? 5 - RadianceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex) : RadianceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex) - 5;
        }
        return delta + super.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return tabPlacement == 3 ? -1 : 1;
    }

    protected int getTabExtraWidth(int tabIndex) {
        int extraWidth = (int)(2.0 * (double)RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(this.tabPane)));
        if (RadianceCoreUtilities.hasCloseButton(this.tabPane, tabIndex) && this.tabPane.isEnabledAt(tabIndex)) {
            extraWidth += 4 + RadianceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        }
        return extraWidth;
    }

    public int getRolloverTabIndex() {
        return this.getRolloverTab();
    }

    public void setTabAreaInsets(Insets insets) {
        Insets old = this.tabAreaInsets;
        this.tabAreaInsets = insets;
        WidgetUtilities.firePropertyChangeEvent(this.tabPane, "tabAreaInsets", old, this.tabAreaInsets);
    }

    public Insets getTabAreaInsets() {
        return this.tabAreaInsets;
    }

    public Rectangle getTabRectangle(int tabIndex) {
        return this.rects[tabIndex];
    }

    @Override
    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1 && run < this.runCount - 1;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TabbedPaneLayout();
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets insets = RadianceSizeUtils.getTabbedPaneContentInsets(this.tabPane);
        RadianceThemingSlices.TabContentPaneBorderKind kind = RadianceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == RadianceThemingSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        int delta = isDouble ? 2 : 0;
        switch (tabPlacement) {
            case 1: {
                return new Insets(insets.top + delta, 0, 0, 0);
            }
            case 2: {
                return new Insets(0, insets.left + delta, 0, 0);
            }
            case 4: {
                return new Insets(0, 0, 0, insets.right + delta);
            }
            case 3: {
                return new Insets(0, 0, insets.bottom + delta, 0);
            }
        }
        return insets;
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(this.tabPane, selectedIndex, RadianceThemingSlices.ColorSchemeAssociationKind.TAB, ComponentState.ENABLED);
        this.highlight = scheme.getSeparatorSecondaryColor();
        super.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement != 3) {
            return;
        }
        RadianceThemingSlices.TabContentPaneBorderKind kind = RadianceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == RadianceThemingSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(x, y);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)w, (int)h, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            graphics1X.translate(1, 1);
            int joinKind = 1;
            int capKind = 0;
            graphics1X.setStroke(new BasicStroke(1.0f, capKind, joinKind));
            int ribbonDelta = (int)((float)scaleFactor * 3.0f) - 1;
            boolean isUnbroken = selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w;
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.tabPane, selectedIndex, RadianceThemingSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
            Color lineColor = RadianceCoreUtilities.getBorderPainter(this.tabPane).getRepresentativeColor(borderScheme);
            graphics1X.setColor(lineColor);
            if (isUnbroken) {
                graphics1X.drawLine(0, scaledHeight - 1, scaledWidth - 1, scaledHeight - 1);
            } else {
                int delta = 1;
                GeneralPath bottomOutline = new GeneralPath();
                bottomOutline.moveTo(0.0f, scaledHeight - 1);
                bottomOutline.lineTo((float)scaleFactor * (float)selRect.x + 2.0f, scaledHeight - 1);
                if (selRect.x + selRect.width < x + w) {
                    float selectionEndX = (float)scaleFactor * (float)(selRect.x + selRect.width - delta) - 1.0f;
                    bottomOutline.moveTo(selectionEndX, scaledHeight - 1);
                    bottomOutline.lineTo(scaledWidth - 1, scaledHeight - 1);
                }
                graphics1X.draw(bottomOutline);
            }
            if (isDouble) {
                graphics1X.drawLine(0, scaledHeight - 1 - ribbonDelta, scaledWidth - 1, scaledHeight - 1 - ribbonDelta);
            }
        });
        graphics.dispose();
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement != 2) {
            return;
        }
        RadianceThemingSlices.TabContentPaneBorderKind kind = RadianceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == RadianceThemingSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(x, y);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)w, (int)h, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            graphics1X.translate(0, 1);
            int joinKind = 1;
            int capKind = 0;
            graphics1X.setStroke(new BasicStroke(1.0f, capKind, joinKind));
            int ribbonDelta = (int)((float)scaleFactor * 3.0f) - 1;
            boolean isUnbroken = selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h;
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.tabPane, selectedIndex, RadianceThemingSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
            Color lineColor = RadianceCoreUtilities.getBorderPainter(this.tabPane).getRepresentativeColor(borderScheme);
            graphics1X.setColor(lineColor);
            if (isUnbroken) {
                graphics1X.drawLine(0, 0, 0, scaledHeight);
            } else {
                boolean delta = true;
                GeneralPath leftOutline = new GeneralPath();
                leftOutline.moveTo(0.0f, 0.0f);
                leftOutline.lineTo(0.0f, (float)scaleFactor * (float)selRect.y + (float)delta + 2.0f);
                if (selRect.y + selRect.height < y + h) {
                    float selectionEndY = (float)scaleFactor * (float)(selRect.y + selRect.height) - 2.0f;
                    leftOutline.moveTo(0.0f, selectionEndY);
                    leftOutline.lineTo(0.0f, scaledHeight);
                }
                graphics1X.draw(leftOutline);
            }
            if (isDouble) {
                graphics1X.drawLine(ribbonDelta, 0, ribbonDelta, scaledHeight);
            }
        });
        graphics.dispose();
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement != 4) {
            return;
        }
        RadianceThemingSlices.TabContentPaneBorderKind kind = RadianceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == RadianceThemingSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(x, y);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)w, (int)h, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            int joinKind = 1;
            int capKind = 0;
            graphics1X.setStroke(new BasicStroke(1.0f, capKind, joinKind));
            int ribbonDelta = (int)((float)scaleFactor * 3.0f) - 1;
            boolean isUnbroken = selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h;
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.tabPane, selectedIndex, RadianceThemingSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
            Color lineColor = RadianceCoreUtilities.getBorderPainter(this.tabPane).getRepresentativeColor(borderScheme);
            graphics1X.setColor(lineColor);
            if (isUnbroken) {
                graphics1X.drawLine(scaledWidth - 1, 0, scaledWidth - 1, scaledHeight);
            } else {
                boolean delta = true;
                GeneralPath rightOutline = new GeneralPath();
                rightOutline.moveTo(scaledWidth - 1, 0.0f);
                rightOutline.lineTo(scaledWidth - 1, (float)scaleFactor * (float)selRect.y + 1.0f);
                if (selRect.y + selRect.height < y + h) {
                    float selectionEndY = (float)scaleFactor * (float)(selRect.y + selRect.height) - (float)delta - 3.0f;
                    rightOutline.moveTo(scaledWidth - 1, selectionEndY);
                    rightOutline.lineTo(scaledWidth - 1, scaledHeight);
                }
                graphics1X.draw(rightOutline);
            }
            if (isDouble) {
                graphics1X.drawLine(scaledWidth - 1 - ribbonDelta, 0, scaledWidth - 1 - ribbonDelta, scaledHeight);
            }
        });
        graphics.dispose();
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement != 1) {
            return;
        }
        RadianceThemingSlices.TabContentPaneBorderKind kind = RadianceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == RadianceThemingSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(x, y);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)w, (int)h, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            int joinKind = 1;
            int capKind = 0;
            graphics1X.setStroke(new BasicStroke(1.0f, capKind, joinKind));
            int ribbonDelta = (int)((float)scaleFactor * 3.0f) - 1;
            boolean isUnbroken = selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w;
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.tabPane, selectedIndex, RadianceThemingSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
            Color lineColor = RadianceCoreUtilities.getBorderPainter(this.tabPane).getRepresentativeColor(borderScheme);
            graphics1X.setColor(lineColor);
            if (isUnbroken) {
                graphics1X.drawLine(0, 0, scaledWidth, 0);
            } else {
                int delta = 1;
                GeneralPath topOutline = new GeneralPath();
                topOutline.moveTo(0.0f, 0.0f);
                topOutline.lineTo((float)scaleFactor * (float)selRect.x + 1.0f, 0.0f);
                if (selRect.x + selRect.width < x + w) {
                    float selectionEndX = (float)scaleFactor * (float)(selRect.x + selRect.width - delta) - 2.0f;
                    topOutline.moveTo(selectionEndX, 0.0f);
                    topOutline.lineTo(scaledWidth, 0.0f);
                }
                graphics1X.draw(topOutline);
            }
            if (isDouble) {
                graphics1X.drawLine(0, ribbonDelta, scaledWidth, ribbonDelta);
            }
        });
        graphics.dispose();
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    private StateTransitionTracker.ModelStateInfo getModelStateInfo(int tabIndex) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)tabIndex);
        if (tracker == null) {
            return null;
        }
        return tracker.getModelStateInfo();
    }

    protected ComponentState getTabState(int tabIndex, boolean toAllowIgnoringSelectedState) {
        boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)tabIndex);
        boolean ignoreSelectedState = toAllowIgnoringSelectedState;
        if (tracker == null) {
            boolean isRollover;
            boolean bl = isRollover = this.getRolloverTabIndex() == tabIndex;
            boolean isSelected = ignoreSelectedState ? false : this.tabPane.getSelectedIndex() == tabIndex;
            return ComponentState.getState(isEnabled, isRollover, isSelected);
        }
        ComponentState fromTracker = ignoreSelectedState ? tracker.getModelStateInfo().getCurrModelStateNoSelection() : tracker.getModelStateInfo().getCurrModelState();
        return fromTracker;
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            ComponentState currState = this.tabPane.isEnabledAt(tabIndex) ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, RadianceThemingSlices.ColorSchemeAssociationKind.TAB, currState);
            Color fg = scheme.getForegroundColor();
            Graphics2D graphics = (Graphics2D)g.create();
            if (currState.isDisabled()) {
                Color bgFillColor = RadianceColorUtilities.getBackgroundFillColor(this.tabPane);
                fg = RadianceColorUtilities.getInterpolatedColor(fg, bgFillColor, RadianceColorSchemeUtilities.getAlpha(this.tabPane.getComponentAt(tabIndex), currState));
            }
            graphics.clip(this.getTabRectangle(tabIndex));
            RadianceTextUtilities.paintText((Graphics)graphics, textRect, title, mnemIndex, graphics.getFont(), fg, null);
            graphics.dispose();
            this.tabTextColorMap.put(tabIndex, fg);
        }
    }

    @Override
    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(iconRect.x, iconRect.y);
        ComponentState currentState = this.getTabState(tabIndex, true);
        StateTransitionTracker tabTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)tabIndex);
        if (currentState.isDisabled()) {
            Icon disabledIcon = RadianceCoreUtilities.getFilteredIcon(this.tabPane, icon, currentState, this.tabTextColorMap.get(tabIndex));
            disabledIcon.paintIcon(this.tabPane, g2d, 0, 0);
        } else {
            Icon enabledIcon = RadianceCoreUtilities.getFilteredIcon(this.tabPane, icon, ComponentState.ENABLED, this.tabTextColorMap.get(tabIndex));
            enabledIcon.paintIcon(this.tabPane, g2d, 0, 0);
            if (tabTracker != null && tabTracker.getActiveStrength() > 0.0f) {
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : tabTracker.getModelStateInfo().getStateContributionMap().entrySet()) {
                    Icon activeIcon;
                    float contribution;
                    if (entry.getKey() == ComponentState.ENABLED || !((contribution = entry.getValue().getContribution()) > 0.0f) || (activeIcon = RadianceCoreUtilities.getFilteredIcon(this.tabPane, icon, entry.getKey(), this.tabTextColorMap.get(tabIndex))) == enabledIcon) continue;
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(this.tabPane, contribution, g));
                    activeIcon.paintIcon(this.tabPane, g2d, 0, 0);
                }
            }
        }
        g2d.dispose();
    }

    @Override
    protected MouseListener createMouseListener() {
        return null;
    }

    protected boolean toRotateTabsOnPlacement(int tabPlacement) {
        return tabPlacement == 2 || tabPlacement == 4;
    }

    private StateTransitionTracker getTracker(int tabIndex, boolean initialRollover, boolean initialSelected) {
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)tabIndex);
        if (tracker == null) {
            DefaultButtonModel model = new DefaultButtonModel();
            model.setSelected(initialSelected);
            model.setRollover(initialRollover);
            tracker = new StateTransitionTracker((JComponent)this.tabPane, model);
            tracker.registerModelListeners();
            tracker.setRepaintCallback(() -> new TabRepaintCallback(tabIndex));
            this.stateTransitionMultiTracker.addTracker((Comparable<Integer>)tabIndex, tracker);
        }
        return tracker;
    }

    private void trackTabModification(int tabIndex, Component tabComponent) {
        SwingComponentTimeline modifiedTimeline = ((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().modifiedTimelineBuilder(this.tabPane).addCallback((TimelineCallback)new TabRepaintCallback(tabIndex))).build();
        modifiedTimeline.playLoop(Timeline.RepeatBehavior.REVERSE);
        this.modifiedTimelines.put(tabComponent, (Timeline)modifiedTimeline);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(RadianceTabbedPaneUI.this);
        }

        @Override
        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.normalizeTabRuns(tabPlacement, tabCount, start, max);
            }
        }

        @Override
        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        }

        @Override
        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }
    }

    protected class TabRepaintCallback
    extends EventDispatchThreadTimelineCallbackAdapter {
        protected int tabIndex;

        public TabRepaintCallback(int tabIndex) {
            this.tabIndex = tabIndex;
        }

        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintTab();
        }

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintTab();
        }

        protected void repaintTab() {
            SwingUtilities.invokeLater(() -> {
                if (RadianceTabbedPaneUI.this.tabPane == null) {
                    return;
                }
                RadianceTabbedPaneUI.this.ensureCurrentLayout();
                int tabCount = RadianceTabbedPaneUI.this.tabPane.getTabCount();
                if (tabCount > 0 && this.tabIndex < tabCount && this.tabIndex < RadianceTabbedPaneUI.this.rects.length) {
                    Rectangle rect = RadianceTabbedPaneUI.this.getTabBounds(RadianceTabbedPaneUI.this.tabPane, this.tabIndex);
                    RadianceTabbedPaneUI.this.tabPane.repaint(rect);
                }
            });
        }
    }

    private class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        private int prevRolledOver = -1;
        private boolean prevInCloseButton = false;
        private int tabOfPressedCloseButton = -1;

        private MouseRolloverHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int tabIndex = RadianceTabbedPaneUI.this.tabForCoordinate(RadianceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            TabCloseCallback closeCallback = RadianceCoreUtilities.getTabCloseCallback(RadianceTabbedPaneUI.this.tabPane, tabIndex);
            if (closeCallback == null) {
                return;
            }
            RadianceThemingSlices.TabCloseKind tabCloseKind = closeCallback.onAreaClick(RadianceTabbedPaneUI.this.tabPane, tabIndex, e);
            if (tabCloseKind == RadianceThemingSlices.TabCloseKind.NONE) {
                return;
            }
            SwingUtilities.invokeLater(() -> RadianceTabbedPaneUI.this.tryCloseTabs(tabIndex, tabCloseKind));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.handleMouseMoveDrag(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RadianceTabbedPaneUI.this.setRolloverTab(RadianceTabbedPaneUI.this.tabForCoordinate(RadianceTabbedPaneUI.this.tabPane, e.getX(), e.getY()));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!RadianceTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = RadianceTabbedPaneUI.this.tabForCoordinate(RadianceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (tabIndex >= 0 && RadianceTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                Rectangle rect = new Rectangle();
                rect = RadianceTabbedPaneUI.this.getTabBounds(tabIndex, rect);
                Rectangle close = RadianceTabbedPaneUI.this.getCloseButtonRectangleForEvents(tabIndex, rect.x, rect.y, rect.width, rect.height);
                boolean inCloseButton = close.contains(e.getPoint());
                int n = this.tabOfPressedCloseButton = inCloseButton ? tabIndex : -1;
                if (tabIndex != RadianceTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (inCloseButton) {
                        return;
                    }
                    RadianceTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                } else if (RadianceTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    RadianceTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.handleMouseMoveDrag(e);
        }

        private void handleMouseMoveDrag(MouseEvent e) {
            if (e.getSource() != RadianceTabbedPaneUI.this.tabPane) {
                return;
            }
            RadianceTabbedPaneUI.this.setRolloverTab(RadianceTabbedPaneUI.this.tabForCoordinate(RadianceTabbedPaneUI.this.tabPane, e.getX(), e.getY()));
            if (!AnimationConfigurationManager.getInstance().isAnimationAllowed(RadianceThemingSlices.AnimationFacet.ROLLOVER, RadianceTabbedPaneUI.this.tabPane)) {
                return;
            }
            RadianceTabbedPaneUI.this.radianceMouseLocation = e.getPoint();
            int currRolledOver = RadianceTabbedPaneUI.this.getRolloverTab();
            TabCloseCallback tabCloseCallback = RadianceCoreUtilities.getTabCloseCallback(RadianceTabbedPaneUI.this.tabPane, currRolledOver);
            if (currRolledOver == this.prevRolledOver) {
                if (currRolledOver >= 0) {
                    Rectangle rect = new Rectangle();
                    rect = RadianceTabbedPaneUI.this.getTabBounds(currRolledOver, rect);
                    Rectangle close = RadianceTabbedPaneUI.this.getCloseButtonRectangleForEvents(currRolledOver, rect.x, rect.y, rect.width, rect.height);
                    boolean inCloseButton = close.contains(e.getPoint());
                    if (this.prevInCloseButton == inCloseButton) {
                        return;
                    }
                    this.prevInCloseButton = inCloseButton;
                    if (tabCloseCallback != null) {
                        if (inCloseButton) {
                            String closeButtonTooltip = tabCloseCallback.getCloseButtonTooltip(RadianceTabbedPaneUI.this.tabPane, currRolledOver);
                            RadianceTabbedPaneUI.this.tabPane.setToolTipTextAt(currRolledOver, closeButtonTooltip);
                        } else {
                            String areaTooltip = tabCloseCallback.getAreaTooltip(RadianceTabbedPaneUI.this.tabPane, currRolledOver);
                            RadianceTabbedPaneUI.this.tabPane.setToolTipTextAt(currRolledOver, areaTooltip);
                        }
                    }
                    if (currRolledOver >= 0 && currRolledOver < RadianceTabbedPaneUI.this.tabPane.getTabCount()) {
                        StateTransitionTracker tracker = RadianceTabbedPaneUI.this.getTracker(currRolledOver, true, currRolledOver == RadianceTabbedPaneUI.this.currSelectedIndex);
                        tracker.getModel().setRollover(false);
                        tracker.endTransition();
                    }
                }
            } else {
                if (this.prevRolledOver >= 0 && this.prevRolledOver < RadianceTabbedPaneUI.this.tabPane.getTabCount() && RadianceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                    RadianceTabbedPaneUI.this.getTracker(this.prevRolledOver, true, this.prevRolledOver == RadianceTabbedPaneUI.this.currSelectedIndex).getModel().setRollover(false);
                }
                if (currRolledOver >= 0 && currRolledOver < RadianceTabbedPaneUI.this.tabPane.getTabCount() && RadianceTabbedPaneUI.this.tabPane.isEnabledAt(currRolledOver)) {
                    RadianceTabbedPaneUI.this.getTracker(currRolledOver, false, currRolledOver == RadianceTabbedPaneUI.this.currSelectedIndex).getModel().setRollover(true);
                }
            }
            this.prevRolledOver = currRolledOver;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RadianceTabbedPaneUI.this.setRolloverTab(-1);
            if (this.prevRolledOver >= 0 && this.prevRolledOver < RadianceTabbedPaneUI.this.tabPane.getTabCount() && RadianceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                RadianceTabbedPaneUI.this.getTracker(this.prevRolledOver, true, this.prevRolledOver == RadianceTabbedPaneUI.this.currSelectedIndex).getModel().setRollover(false);
                if (RadianceCoreUtilities.getTabCloseCallback(RadianceTabbedPaneUI.this.tabPane, this.prevRolledOver) != null) {
                    RadianceTabbedPaneUI.this.tabPane.setToolTipTextAt(this.prevRolledOver, null);
                }
            }
            this.prevRolledOver = -1;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int tabIndex = RadianceTabbedPaneUI.this.tabForCoordinate(RadianceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (RadianceCoreUtilities.hasCloseButton(RadianceTabbedPaneUI.this.tabPane, tabIndex) && tabIndex == this.tabOfPressedCloseButton) {
                SwingUtilities.invokeLater(() -> {
                    if (tabIndex >= 0 && RadianceTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                        Rectangle rect = new Rectangle();
                        rect = RadianceTabbedPaneUI.this.getTabBounds(tabIndex, rect);
                        Rectangle close = RadianceTabbedPaneUI.this.getCloseButtonRectangleForEvents(tabIndex, rect.x, rect.y, rect.width, rect.height);
                        if (close.contains(e.getPoint())) {
                            TabCloseCallback closeCallback = RadianceCoreUtilities.getTabCloseCallback(RadianceTabbedPaneUI.this.tabPane, tabIndex);
                            RadianceThemingSlices.TabCloseKind tabCloseKind = closeCallback == null ? RadianceThemingSlices.TabCloseKind.THIS : closeCallback.onCloseButtonClick(RadianceTabbedPaneUI.this.tabPane, tabIndex, e);
                            RadianceTabbedPaneUI.this.tryCloseTabs(tabIndex, tabCloseKind);
                        }
                    }
                });
                this.tabOfPressedCloseButton = -1;
            }
        }
    }

    @RadianceInternalButton
    @RadianceInternalArrowButton
    private static class TabbedPaneScrollButton
    extends JButton
    implements UIResource {
        public TabbedPaneScrollButton() {
            this.setRequestFocusEnabled(false);
            this.setIconTextGap(0);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public Insets getInsets(Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            } else {
                insets.set(0, 0, 0, 0);
            }
            return insets;
        }
    }

    private final class TabbedContainerListener
    extends ContainerAdapter {
        private Map<Component, List<PropertyChangeListener>> listeners = new HashMap<Component, List<PropertyChangeListener>>();

        private TabbedContainerListener() {
        }

        private void trackExistingTabs() {
            for (int i = 0; i < RadianceTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                this.trackTab(RadianceTabbedPaneUI.this.tabPane.getComponentAt(i));
            }
        }

        private void trackTab(Component tabComponent) {
            int tabIndex;
            if (tabComponent == null) {
                return;
            }
            PropertyChangeListener tabModifiedListener = propertyChangeEvent -> {
                if ("radiance.theming.internal.contentsModified".equals(propertyChangeEvent.getPropertyName())) {
                    int tabIndex;
                    Object oldValue = propertyChangeEvent.getOldValue();
                    Object newValue = propertyChangeEvent.getNewValue();
                    boolean wasModified = Boolean.TRUE.equals(oldValue);
                    boolean isModified = Boolean.TRUE.equals(newValue);
                    if (wasModified) {
                        if (!isModified) {
                            Timeline modifiedTimeline = (Timeline)RadianceTabbedPaneUI.this.modifiedTimelines.get(tabComponent);
                            modifiedTimeline.cancel();
                            RadianceTabbedPaneUI.this.modifiedTimelines.remove(tabComponent);
                        }
                    } else if (isModified && (tabIndex = RadianceTabbedPaneUI.this.tabPane.indexOfComponent(tabComponent)) >= 0) {
                        RadianceTabbedPaneUI.this.trackTabModification(tabIndex, tabComponent);
                    }
                }
            };
            tabComponent.addPropertyChangeListener(tabModifiedListener);
            List<PropertyChangeListener> currList = this.listeners.get(tabComponent);
            if (currList == null) {
                currList = new LinkedList<PropertyChangeListener>();
            }
            currList.add(tabModifiedListener);
            this.listeners.put(tabComponent, currList);
            if (tabComponent instanceof JComponent && Boolean.TRUE.equals(((JComponent)tabComponent).getClientProperty("radiance.theming.internal.contentsModified")) && (tabIndex = RadianceTabbedPaneUI.this.tabPane.indexOfComponent(tabComponent)) >= 0) {
                RadianceTabbedPaneUI.this.trackTabModification(tabIndex, tabComponent);
            }
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component tabComponent = e.getChild();
            if (tabComponent instanceof UIResource) {
                return;
            }
            this.trackTab(tabComponent);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component tabComponent = e.getChild();
            if (tabComponent == null) {
                return;
            }
            if (tabComponent instanceof UIResource) {
                return;
            }
            for (PropertyChangeListener pcl : this.listeners.get(tabComponent)) {
                tabComponent.removePropertyChangeListener(pcl);
            }
            this.listeners.get(tabComponent).clear();
            this.listeners.remove(tabComponent);
            Timeline timeline = (Timeline)RadianceTabbedPaneUI.this.modifiedTimelines.get(tabComponent);
            if (timeline != null) {
                timeline.cancel();
                RadianceTabbedPaneUI.this.modifiedTimelines.remove(tabComponent);
            }
        }
    }
}

