/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.internal.animation.ModificationAwareUI;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class ButtonBackgroundDelegate {
    private BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();

    private void drawBackground(Graphics2D graphics, AbstractButton button, RadianceButtonShaper shaper, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int width, int height) {
        ModificationAwareUI modificationAwareUI;
        Timeline modificationTimeline;
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker.ModelStateInfo modelStateInfo = transitionAwareUI.getTransitionTracker().getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        Set<RadianceThemingSlices.Side> openSides = RadianceCoreUtilities.getSides(button, "radiance.theming.internal.buttonOpenSide");
        boolean isContentAreaFilled = button.isContentAreaFilled();
        boolean isBorderPainted = button.isBorderPainted();
        if (button.getUI() instanceof ModificationAwareUI && (modificationTimeline = (modificationAwareUI = (ModificationAwareUI)((Object)button.getUI())).getModificationTimeline()) != null && modificationTimeline.getState() != Timeline.TimelineState.IDLE) {
            BladeUtils.populateModificationAwareColorScheme(this.mutableFillColorScheme, modificationTimeline.getTimelinePosition());
            RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
            this.drawBackground(graphics, button, shaper, fillPainter, borderPainter, width, height, this.mutableFillColorScheme, baseBorderScheme, openSides, isContentAreaFilled, isBorderPainted);
            return;
        }
        BladeUtils.populateColorScheme(this.mutableFillColorScheme, button, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, false);
        BladeUtils.populateColorScheme(this.mutableBorderColorScheme, button, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, false);
        this.drawBackground(graphics, button, shaper, fillPainter, borderPainter, width, height, this.mutableFillColorScheme, this.mutableBorderColorScheme, openSides, isContentAreaFilled, isBorderPainted);
    }

    private void drawBackground(Graphics2D g, AbstractButton button, RadianceButtonShaper shaper, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int width, int height, RadianceColorScheme colorScheme, RadianceColorScheme borderScheme, Set<RadianceThemingSlices.Side> openSides, boolean isContentAreaFilled, boolean isBorderPainted) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            ComponentOrientation orientation = button.getComponentOrientation();
            RadianceThemingSlices.Side leftSide = orientation.isLeftToRight() ? RadianceThemingSlices.Side.LEADING : RadianceThemingSlices.Side.TRAILING;
            RadianceThemingSlices.Side rightSide = orientation.isLeftToRight() ? RadianceThemingSlices.Side.TRAILING : RadianceThemingSlices.Side.LEADING;
            int openDelta = (int)(3.0 * scaleFactor);
            int deltaLeft = openSides != null && openSides.contains((Object)leftSide) ? openDelta : 0;
            int deltaRight = openSides != null && openSides.contains((Object)rightSide) ? openDelta : 0;
            int deltaTop = openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.TOP) ? openDelta : 0;
            int deltaBottom = openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.BOTTOM) ? openDelta : 0;
            Shape contourOuter = shaper.getButtonOutline(button, 0.0f, scaledWidth + deltaLeft + deltaRight, scaledHeight + deltaTop + deltaBottom, scaleFactor, false);
            graphics1X.translate(-deltaLeft, -deltaTop);
            if (isContentAreaFilled) {
                Shape contourFill = isBorderPainted ? shaper.getButtonOutline(button, 0.5f, (float)(scaledWidth + deltaLeft + deltaRight) + 1.0f, (float)(scaledHeight + deltaTop + deltaBottom) + 1.0f, scaleFactor, false) : contourOuter;
                fillPainter.paintContourBackground(graphics1X, button, scaledWidth + deltaLeft + deltaRight, scaledHeight + deltaTop + deltaBottom, contourFill, colorScheme);
            }
            if (isBorderPainted) {
                Shape contourInner = borderPainter.isPaintingInnerContour() ? shaper.getButtonOutline(button, 1.0f, scaledWidth + deltaLeft + deltaRight, scaledHeight + deltaTop + deltaBottom, scaleFactor, true) : null;
                borderPainter.paintBorder(graphics1X, button, scaledWidth + deltaLeft + deltaRight, scaledHeight + deltaTop + deltaBottom, contourOuter, contourInner, borderScheme);
            }
            graphics1X.translate(deltaLeft, deltaTop);
        });
        graphics.dispose();
    }

    public void updateBackground(Graphics g, AbstractButton button) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (RadianceCoreUtilities.isComponentNeverPainted(button)) {
            return;
        }
        int width = button.getWidth();
        int height = button.getHeight();
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        boolean isFlat = RadianceCoreUtilities.hasFlatAppearance(button);
        float extraAlpha = 1.0f;
        if (isFlat) {
            extraAlpha = 0.0f;
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                ComponentState activeState = activeEntry.getKey();
                if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                extraAlpha += activeEntry.getValue().getContribution();
            }
        } else if (!button.isEnabled()) {
            extraAlpha = RadianceColorSchemeUtilities.getAlpha(button, modelStateInfo.getCurrModelState());
        }
        if (extraAlpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(WidgetUtilities.getAlphaComposite(button, extraAlpha, g));
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(button);
            RadianceButtonShaper shaper = RadianceCoreUtilities.getButtonShaper(button);
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(button);
            this.drawBackground(graphics, button, shaper, fillPainter, borderPainter, width, height);
            graphics.dispose();
        }
    }

    public static boolean contains(AbstractButton button, int x, int y) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return false;
        }
        RadianceButtonShaper shaper = RadianceCoreUtilities.getButtonShaper(button);
        if (shaper == null) {
            return false;
        }
        Shape contour = shaper.getButtonOutline(button, 0.0f, button.getWidth(), button.getHeight(), RadianceCommonCortex.getScaleFactor((Component)button), false);
        return contour.contains(x, y);
    }
}

