/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.EnumSet;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalArrowButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

@RadianceInternalButton
@RadianceInternalArrowButton
public final class RadianceDropDownButton
extends JButton {
    public RadianceDropDownButton(JComponent parent) {
        super("");
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() || armed);
            }
        });
        this.setEnabled(parent.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(parent.isEnabled());
        int fontSize = RadianceSizeUtils.getComponentFontSize(parent);
        int tbInset = RadianceSizeUtils.getAdjustedSize(fontSize, 1, 2, 1, false);
        this.setBorder(new EmptyBorder(tbInset + 1, 0, tbInset - 1, 0));
        RadianceCoreUtilities.markButtonAsFlat(this);
        RadianceThemingCortex.ComponentScope.setButtonStraightSides(this, EnumSet.allOf(RadianceThemingSlices.Side.class));
    }

    @Override
    public void setBorder(Border border) {
        if (!(border instanceof EmptyBorder)) {
            return;
        }
        super.setBorder(border);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        int width = this.getWidth();
        int height = this.getHeight();
        int clipDelta = (int)RadianceSizeUtils.getBorderStrokeWidth(this);
        if (this.getComponentOrientation().isLeftToRight()) {
            g2d.clipRect(clipDelta, 0, width - clipDelta, height);
        } else {
            g2d.clipRect(0, 0, width - clipDelta, height);
        }
        super.paint(g2d);
        g2d.dispose();
    }

    static {
        AnimationConfigurationManager.getInstance().disallowAnimations(RadianceThemingSlices.AnimationFacet.GHOSTING_BUTTON_PRESS, RadianceDropDownButton.class);
        AnimationConfigurationManager.getInstance().disallowAnimations(RadianceThemingSlices.AnimationFacet.GHOSTING_ICON_ROLLOVER, RadianceDropDownButton.class);
    }
}

