/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.internal.utils.ConicalGradientPaint;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSplitPaneDivider;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.filters.ColorSchemeFilter;
import org.pushingpixels.radiance.theming.internal.utils.filters.ImageColorFilter;

public final class RadianceImageCreator {
    private static final int[] crayonColors = new int[]{0x800000, 0x808000, 32768, 32896, 128, 0x800080, 0x7F7F7F, 0x808080, 0x804000, 0x408000, 32832, 16512, 0x400080, 0x800040, 0x666666, 0x999999, 0xFF0000, 0xFFFF00, 65280, 65535, 255, 0xFF00FF, 0x4C4C4C, 0xB3B3B3, 0xFF8000, 0x80FF00, 65408, 33023, 0x8000FF, 0xFF0080, 0x333333, 0xCCCCCC, 0xFF6666, 0xFFFF66, 0x66FF66, 0x66FFFF, 0x6666FF, 0xFF66FF, 0x191919, 0xE6E6E6, 0xFFCC66, 0xCCFF66, 0x66FFCC, 0x66CCFF, 0xCC66FF, 0xFF6FCF, 0, 0xFFFFFF};

    private static AlphaComposite getAlphaComposite(float alpha) {
        float finalAlpha = alpha;
        if (finalAlpha < 0.0f) {
            finalAlpha = 0.0f;
        } else if (finalAlpha > 1.0f) {
            finalAlpha = 1.0f;
        }
        return AlphaComposite.getInstance(3, finalAlpha);
    }

    public static void paintSplitDividerBumpImage(Graphics g, RadianceSplitPaneDivider divider, int x, int y, int width, int height, boolean isHorizontal, RadianceColorScheme colorScheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int componentFontSize = RadianceSizeUtils.getComponentFontSize(divider);
        int bumpDotDiameter = RadianceSizeUtils.getBigDragBumpDiameter(componentFontSize);
        int bumpCellSize = (int)(1.5 * (double)bumpDotDiameter + 1.0);
        int bumpRows = isHorizontal ? 1 : Math.max(1, height / bumpCellSize - 1);
        int bumpColumns = isHorizontal ? Math.max(1, (width - 2) / bumpCellSize) : 1;
        int bumpRowOffset = (height - bumpCellSize * bumpRows) / 2;
        int bumpColOffset = 1 + (width - bumpCellSize * bumpColumns) / 2;
        double scale = RadianceCommonCortex.getScaleFactor((Component)divider);
        BufferedImage singleDot = RadianceCoreUtilities.getBlankImage(scale, bumpDotDiameter, bumpDotDiameter);
        Graphics2D dotGraphics = (Graphics2D)singleDot.getGraphics();
        dotGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        dotGraphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        dotGraphics.setColor(colorScheme.getMarkColor());
        dotGraphics.fillOval(0, 0, bumpDotDiameter, bumpDotDiameter);
        dotGraphics.setComposite(RadianceImageCreator.getAlphaComposite(0.4f));
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(divider);
        borderPainter.paintBorder(dotGraphics, divider, bumpDotDiameter, bumpDotDiameter, new Ellipse2D.Float(0.0f, 0.0f, bumpDotDiameter, bumpDotDiameter), null, colorScheme);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(divider, 0.8f, g));
        for (int col = 0; col < bumpColumns; ++col) {
            int cx = bumpColOffset + col * bumpCellSize;
            for (int row = 0; row < bumpRows; ++row) {
                int cy = bumpRowOffset + row * bumpCellSize + (bumpCellSize - bumpDotDiameter) / 2;
                RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)singleDot, (int)cx, (int)cy);
            }
        }
        graphics.dispose();
    }

    private static BufferedImage getSingleCrayon(double scale, Color mainColor, int width, int height) {
        BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, width, height);
        int tipBase = (int)(0.2 * (double)height);
        int capBase = (int)(0.4 * (double)height);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color lightColor = RadianceColorUtilities.getLighterColor(mainColor, 0.6);
        Color darkColor = RadianceColorUtilities.getDarkerColor(mainColor, 0.2);
        Color desaturatedLight = RadianceColorUtilities.getSaturatedColor(RadianceColorUtilities.getLighterColor(mainColor, 0.3), -0.4f);
        Color desaturatedDark = RadianceColorUtilities.getSaturatedColor(RadianceColorUtilities.getInterpolatedColor(RadianceColorUtilities.getDarkerColor(mainColor, 0.2), Color.lightGray, 0.6), -0.4f);
        LinearGradientPaint capFillPaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.45f, 1.0f}, new Color[]{desaturatedLight, darkColor, desaturatedLight}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics.setPaint(capFillPaint);
        graphics.fillRect(0, tipBase, width, height - tipBase);
        LinearGradientPaint caseFillPaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.45f, 1.0f}, new Color[]{desaturatedDark, lightColor, desaturatedDark}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setComposite(AlphaComposite.getInstance(3, 0.8f));
        graphics.setPaint(caseFillPaint);
        graphics.fillRect(0, capBase, width, height - capBase);
        graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Color sideStripeColor = RadianceColorUtilities.getSaturatedColor(lightColor, -0.1f);
        Color midStripeColor = RadianceColorUtilities.getSaturatedColor(lightColor, -0.25);
        int stripeTop = (int)(0.25 * (double)height);
        int stripeHeight = (int)(0.04 * (double)height);
        LinearGradientPaint stripeFillPaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.45f, 1.0f}, new Color[]{sideStripeColor, midStripeColor, sideStripeColor}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(stripeFillPaint);
        graphics.fillRect(0, stripeTop, width, stripeHeight);
        graphics.setColor(RadianceColorUtilities.getInterpolatedColor(sideStripeColor, Color.gray, 0.3));
        graphics.drawLine(0, stripeTop, 0, stripeTop + stripeHeight);
        graphics.drawLine(width - 1, stripeTop, width - 1, stripeTop + stripeHeight);
        graphics.setColor(darkColor);
        graphics.drawRect(0, tipBase, width - 1, stripeTop - tipBase);
        graphics.setPaint(new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.45f, 1.0f}, new Color[]{darkColor, RadianceColorUtilities.getDarkerColor(mainColor, 0.4), darkColor}, MultipleGradientPaint.CycleMethod.REPEAT));
        graphics.drawRect(0, stripeTop + stripeHeight, width - 1, capBase - stripeTop - stripeHeight);
        graphics.setColor(RadianceColorUtilities.getInterpolatedColor(mainColor, Color.gray, 0.6));
        graphics.drawLine(0, capBase, 0, height);
        graphics.drawLine(width - 1, capBase, width - 1, height);
        GeneralPath capPath = new GeneralPath();
        capPath.moveTo(0.5f * (float)width - 3.0f, 4.0f);
        capPath.quadTo(0.5f * (float)width, 0.0f, 0.5f * (float)width + 3.0f, 4.0f);
        capPath.lineTo(width - 3, tipBase);
        capPath.lineTo(2.0f, tipBase);
        capPath.lineTo(0.5f * (float)width - 3.0f, 4.0f);
        graphics.setClip(capPath);
        ConicalGradientPaint tipFillPaint = new ConicalGradientPaint(true, new Point2D.Double(0.5 * (double)width, 0.0), 0.0f, new float[]{0.0f, 162.0f, 179.0f, 183.0f, 198.0f, 360.0f}, new Color[]{desaturatedLight, desaturatedLight, darkColor, darkColor, desaturatedLight, desaturatedLight});
        graphics.setPaint(tipFillPaint);
        graphics.fillRect(0, 0, width, tipBase);
        graphics.setStroke(new BasicStroke(1.0f, 1, 1));
        graphics.setClip(new Rectangle2D.Double(0.0, 0.0, width, tipBase));
        graphics.setColor(darkColor);
        graphics.draw(capPath);
        graphics.dispose();
        return image;
    }

    private static int crayonX(int i) {
        return i % 8 * 22 + 4 + i / 8 % 2 * 11;
    }

    private static int crayonY(int i) {
        return i / 8 * 20 + 23;
    }

    public static Image getCrayonsImage(Color fillColor) {
        int iw = 195;
        int ih = 208;
        double scale = RadianceCommonCortex.getScaleFactor(null);
        BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, iw, ih);
        Graphics2D graphics = (Graphics2D)((Image)image).getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics.setColor(fillColor);
        graphics.fillRect(0, 0, iw, ih);
        for (int i = 0; i < crayonColors.length; ++i) {
            Color crayonColor = new Color(0xFF000000 | crayonColors[i]);
            BufferedImage crayonImage = RadianceImageCreator.getSingleCrayon(scale, crayonColor, 22, 120);
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)crayonImage, (int)RadianceImageCreator.crayonX(i), (int)RadianceImageCreator.crayonY(i));
        }
        graphics.dispose();
        return image;
    }

    public static Icon getSmallLockIcon(RadianceColorScheme scheme, Component c) {
        int componentFontSize = RadianceSizeUtils.getComponentFontSize(c);
        int extraPadding = RadianceSizeUtils.getExtraPadding(componentFontSize);
        int size = 9 + 2 * extraPadding;
        return RadianceThemingCortex.GlobalScope.getIconPack().getLockIcon(size, scheme);
    }

    public static Icon getCapsLockIcon(RadianceColorScheme scheme, Component c) {
        return RadianceThemingCortex.GlobalScope.getIconPack().getCapsLockIcon(32, scheme);
    }

    public static BufferedImage getColorSchemeImage(Component comp, Icon original, RadianceColorScheme colorScheme, float originalBrightnessFactor) {
        int w = original.getIconWidth();
        int h = original.getIconHeight();
        if (w == 0 || h == 0) {
            return null;
        }
        double scale = RadianceCommonCortex.getScaleFactor((Component)comp);
        BufferedImage origImage = RadianceCoreUtilities.getBlankImage(scale, w, h);
        Graphics2D g2d = (Graphics2D)origImage.getGraphics().create();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        original.paintIcon(comp, origImage.getGraphics(), 0, 0);
        g2d.dispose();
        BufferedImage result = RadianceImageCreator.getColorSchemeImage(origImage, colorScheme, originalBrightnessFactor, 1.0f);
        return result;
    }

    public static BufferedImage getColorSchemeImage(BufferedImage original, RadianceColorScheme colorScheme, float originalBrightnessFactor, float alpha) {
        return ColorSchemeFilter.getColorSchemeFilter(colorScheme, originalBrightnessFactor, alpha).filter(original, null);
    }

    public static BufferedImage getColorImage(Component comp, Icon original, Color color, float alpha) {
        int w = original.getIconWidth();
        int h = original.getIconHeight();
        if (w == 0 || h == 0) {
            return null;
        }
        BufferedImage origImage = RadianceCoreUtilities.getBlankImage(RadianceCommonCortex.getScaleFactor((Component)comp), w, h);
        Graphics2D g2d = (Graphics2D)origImage.getGraphics().create();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        original.paintIcon(comp, origImage.getGraphics(), 0, 0);
        g2d.dispose();
        return new ImageColorFilter(color, alpha).filter(origImage, null);
    }
}

