/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.titlepane.TitlePaneButtonProvider;
import org.pushingpixels.radiance.theming.api.titlepane.TitlePaneButtonsProvider;
import org.pushingpixels.radiance.theming.internal.blade.BladeTransitionAwareIcon;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceMenuBarUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitleButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitlePaneUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected PropertyChangeListener radiancePropertyListener;
    private PropertyChangeListener radianceWinModifiedListener;
    private static final String ICONIFYING = "radiance.theming.internal.internalTitleFramePane.iconifying";
    private static final String UNINSTALLED = "radiance.theming.internal.internalTitleFramePane.uninstalled";
    private TitlePaneButtonsProvider titlePaneButtonsProvider;

    public RadianceInternalFrameTitlePane(JInternalFrame f) {
        super(f);
        this.setToolTipText(f.getTitle());
        RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType(this, RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (RadianceCoreUtilities.isCurrentLookAndFeel()) {
            this.setForeground(RadianceColorUtilities.getForegroundColor(RadianceCoreUtilities.getSkin(this.frame).getActiveColorScheme(RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE)));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radiancePropertyListener = propertyChangeEvent -> {
            if ("title".equals(propertyChangeEvent.getPropertyName())) {
                this.setToolTipText((String)propertyChangeEvent.getNewValue());
            }
            if ("JInternalFrame.messageType".equals(propertyChangeEvent.getPropertyName())) {
                this.updateOptionPaneState();
                this.frame.repaint();
            }
        };
        this.frame.addPropertyChangeListener(this.radiancePropertyListener);
        this.radianceWinModifiedListener = propertyChangeEvent -> {
            if ("radiance.theming.internal.contentsModified".equals(propertyChangeEvent.getPropertyName())) {
                this.closeButton.setToolTipText(this.titlePaneButtonsProvider.getCloseButtonProvider().getText(this.frame.getRootPane()));
            }
            if ("radiance.theming.internal.titlePaneButtonsProvider".equals(propertyChangeEvent.getPropertyName())) {
                this.setButtonIcons();
            }
        };
        this.frame.getRootPane().addPropertyChangeListener(this.radianceWinModifiedListener);
    }

    @Override
    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new RadianceMenuBar();
        this.menuBar.setBorderPainted(true);
        this.menuBar.setOpaque(false);
        this.menuBar.setFocusable(false);
        this.menuBar.applyComponentOrientation(this.getComponentOrientation());
        RadianceThemingSlices.TitleIconHorizontalGravity iconGravity = RadianceTitlePaneUtilities.getTitlePaneIconGravity();
        RadianceTitlePaneUtilities.markTitlePaneExtraComponent(this.menuBar, iconGravity == RadianceThemingSlices.TitleIconHorizontalGravity.NEXT_TO_TITLE ? RadianceTitlePaneUtilities.ExtraComponentKind.WITH_TITLE : RadianceTitlePaneUtilities.ExtraComponentKind.LEADING);
        return this.menuBar;
    }

    @Override
    public void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        this.frame.getRootPane().removePropertyChangeListener(this.radianceWinModifiedListener);
        this.radianceWinModifiedListener = null;
        super.uninstallListeners();
    }

    public void uninstall() {
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            RadianceMenuBarUI ui;
            MenuBarUI menuBarUI = this.menuBar.getUI();
            if (menuBarUI instanceof RadianceMenuBarUI && (ui = (RadianceMenuBarUI)menuBarUI).getMenuBar() == this.menuBar) {
                menuBarUI.uninstallUI(this.menuBar);
            }
            RadianceCoreUtilities.uninstallMenu(this.menuBar.getMenu(0));
            this.remove(this.menuBar);
            this.remove(this.maxButton);
            this.remove(this.closeButton);
            this.remove(this.iconButton);
        }
        this.uninstallListeners();
        this.putClientProperty(UNINSTALLED, Boolean.TRUE);
    }

    @Override
    protected void enableActions() {
        super.enableActions();
        if (!this.frame.isIcon()) {
            if (this.maxButton != null) {
                this.maxButton.setEnabled(this.maximizeAction.isEnabled() || this.restoreAction.isEnabled());
            }
            if (this.iconButton != null) {
                this.iconButton.setEnabled(this.iconifyAction.isEnabled());
            }
        }
    }

    private String getDisplayTitle() {
        String theTitle = this.frame.getTitle();
        if (theTitle == null) {
            return null;
        }
        FontUIResource font = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
        Rectangle titleTextRect = RadianceTitlePaneUtilities.getTitlePaneTextRectangle(this, this.frame);
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics(RadianceCommonCortex.getScaleFactor((Component)this), font);
        int titleWidth = titleTextRect.width - 20;
        String clippedTitle = RadianceCoreUtilities.clipString(fm, titleWidth, theTitle);
        return clippedTitle;
    }

    @Override
    public void paintComponent(Graphics g) {
        Color backgr;
        JInternalFrame hostFrame;
        Graphics2D graphics = (Graphics2D)g.create();
        float coef = this.getParent() instanceof JInternalFrame.JDesktopIcon ? 0.9f : 1.0f;
        graphics.setComposite(WidgetUtilities.getAlphaComposite(this.frame, coef, g));
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight() + 2;
        RadianceColorScheme scheme = RadianceCoreUtilities.getSkin(this.frame).getEnabledColorScheme(RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
        JComponent hostForColorization = hostFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, this);
        if (hostFrame == null) {
            JInternalFrame.JDesktopIcon desktopIcon = (JInternalFrame.JDesktopIcon)SwingUtilities.getAncestorOfClass(JInternalFrame.JDesktopIcon.class, this);
            if (desktopIcon != null) {
                hostFrame = desktopIcon.getInternalFrame();
            }
            hostForColorization = desktopIcon;
        }
        if (!((backgr = hostFrame.getBackground()) instanceof UIResource)) {
            double colorization = RadianceCoreUtilities.getColorizationFactor(hostForColorization);
            scheme = RadianceColorSchemeUtilities.getShiftedScheme(scheme, backgr, colorization, null, 0.0);
        }
        BackgroundPaintingUtils.update(graphics, this, false);
        String theTitle = this.frame.getTitle();
        String displayTitle = this.getDisplayTitle();
        FontUIResource font = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
        graphics.setFont(font);
        if (displayTitle != null) {
            Rectangle titleTextRect = RadianceTitlePaneUtilities.getTitlePaneTextRectangle(this, this.frame);
            FontMetrics fm = g.getFontMetrics();
            int displayTitleWidth = fm.stringWidth(displayTitle);
            if (theTitle.equals(displayTitle)) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(theTitle);
            }
            int xOffset = 0;
            RadianceThemingSlices.HorizontalGravity titleTextGravity = RadianceTitlePaneUtilities.getTitlePaneTextGravity();
            switch (titleTextGravity) {
                case LEADING: {
                    xOffset = leftToRight ? titleTextRect.x : titleTextRect.x + titleTextRect.width - displayTitleWidth;
                    break;
                }
                case TRAILING: {
                    xOffset = leftToRight ? titleTextRect.x + titleTextRect.width - displayTitleWidth : titleTextRect.x;
                    break;
                }
                default: {
                    xOffset = titleTextRect.x + (titleTextRect.width - displayTitleWidth) / 2;
                }
            }
            int yOffset = titleTextRect.y + (int)((titleTextRect.getHeight() - (double)fm.getHeight()) / 2.0) + fm.getAscent();
            RadianceTextUtilities.paintTextWithDropShadow(this, graphics, scheme.getForegroundColor(), scheme.getEchoColor(), displayTitle, width, height, xOffset, yOffset);
        }
        graphics.dispose();
    }

    @Override
    protected void setButtonIcons() {
        this.titlePaneButtonsProvider = RadianceCoreUtilities.getTitlePaneButtonsProvider(this.frame.getRootPane());
        super.setButtonIcons();
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        final TitlePaneButtonProvider restoreButtonProvider = this.titlePaneButtonsProvider.getRestoreButtonProvider();
        BladeTransitionAwareIcon restoreIcon = new BladeTransitionAwareIcon(this.frame.isIcon() ? this.iconButton : this.maxButton, new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                restoreButtonProvider.drawIcon(g, scheme, alpha, RadianceSizeUtils.getTitlePaneIconSize());
            }

            @Override
            public Dimension getIconDimension() {
                int size = RadianceSizeUtils.getTitlePaneIconSize();
                return new Dimension(size, size);
            }
        });
        final TitlePaneButtonProvider maximizeButtonProvider = this.titlePaneButtonsProvider.getMaximizeButtonProvider();
        BladeTransitionAwareIcon maximizeIcon = new BladeTransitionAwareIcon(this.maxButton, new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                maximizeButtonProvider.drawIcon(g, scheme, alpha, RadianceSizeUtils.getTitlePaneIconSize());
            }

            @Override
            public Dimension getIconDimension() {
                int size = RadianceSizeUtils.getTitlePaneIconSize();
                return new Dimension(size, size);
            }
        });
        final TitlePaneButtonProvider iconifyButtonProvider = this.titlePaneButtonsProvider.getIconifyButtonProvider();
        BladeTransitionAwareIcon iconifyIcon = new BladeTransitionAwareIcon(this.iconButton, new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                iconifyButtonProvider.drawIcon(g, scheme, alpha, RadianceSizeUtils.getTitlePaneIconSize());
            }

            @Override
            public Dimension getIconDimension() {
                int size = RadianceSizeUtils.getTitlePaneIconSize();
                return new Dimension(size, size);
            }
        });
        final TitlePaneButtonProvider closeButtonProvider = this.titlePaneButtonsProvider.getCloseButtonProvider();
        BladeTransitionAwareIcon closeIcon = new BladeTransitionAwareIcon(this.closeButton, new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                closeButtonProvider.drawIcon(g, scheme, alpha, RadianceSizeUtils.getTitlePaneIconSize());
            }

            @Override
            public Dimension getIconDimension() {
                int size = RadianceSizeUtils.getTitlePaneIconSize();
                return new Dimension(size, size);
            }
        });
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(restoreIcon);
            this.iconButton.setToolTipText(restoreButtonProvider.getText(this.frame.getRootPane()));
            this.maxButton.setIcon(maximizeIcon);
            this.maxButton.setToolTipText(maximizeButtonProvider.getText(this.frame.getRootPane()));
        } else {
            this.iconButton.setIcon(iconifyIcon);
            this.iconButton.setToolTipText(iconifyButtonProvider.getText(this.frame.getRootPane()));
            if (this.frame.isMaximum()) {
                this.maxButton.setIcon(restoreIcon);
                this.maxButton.setToolTipText(restoreButtonProvider.getText(this.frame.getRootPane()));
            } else {
                this.maxButton.setIcon(maximizeIcon);
                this.maxButton.setToolTipText(maximizeButtonProvider.getText(this.frame.getRootPane()));
            }
        }
        this.closeButton.setIcon(closeIcon);
        this.closeButton.setToolTipText(closeButtonProvider.getText(this.frame.getRootPane()));
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.iconifyAction = new RadianceIconifyAction();
    }

    @Override
    protected void createButtons() {
        this.iconButton = new RadianceTitleButton("InternalFrameTitlePane.iconifyButtonAccessibleName");
        this.iconButton.addActionListener(this.iconifyAction);
        this.maxButton = new RadianceTitleButton("InternalFrameTitlePane.maximizeButtonAccessibleName");
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new RadianceTitleButton("InternalFrameTitlePane.closeButtonAccessibleName");
        this.closeButton.addActionListener(this.closeAction);
        RadianceTitlePaneUtilities.ExtraComponentKind buttonExtraComponentKind = RadianceTitlePaneUtilities.getTitlePaneControlButtonKind(this.frame.getRootPane());
        RadianceTitlePaneUtilities.markTitlePaneExtraComponent(this.iconButton, buttonExtraComponentKind);
        RadianceTitlePaneUtilities.markTitlePaneExtraComponent(this.maxButton, buttonExtraComponentKind);
        RadianceTitlePaneUtilities.markTitlePaneExtraComponent(this.closeButton, buttonExtraComponentKind);
        this.setButtonIcons();
        for (ActionListener listener : this.iconButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.iconButton.addActionListener(new ClickListener());
        for (ActionListener listener : this.maxButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.maxButton.addActionListener(new ClickListener());
        RadianceCoreUtilities.markButtonAsFlat(this.iconButton);
        RadianceCoreUtilities.markButtonAsFlat(this.maxButton);
        RadianceCoreUtilities.markButtonAsFlat(this.closeButton);
        this.enableActions();
    }

    @Override
    protected LayoutManager createLayout() {
        return new RadianceTitlePaneLayout();
    }

    @Override
    public void removeNotify() {
        boolean isAlive;
        super.removeNotify();
        boolean bl = isAlive = this.frame.isIcon() && !this.frame.isClosed() || Boolean.TRUE.equals(this.frame.getClientProperty(ICONIFYING));
        if (!isAlive) {
            this.uninstall();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (Boolean.TRUE.equals(this.getClientProperty(UNINSTALLED))) {
            this.installTitlePane();
            this.putClientProperty(UNINSTALLED, null);
        }
    }

    private void updateOptionPaneState() {
        Object obj = this.frame.getClientProperty("JInternalFrame.messageType");
        if (obj == null) {
            return;
        }
        if (this.frame.isClosable()) {
            this.frame.setClosable(false);
        }
    }

    public AbstractButton getCloseButton() {
        return this.closeButton;
    }

    public class RadianceMenuBar
    extends JMenuBar {
        @Override
        public void paint(Graphics g) {
            Icon icon = RadianceInternalFrameTitlePane.this.frame.getFrameIcon();
            if (icon != null) {
                int width = this.getWidth();
                int height = this.getHeight();
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                if (iconWidth <= width && iconHeight <= height) {
                    icon.paintIcon(this, g, 0, 0);
                } else {
                    float scale = Math.min((float)width / (float)iconWidth, (float)height / (float)iconHeight);
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.scale(scale, scale);
                    icon.paintIcon(this, g2d, 0, 0);
                    g2d.dispose();
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            int iSize = RadianceSizeUtils.getTitlePaneIconSize();
            return new Dimension(Math.max(iSize, size.width), Math.max(size.height, iSize));
        }
    }

    public class RadianceIconifyAction
    extends BasicInternalFrameTitlePane.IconifyAction {
        public RadianceIconifyAction() {
            super(RadianceInternalFrameTitlePane.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RadianceInternalFrameTitlePane.this.frame.putClientProperty(RadianceInternalFrameTitlePane.ICONIFYING, Boolean.TRUE);
            super.actionPerformed(e);
            RadianceInternalFrameTitlePane.this.frame.putClientProperty(RadianceInternalFrameTitlePane.ICONIFYING, null);
        }
    }

    protected class RadianceTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        protected RadianceTitlePaneLayout() {
            super(RadianceInternalFrameTitlePane.this);
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int title_length;
            int width = 30;
            if (RadianceInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (RadianceInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (RadianceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (RadianceInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (RadianceInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (RadianceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = RadianceMetricsUtilities.getFontMetrics(RadianceCommonCortex.getScaleFactor((Component)c), RadianceInternalFrameTitlePane.this.getFont());
            String frameTitle = RadianceInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            if (title_length > 2) {
                int subtitle_w = fm.stringWidth(RadianceInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...");
                width += Math.min(title_w, subtitle_w);
            } else {
                width += title_w;
            }
            int height = 0;
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            Icon icon = RadianceInternalFrameTitlePane.this.frame.getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            height = Math.max(fontHeight, iconHeight += 5);
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container c) {
            int spacing;
            JRootPane rootPane = RadianceInternalFrameTitlePane.this.frame.getRootPane();
            boolean leftToRight = rootPane.getComponentOrientation().isLeftToRight();
            boolean controlButtonsOnRight = RadianceTitlePaneUtilities.areTitlePaneControlButtonsOnRight(rootPane);
            int w = RadianceInternalFrameTitlePane.this.getWidth();
            int buttonHeight = RadianceInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int buttonWidth = RadianceInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            int y = (RadianceInternalFrameTitlePane.this.getHeight() - buttonHeight) / 2;
            int x = leftToRight ? w : 0;
            RadianceThemingSlices.TitleIconHorizontalGravity iconGravity = RadianceTitlePaneUtilities.getTitlePaneIconGravity();
            RadianceThemingSlices.HorizontalGravity titleTextGravity = RadianceTitlePaneUtilities.getTitlePaneTextGravity();
            if (RadianceInternalFrameTitlePane.this.menuBar != null) {
                int menuBarLeft;
                spacing = 5;
                block0 : switch (iconGravity) {
                    case OPPOSITE_CONTROL_BUTTONS: {
                        menuBarLeft = controlButtonsOnRight ? spacing : w - buttonWidth - spacing;
                        break;
                    }
                    case NEXT_TO_TITLE: {
                        Rectangle titleRect = RadianceTitlePaneUtilities.getTitlePaneTextRectangle(RadianceInternalFrameTitlePane.this, RadianceInternalFrameTitlePane.this.frame);
                        String displayTitle = RadianceInternalFrameTitlePane.this.getDisplayTitle();
                        FontUIResource font = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
                        int displayTitleWidth = RadianceMetricsUtilities.getFontMetrics(RadianceCommonCortex.getScaleFactor((Component)c), font).stringWidth(displayTitle);
                        switch (titleTextGravity) {
                            case LEADING: {
                                menuBarLeft = leftToRight ? titleRect.x - buttonWidth - spacing : titleRect.x + titleRect.width + spacing;
                                break block0;
                            }
                            case TRAILING: {
                                menuBarLeft = leftToRight ? titleRect.x + titleRect.width - displayTitleWidth - buttonWidth - spacing : titleRect.x + titleRect.width + spacing;
                                break block0;
                            }
                        }
                        int displayTitleLeft = titleRect.x + (titleRect.width - displayTitleWidth) / 2;
                        menuBarLeft = leftToRight ? displayTitleLeft - buttonWidth - spacing : displayTitleLeft + displayTitleWidth + spacing;
                        break;
                    }
                    default: {
                        menuBarLeft = -1;
                    }
                }
                if (menuBarLeft >= 0) {
                    RadianceInternalFrameTitlePane.this.menuBar.setVisible(true);
                    RadianceInternalFrameTitlePane.this.menuBar.setBounds(menuBarLeft, y, buttonWidth, buttonHeight);
                } else {
                    RadianceInternalFrameTitlePane.this.menuBar.setVisible(false);
                }
            }
            x = controlButtonsOnRight ? w : 0;
            spacing = 3;
            RadianceInternalFrameTitlePane.this.closeButton.setVisible(RadianceInternalFrameTitlePane.this.frame.isClosable());
            if (RadianceInternalFrameTitlePane.this.frame.isClosable()) {
                RadianceInternalFrameTitlePane.this.closeButton.setBounds(x += controlButtonsOnRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!controlButtonsOnRight) {
                    x += buttonWidth;
                }
            }
            RadianceInternalFrameTitlePane.this.maxButton.setVisible(RadianceInternalFrameTitlePane.this.frame.isMaximizable());
            if (RadianceInternalFrameTitlePane.this.frame.isMaximizable()) {
                spacing = RadianceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4;
                RadianceInternalFrameTitlePane.this.maxButton.setBounds(x += controlButtonsOnRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!controlButtonsOnRight) {
                    x += buttonWidth;
                }
            }
            RadianceInternalFrameTitlePane.this.iconButton.setVisible(RadianceInternalFrameTitlePane.this.frame.isIconifiable());
            if (RadianceInternalFrameTitlePane.this.frame.isIconifiable()) {
                spacing = RadianceInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (RadianceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
                RadianceInternalFrameTitlePane.this.iconButton.setBounds(x += controlButtonsOnRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!controlButtonsOnRight) {
                    x += buttonWidth;
                }
            }
        }
    }

    public static class ClickListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton src = (AbstractButton)e.getSource();
            ButtonModel model = src.getModel();
            model.setArmed(false);
            model.setPressed(false);
            model.setRollover(false);
            model.setSelected(false);
        }
    }
}

