/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.font.FontPolicy;
import org.pushingpixels.radiance.common.api.font.FontSet;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;

public class RadianceSizeUtils {
    private static int controlFontSize = -1;

    public static int getControlFontSize() {
        if (controlFontSize > 0) {
            return controlFontSize;
        }
        FontPolicy fPolicy = RadianceThemingCortex.GlobalScope.getFontPolicy();
        FontSet fSet = fPolicy.getFontSet();
        controlFontSize = fSet.getControlFont().getSize();
        return controlFontSize;
    }

    public static void setControlFontSize(int size) {
        controlFontSize = size;
    }

    public static int getComponentFontSize(Component c) {
        return c == null || c.getFont() == null ? RadianceSizeUtils.getControlFontSize() : c.getFont().getSize();
    }

    public static float getAdjustedSize(int fontSize, float baseSize, int forEachBase, float toAdjustBy) {
        int delta = fontSize - 11;
        if (delta <= 0) {
            return baseSize;
        }
        float result = baseSize + (float)delta * toAdjustBy / (float)forEachBase;
        return result;
    }

    public static int getAdjustedSize(int fontSize, int baseSize, int forEachBase, int toAdjustBy, boolean toRoundAsEven) {
        int delta = fontSize - 11;
        if (delta <= 0) {
            return baseSize;
        }
        int result = baseSize + delta * toAdjustBy / forEachBase;
        if (toRoundAsEven && result % 2 != 0) {
            --result;
        }
        return result;
    }

    public static float getArrowIconHeight(int fontSize) {
        if (fontSize < 12) {
            return 0.5f + (float)fontSize * 0.5f;
        }
        return RadianceSizeUtils.getAdjustedSize(fontSize, 7.0f, 1, 0.4f);
    }

    public static float getArrowIconWidth(int fontSize) {
        int result = 2 * fontSize / 3;
        return result + 2;
    }

    public static float getArrowStrokeWidth(int fontSize) {
        return RadianceSizeUtils.getAdjustedSize(fontSize, 2.0f, 1, 0.06f);
    }

    public static float getBorderStrokeWidth(Component c) {
        return 1.0f / (float)RadianceCommonCortex.getScaleFactor((Component)c);
    }

    public static Insets getButtonInsets(Component c, int fontSize) {
        Insets textInsets = RadianceSizeUtils.getTextBorderInsets(fontSize);
        int borderStroke = (int)RadianceSizeUtils.getBorderStrokeWidth(c);
        int topDelta = textInsets.top - borderStroke;
        int bottomDelta = textInsets.bottom - borderStroke;
        int lrInset = RadianceSizeUtils.getAdjustedSize(fontSize, 4, 4, 1, false);
        return new Insets(topDelta, lrInset, bottomDelta, lrInset);
    }

    public static Border getCheckBoxBorder(int fontSize, boolean ltr) {
        int tInset = RadianceSizeUtils.getAdjustedSize(fontSize, 2, 3, 1, false);
        int bInset = RadianceSizeUtils.getAdjustedSize(fontSize, 3, 3, 1, false);
        if (fontSize == 11) {
            tInset = 2;
            bInset = 2;
        }
        int leadingInset = RadianceSizeUtils.getAdjustedSize(fontSize, 3, 3, 1, false);
        int trailingInset = RadianceSizeUtils.getAdjustedSize(fontSize, 5, 3, 1, false);
        return new BorderUIResource.EmptyBorderUIResource(tInset, ltr ? leadingInset : trailingInset, bInset, ltr ? trailingInset : leadingInset);
    }

    public static int getCheckBoxMarkSize(int fontSize) {
        return 2 + fontSize;
    }

    public static float getClassicButtonCornerRadius(int fontSize) {
        return RadianceSizeUtils.getAdjustedSize(fontSize, 3, 6, 1, false);
    }

    public static Insets getComboBorderInsets(int fontSize) {
        int tbInset = RadianceSizeUtils.getAdjustedSize(fontSize, 1, 3, 1, false);
        int lrInset = RadianceSizeUtils.getAdjustedSize(fontSize, 2, 3, 1, false);
        return new Insets(tbInset, lrInset, tbInset, lrInset);
    }

    public static Insets getComboLayoutInsets(int fontSize) {
        int tbInset = RadianceSizeUtils.getAdjustedSize(fontSize, 2, 4, 1, false);
        int lrInset = RadianceSizeUtils.getAdjustedSize(fontSize, 2, 4, 1, false);
        return new Insets(tbInset, lrInset, tbInset, lrInset);
    }

    public static Insets getComboTextBorderInsets(int fontSize) {
        Insets textInsets = RadianceSizeUtils.getTextBorderInsets(fontSize);
        Insets comboInsets = RadianceSizeUtils.getComboBorderInsets(fontSize);
        int topDelta = textInsets.top - comboInsets.top;
        int bottomDelta = textInsets.bottom - comboInsets.bottom;
        int lrInset = RadianceSizeUtils.getAdjustedSize(fontSize, 3, 4, 1, false);
        return new Insets(topDelta, lrInset, bottomDelta, lrInset);
    }

    public static Insets getDefaultBorderInsets(int fontSize) {
        int inset = RadianceSizeUtils.getAdjustedSize(fontSize, 2, 3, 1, false);
        return new Insets(inset, inset, inset, inset);
    }

    public static float getDoubleArrowStrokeWidth(int fontSize) {
        return RadianceSizeUtils.getAdjustedSize(fontSize, 1.5f, 1, 0.04f);
    }

    public static int getDragBumpDiameter(int fontSize) {
        return RadianceSizeUtils.getAdjustedSize(fontSize, 2, 4, 1, false);
    }

    public static int getBigDragBumpDiameter(int fontSize) {
        int result = RadianceSizeUtils.getAdjustedSize(fontSize, 3, 3, 1, false);
        if (result % 2 != 0) {
            ++result;
        }
        return result;
    }

    public static int getExtraPadding(int fontSize) {
        if (fontSize < 14) {
            return 0;
        }
        return (int)RadianceSizeUtils.getAdjustedSize(fontSize, 0.0f, 3, 1.2f);
    }

    public static float getFocusRingPadding(Component c, int fontSize) {
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
        if (fontSize < 14) {
            return 2.0f + borderStrokeWidth;
        }
        return 3.0f + RadianceSizeUtils.getAdjustedSize(fontSize, 0.0f, 3, 0.8f) + borderStrokeWidth;
    }

    public static float getFocusStrokeWidth(Component c) {
        return 1.0f / (float)RadianceCommonCortex.getScaleFactor((Component)c);
    }

    public static float getCloseIconStrokeWidth(int fontSize) {
        return Math.max(1.0f, (float)fontSize / 10.0f);
    }

    public static Insets getListCellRendererInsets(Component c, int fontSize) {
        Insets textInsets = RadianceSizeUtils.getTextBorderInsets(fontSize);
        Insets comboInsets = RadianceSizeUtils.getComboBorderInsets(fontSize);
        int borderStroke = (int)RadianceSizeUtils.getBorderStrokeWidth(c);
        int topDelta = textInsets.top - comboInsets.top - borderStroke;
        int bottomDelta = textInsets.bottom - comboInsets.bottom - borderStroke;
        int lrInset = RadianceSizeUtils.getAdjustedSize(fontSize, 4, 4, 1, false);
        return new Insets(topDelta, lrInset, bottomDelta, lrInset);
    }

    public static int getMenuCheckMarkSize(int fontSize) {
        int result = fontSize;
        if (result % 2 == 0) {
            --result;
        }
        return result;
    }

    public static int getMenuItemMargin(int fontSize) {
        return RadianceSizeUtils.getAdjustedSize(fontSize, 2, 4, 1, false);
    }

    public static int getTextIconGap(int fontSize) {
        return RadianceSizeUtils.getAdjustedSize(fontSize, 4, 3, 1, false);
    }

    public static int getMinButtonWidth(int fontSize) {
        return 5 * fontSize + 12;
    }

    public static int getPasswordDotDiameter(int fontSize) {
        return RadianceSizeUtils.getAdjustedSize(fontSize, 7, 2, 1, false);
    }

    public static int getPasswordDotGap(int fontSize) {
        return (fontSize - 6) / 3;
    }

    public static Border getRadioButtonBorder(int fontSize, boolean ltr) {
        Border checkBoxBorder = RadianceSizeUtils.getCheckBoxBorder(fontSize, ltr);
        Insets checkBoxInsets = checkBoxBorder.getBorderInsets(null);
        return new BorderUIResource.EmptyBorderUIResource(checkBoxInsets.top, checkBoxInsets.left - (ltr ? 0 : 2), checkBoxInsets.bottom, checkBoxInsets.right - (ltr ? 2 : 0));
    }

    public static int getRadioButtonMarkSize(int fontSize) {
        int result = fontSize;
        return result;
    }

    public static int getScrollBarWidth(int fontSize) {
        int result = (int)(RadianceSizeUtils.getArrowIconWidth(fontSize) * 3.0f / 2.0f) + 2;
        if (result % 2 == 1) {
            --result;
        }
        return result;
    }

    public static int getSliderIconSize(int fontSize) {
        int result = fontSize + 5;
        if (result % 2 != 0) {
            --result;
        }
        return result;
    }

    public static int getSliderTickSize(int fontSize) {
        return Math.max(7, fontSize - 3);
    }

    public static int getSliderTrackSize(int fontSize) {
        return RadianceSizeUtils.getAdjustedSize(fontSize, 5, 4, 1, false);
    }

    public static float getSmallArrowIconHeight(int fontSize) {
        return RadianceSizeUtils.getArrowIconHeight(fontSize) - 1.0f;
    }

    public static float getSmallDoubleArrowIconHeight(int fontSize) {
        float result = RadianceSizeUtils.getSmallArrowIconHeight(fontSize);
        return result += RadianceSizeUtils.getSmallDoubleArrowGap(fontSize);
    }

    public static float getSmallDoubleArrowGap(int fontSize) {
        return 3 + 2 * RadianceSizeUtils.getExtraPadding(fontSize) / 3;
    }

    public static float getSmallArrowIconWidth(int fontSize) {
        return RadianceSizeUtils.getArrowIconWidth(fontSize) - 2.0f;
    }

    public static float getSpinnerArrowIconHeight(int fontSize) {
        float result = RadianceSizeUtils.getArrowIconHeight(fontSize) + RadianceSizeUtils.getAdjustedSize(fontSize + 1, 0.0f, 1, -0.25f);
        return result;
    }

    public static float getSpinnerArrowIconWidth(int fontSize) {
        int result = (int)(RadianceSizeUtils.getArrowIconWidth(fontSize) + RadianceSizeUtils.getAdjustedSize(fontSize, 1.0f, 1, -0.15f));
        if (result % 2 == 0) {
            --result;
        }
        return result;
    }

    public static Insets getSpinnerBorderInsets(int fontSize) {
        Insets comboInsets = RadianceSizeUtils.getComboBorderInsets(fontSize);
        return new Insets(comboInsets.top + 1, comboInsets.left, comboInsets.bottom + 1, comboInsets.right);
    }

    public static Insets getSpinnerArrowButtonInsets(Component c) {
        int borderStrokeWidth = (int)Math.floor(RadianceSizeUtils.getBorderStrokeWidth(c));
        return new Insets(borderStrokeWidth, borderStrokeWidth, borderStrokeWidth, borderStrokeWidth);
    }

    public static Insets getSpinnerTextBorderInsets(int fontSize) {
        Insets textInsets = RadianceSizeUtils.getComboTextBorderInsets(fontSize);
        return new Insets(textInsets.top - 1, textInsets.left, textInsets.bottom - 1, textInsets.right);
    }

    public static float getSplitPaneArrowIconHeight(int fontSize) {
        float result = RadianceSizeUtils.getArrowIconHeight(fontSize) + RadianceSizeUtils.getAdjustedSize(fontSize, -2.0f, 1, -0.3f);
        return result;
    }

    public static float getSplitPaneArrowIconWidth(int fontSize) {
        float result = RadianceSizeUtils.getArrowIconWidth(fontSize) + RadianceSizeUtils.getAdjustedSize(fontSize, -2.0f, 1, -0.25f);
        return result;
    }

    public static int getSplitPaneButtonOffset(int fontSize) {
        return RadianceSizeUtils.getAdjustedSize(fontSize, 2, 3, 1, false);
    }

    public static Insets getTabbedPaneContentInsets(Component c) {
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
        int inset = (int)Math.ceil(borderStrokeWidth + 0.5f);
        return new Insets(inset, inset, inset, inset);
    }

    public static float getTabCloseButtonStrokeWidth(Component c) {
        return RadianceSizeUtils.getBorderStrokeWidth(c);
    }

    public static int getTabCloseIconSize(int fontSize) {
        return fontSize - 2;
    }

    public static Insets getTableCellRendererInsets(int fontSize) {
        Insets textInsets = RadianceSizeUtils.getTextBorderInsets(fontSize);
        Insets comboInsets = RadianceSizeUtils.getComboBorderInsets(fontSize);
        int topDelta = textInsets.top - comboInsets.top - 1;
        int bottomDelta = textInsets.bottom - comboInsets.bottom - 2;
        if (fontSize == 11) {
            ++bottomDelta;
        }
        int lrInset = RadianceSizeUtils.getAdjustedSize(fontSize, 2, 4, 1, false);
        return new Insets(topDelta, lrInset, bottomDelta, lrInset);
    }

    public static Insets getTextBorderInsets(int fontSize) {
        int tInset = RadianceSizeUtils.getAdjustedSize(fontSize, 3, 3, 1, false);
        int bInset = RadianceSizeUtils.getAdjustedSize(fontSize, 4, 3, 1, false);
        if (fontSize == 11) {
            tInset = 3;
            bInset = 3;
        }
        int lrInset = RadianceSizeUtils.getAdjustedSize(fontSize, 5, 3, 1, false);
        return new Insets(tInset, lrInset, bInset, lrInset);
    }

    public static int getTextButtonLRPadding(int fontSize) {
        return RadianceSizeUtils.getAdjustedSize(fontSize, 3, 2, 1, false);
    }

    public static int getTitlePaneIconSize() {
        return 5 + RadianceSizeUtils.getControlFontSize();
    }

    public static int getToolBarDragInset(int fontSize) {
        return fontSize + 5;
    }

    public static Insets getToolBarInsets(int fontSize) {
        int lbrInset = RadianceSizeUtils.getAdjustedSize(fontSize, 2, 3, 1, false);
        int tInset = RadianceSizeUtils.getAdjustedSize(fontSize, 1, 3, 1, false);
        return new Insets(tInset, lbrInset, lbrInset, lbrInset);
    }

    public static Insets getToolTipBorderInsets(int fontSize) {
        int inset = RadianceSizeUtils.getAdjustedSize(fontSize, 1, 3, 1, false);
        return new Insets(inset, inset, inset, inset);
    }

    public static Insets getTreeCellRendererInsets(Component c, int fontSize) {
        Insets listCellInsets = RadianceSizeUtils.getListCellRendererInsets(c, fontSize);
        return new Insets(listCellInsets.top - 1, listCellInsets.left - 2, listCellInsets.bottom - 1, listCellInsets.right - 2);
    }

    public static int getTreeIconSize(int fontSize) {
        int extraPadding = RadianceSizeUtils.getExtraPadding(fontSize);
        int extraPadding2 = 2 * extraPadding;
        return 10 + extraPadding2;
    }

    public static int getTreeLeftIndent(int fontSize) {
        int extraPadding = RadianceSizeUtils.getExtraPadding(fontSize);
        return 8 + extraPadding;
    }

    public static int getTreeRightIndent(int fontSize) {
        int extraPadding = RadianceSizeUtils.getExtraPadding(fontSize);
        return 12 + extraPadding;
    }

    public static int getLookupButtonSize() {
        return 4 + RadianceSizeUtils.getControlFontSize();
    }

    public static int getTitlePaneHorizontalPadding(int fontSize) {
        return (int)RadianceSizeUtils.getAdjustedSize(fontSize, 5.0f, 2, 1.0f);
    }
}

