/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.EnumSet;
import javax.swing.JButton;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.shaper.ClassicButtonShaper;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalArrowButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceButtonBorder;

@RadianceInternalButton
@RadianceInternalArrowButton
public class RadianceSpinnerButton
extends JButton {
    public RadianceSpinnerButton(JSpinner spinner, final int orientation) {
        this.setEnabled(spinner.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        super.setBorder(new SpinnerButtonBorder(ClassicButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component c) {
                int extraPadding = RadianceSizeUtils.getExtraPadding(RadianceSizeUtils.getComponentFontSize(c));
                int delta = RadianceSizeUtils.getAdjustedSize(RadianceSizeUtils.getComponentFontSize(c), 3, 3, 1, false);
                int deltaTop = orientation == 1 ? delta : 0;
                int deltaBottom = orientation == 1 ? 0 : delta;
                return new Insets(extraPadding + deltaTop, extraPadding, extraPadding + deltaBottom, extraPadding);
            }
        });
        RadianceCoreUtilities.markButtonAsFlat(this);
        RadianceThemingCortex.ComponentScope.setButtonStraightSides(this, EnumSet.allOf(RadianceThemingSlices.Side.class));
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        int width = this.getWidth();
        int height = this.getHeight();
        int clipDelta = (int)RadianceSizeUtils.getBorderStrokeWidth(this);
        if (this.getComponentOrientation().isLeftToRight()) {
            g2d.clipRect(clipDelta, 0, width - clipDelta, height);
        } else {
            g2d.clipRect(0, 0, width - clipDelta, height);
        }
        super.paint(g2d);
        g2d.dispose();
    }

    static {
        AnimationConfigurationManager.getInstance().disallowAnimations(RadianceThemingSlices.AnimationFacet.GHOSTING_BUTTON_PRESS, RadianceSpinnerButton.class);
        AnimationConfigurationManager.getInstance().disallowAnimations(RadianceThemingSlices.AnimationFacet.GHOSTING_ICON_ROLLOVER, RadianceSpinnerButton.class);
    }

    private static abstract class SpinnerButtonBorder
    extends RadianceButtonBorder {
        public SpinnerButtonBorder(Class<?> buttonShaperClass) {
            super(buttonShaperClass);
        }
    }
}

