/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeTransitionAwareIcon;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceSplitPaneUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RolloverControlListener;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceSplitPaneDivider
extends BasicSplitPaneDivider
implements TransitionAwareUI {
    private RolloverControlListener radianceRolloverListener;
    protected StateTransitionTracker stateTransitionTracker;
    private PropertyChangeListener radiancePropertyChangeListener;
    private ButtonModel gripModel;

    public RadianceSplitPaneDivider(RadianceSplitPaneUI ui) {
        super(ui);
        this.setLayout(new RadianceDividerLayout());
    }

    @Override
    public void setBasicSplitPaneUI(BasicSplitPaneUI newUI) {
        if (this.splitPane != null) {
            this.uninstall();
        }
        if (newUI != null) {
            this.splitPane = newUI.getSplitPane();
            this.gripModel = new DefaultButtonModel();
            this.gripModel.setArmed(false);
            this.gripModel.setSelected(false);
            this.gripModel.setPressed(false);
            this.gripModel.setRollover(false);
            this.gripModel.setEnabled(this.splitPane.isEnabled());
            this.stateTransitionTracker = new StateTransitionTracker((JComponent)this.splitPane, this.gripModel);
            this.radianceRolloverListener = new RolloverControlListener(this, this.gripModel);
            this.addMouseListener(this.radianceRolloverListener);
            this.addMouseMotionListener(this.radianceRolloverListener);
            this.radiancePropertyChangeListener = propertyChangeEvent -> {
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    boolean isEnabled = this.splitPane.isEnabled();
                    this.gripModel.setEnabled(isEnabled);
                    if (this.leftButton != null) {
                        this.leftButton.setEnabled(isEnabled);
                    }
                    if (this.rightButton != null) {
                        this.rightButton.setEnabled(isEnabled);
                    }
                    this.setEnabled(isEnabled);
                }
            };
            this.splitPane.addPropertyChangeListener(this.radiancePropertyChangeListener);
            this.stateTransitionTracker.registerModelListeners();
        } else {
            this.uninstall();
        }
        super.setBasicSplitPaneUI(newUI);
    }

    private void uninstall() {
        this.removeMouseListener(this.radianceRolloverListener);
        this.removeMouseMotionListener(this.radianceRolloverListener);
        this.radianceRolloverListener = null;
        if (this.radiancePropertyChangeListener != null) {
            this.splitPane.removePropertyChangeListener(this.radiancePropertyChangeListener);
            this.radiancePropertyChangeListener = null;
        }
        this.stateTransitionTracker.unregisterModelListeners();
    }

    @Override
    public void paint(Graphics g) {
        if (RadianceCoreUtilities.hasFlatAppearance(this.splitPane, true)) {
            BackgroundPaintingUtils.updateIfOpaque(g, this.splitPane);
        }
        Graphics2D graphics = (Graphics2D)g.create();
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        float alpha = RadianceColorSchemeUtilities.getAlpha(this.splitPane, currState);
        int minSizeForGripPresence = RadianceSizeUtils.getAdjustedSize(RadianceSizeUtils.getComponentFontSize(this), 30, 1, 2, false);
        int maxGripSize = RadianceSizeUtils.getAdjustedSize(RadianceSizeUtils.getComponentFontSize(this), 40, 1, 3, false);
        if (this.splitPane.getOrientation() == 1) {
            int thumbHeight = this.getHeight();
            if (thumbHeight >= minSizeForGripPresence) {
                int gripHeight = thumbHeight / 4;
                if (gripHeight > maxGripSize) {
                    gripHeight = maxGripSize;
                }
                int thumbWidth = this.getWidth();
                int gripX = 0;
                int gripY = (thumbHeight - gripHeight) / 2;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    float contribution = activeEntry.getValue().getContribution();
                    if (contribution == 0.0f) continue;
                    ComponentState activeState = activeEntry.getKey();
                    graphics.setComposite(WidgetUtilities.getAlphaComposite(this.splitPane, alpha * contribution, g));
                    RadianceImageCreator.paintSplitDividerBumpImage(graphics, this, gripX, gripY, thumbWidth, gripHeight, false, RadianceColorSchemeUtilities.getColorScheme(this, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, activeState));
                }
            }
        } else {
            int thumbWidth = this.getWidth();
            if (thumbWidth >= minSizeForGripPresence) {
                int gripWidth = thumbWidth / 4;
                if (gripWidth > maxGripSize) {
                    gripWidth = maxGripSize;
                }
                int thumbHeight = this.getHeight();
                int gripX = (thumbWidth - gripWidth) / 2;
                int gripY = 1;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    float contribution = activeEntry.getValue().getContribution();
                    if (contribution == 0.0f) continue;
                    ComponentState activeState = activeEntry.getKey();
                    graphics.setComposite(WidgetUtilities.getAlphaComposite(this.splitPane, alpha * contribution, g));
                    RadianceImageCreator.paintSplitDividerBumpImage(graphics, this, gripX, gripY, gripWidth, thumbHeight, true, RadianceColorSchemeUtilities.getColorScheme(this, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, activeState));
                }
            }
        }
        graphics.dispose();
        super.paint(g);
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        RadianceSplitPaneDividerButton oneTouchButton = new RadianceSplitPaneDividerButton();
        final int fontSize = RadianceSizeUtils.getComponentFontSize(oneTouchButton);
        final float iconWidth = RadianceSizeUtils.getSplitPaneArrowIconWidth(fontSize);
        final float iconHeight = RadianceSizeUtils.getSplitPaneArrowIconHeight(fontSize);
        BladeTransitionAwareIcon verticalSplit = new BladeTransitionAwareIcon(oneTouchButton, new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                BladeArrowIconUtils.drawArrow(g, iconWidth, iconHeight, RadianceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 1, scheme, alpha);
            }

            @Override
            public Dimension getIconDimension() {
                return new Dimension((int)Math.ceil(iconWidth), (int)Math.ceil(iconHeight));
            }
        });
        BladeTransitionAwareIcon horizontalSplit = new BladeTransitionAwareIcon(oneTouchButton, new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                BladeArrowIconUtils.drawArrow(g, iconWidth, iconHeight, RadianceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 7, scheme, alpha);
            }

            @Override
            public Dimension getIconDimension() {
                return new Dimension((int)Math.ceil(iconWidth), (int)Math.ceil(iconHeight));
            }
        });
        oneTouchButton.setIcon(this.splitPane.getOrientation() == 0 ? verticalSplit : horizontalSplit);
        RadianceThemingCortex.ComponentOrParentScope.setBackgroundAppearanceStrategy(oneTouchButton, RadianceThemingSlices.BackgroundAppearanceStrategy.NEVER);
        oneTouchButton.setRequestFocusEnabled(false);
        oneTouchButton.setCursor(Cursor.getPredefinedCursor(12));
        oneTouchButton.setFocusPainted(false);
        oneTouchButton.setBorderPainted(false);
        return oneTouchButton;
    }

    @Override
    protected JButton createRightOneTouchButton() {
        RadianceSplitPaneDividerButton oneTouchButton = new RadianceSplitPaneDividerButton();
        final int fontSize = RadianceSizeUtils.getComponentFontSize(oneTouchButton);
        final float iconWidth = RadianceSizeUtils.getSplitPaneArrowIconWidth(fontSize);
        final float iconHeight = RadianceSizeUtils.getSplitPaneArrowIconHeight(fontSize);
        BladeTransitionAwareIcon verticalSplit = new BladeTransitionAwareIcon(oneTouchButton, new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                BladeArrowIconUtils.drawArrow(g, iconWidth, iconHeight, RadianceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 5, scheme, alpha);
            }

            @Override
            public Dimension getIconDimension() {
                return new Dimension((int)Math.ceil(iconWidth), (int)Math.ceil(iconHeight));
            }
        });
        BladeTransitionAwareIcon horizontalSplit = new BladeTransitionAwareIcon(oneTouchButton, new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                BladeArrowIconUtils.drawArrow(g, iconWidth, iconHeight, RadianceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 3, scheme, alpha);
            }

            @Override
            public Dimension getIconDimension() {
                return new Dimension((int)Math.ceil(iconWidth), (int)Math.ceil(iconHeight));
            }
        });
        oneTouchButton.setIcon(this.splitPane.getOrientation() == 0 ? verticalSplit : horizontalSplit);
        RadianceThemingCortex.ComponentOrParentScope.setBackgroundAppearanceStrategy(oneTouchButton, RadianceThemingSlices.BackgroundAppearanceStrategy.NEVER);
        oneTouchButton.setCursor(Cursor.getPredefinedCursor(12));
        oneTouchButton.setFocusPainted(false);
        oneTouchButton.setBorderPainted(false);
        oneTouchButton.setRequestFocusEnabled(false);
        return oneTouchButton;
    }

    public void updateOneTouchButtons(int orientation) {
        if (orientation == 0) {
            float iconHeight;
            float iconWidth;
            int fontSize;
            if (this.leftButton != null) {
                fontSize = RadianceSizeUtils.getComponentFontSize(this.leftButton);
                iconWidth = RadianceSizeUtils.getSplitPaneArrowIconWidth(fontSize);
                iconHeight = RadianceSizeUtils.getSplitPaneArrowIconHeight(fontSize);
                this.leftButton.setIcon(new BladeTransitionAwareIcon(this.leftButton, new BladeTransitionAwareIcon.Delegate(){

                    @Override
                    public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                        BladeArrowIconUtils.drawArrow(g, iconWidth, iconHeight, RadianceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 1, scheme, alpha);
                    }

                    @Override
                    public Dimension getIconDimension() {
                        return new Dimension((int)Math.ceil(iconWidth), (int)Math.ceil(iconHeight));
                    }
                }));
            }
            if (this.rightButton != null) {
                fontSize = RadianceSizeUtils.getComponentFontSize(this.rightButton);
                iconWidth = RadianceSizeUtils.getSplitPaneArrowIconWidth(fontSize);
                iconHeight = RadianceSizeUtils.getSplitPaneArrowIconHeight(fontSize);
                this.rightButton.setIcon(new BladeTransitionAwareIcon(this.rightButton, new BladeTransitionAwareIcon.Delegate(){

                    @Override
                    public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                        BladeArrowIconUtils.drawArrow(g, iconWidth, iconHeight, RadianceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 5, scheme, alpha);
                    }

                    @Override
                    public Dimension getIconDimension() {
                        return new Dimension((int)Math.ceil(iconWidth), (int)Math.ceil(iconHeight));
                    }
                }));
            }
        } else {
            float iconHeight;
            float iconWidth;
            int fontSize;
            if (this.leftButton != null) {
                fontSize = RadianceSizeUtils.getComponentFontSize(this.leftButton);
                iconWidth = RadianceSizeUtils.getSplitPaneArrowIconWidth(fontSize);
                iconHeight = RadianceSizeUtils.getSplitPaneArrowIconHeight(fontSize);
                this.leftButton.setIcon(new BladeTransitionAwareIcon(this.leftButton, new BladeTransitionAwareIcon.Delegate(){

                    @Override
                    public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                        BladeArrowIconUtils.drawArrow(g, iconWidth, iconHeight, RadianceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 7, scheme, alpha);
                    }

                    @Override
                    public Dimension getIconDimension() {
                        return new Dimension((int)Math.ceil(iconWidth), (int)Math.ceil(iconHeight));
                    }
                }));
            }
            if (this.rightButton != null) {
                fontSize = RadianceSizeUtils.getComponentFontSize(this.rightButton);
                iconWidth = RadianceSizeUtils.getSplitPaneArrowIconWidth(fontSize);
                iconHeight = RadianceSizeUtils.getSplitPaneArrowIconHeight(fontSize);
                this.rightButton.setIcon(new BladeTransitionAwareIcon(this.rightButton, new BladeTransitionAwareIcon.Delegate(){

                    @Override
                    public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                        BladeArrowIconUtils.drawArrow(g, iconWidth, iconHeight, RadianceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 3, scheme, alpha);
                    }

                    @Override
                    public Dimension getIconDimension() {
                        return new Dimension((int)Math.ceil(iconWidth), (int)Math.ceil(iconHeight));
                    }
                }));
            }
        }
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    protected class RadianceDividerLayout
    extends BasicSplitPaneDivider.DividerLayout {
        protected RadianceDividerLayout() {
            super(RadianceSplitPaneDivider.this);
        }

        @Override
        public void layoutContainer(Container c) {
            if (RadianceSplitPaneDivider.this.leftButton != null && RadianceSplitPaneDivider.this.rightButton != null && c == RadianceSplitPaneDivider.this) {
                if (RadianceSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = RadianceSplitPaneDivider.this.getInsets();
                    int buttonWidth = ((RadianceSplitPaneDivider)RadianceSplitPaneDivider.this).leftButton.getPreferredSize().width;
                    int buttonHeight = ((RadianceSplitPaneDivider)RadianceSplitPaneDivider.this).leftButton.getPreferredSize().height;
                    int offset = RadianceSizeUtils.getSplitPaneButtonOffset(RadianceSizeUtils.getComponentFontSize(RadianceSplitPaneDivider.this.splitPane));
                    if (RadianceSplitPaneDivider.this.orientation == 0) {
                        int extraX = insets != null ? insets.left : 0;
                        int y = (c.getSize().height - buttonHeight) / 2;
                        RadianceSplitPaneDivider.this.leftButton.setBounds(extraX + offset, y, buttonWidth, buttonHeight);
                        RadianceSplitPaneDivider.this.rightButton.setBounds(RadianceSplitPaneDivider.this.leftButton.getX() + RadianceSplitPaneDivider.this.leftButton.getWidth(), y, buttonWidth, buttonHeight);
                    } else {
                        int extraY = insets != null ? insets.top : 0;
                        int x = (c.getSize().width - buttonWidth) / 2;
                        RadianceSplitPaneDivider.this.leftButton.setBounds(x, extraY + offset, buttonWidth, buttonHeight);
                        RadianceSplitPaneDivider.this.rightButton.setBounds(x, RadianceSplitPaneDivider.this.leftButton.getY() + RadianceSplitPaneDivider.this.leftButton.getHeight(), buttonWidth, buttonHeight);
                    }
                } else {
                    RadianceSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    RadianceSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }
    }

    private static class RadianceSplitPaneDividerButton
    extends JButton {
        private RadianceSplitPaneDividerButton() {
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public Insets getInsets(Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            insets.set(0, 0, 0, 0);
            return insets;
        }

        @Override
        public Dimension getPreferredSize() {
            Insets bInsets = RadianceSizeUtils.getButtonInsets(this, RadianceSizeUtils.getComponentFontSize(this));
            int iconWidth = this.getIcon().getIconWidth();
            int iconHeight = this.getIcon().getIconHeight();
            return new Dimension(iconWidth + bInsets.left + bInsets.right, iconHeight + bInsets.top + bInsets.bottom);
        }
    }
}

