/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceTextComponentBorder;

public class RadianceTextUtilities {
    public static void paintTextWithDropShadow(JComponent c, Graphics g, Color foregroundColor, Color echoColor, String text, int width, int height, int xOffset, int yOffset) {
        Graphics2D graphics = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)graphics, (Font)c.getFont());
        BufferedImage blurred = RadianceCoreUtilities.getBlankImage(RadianceCommonCortex.getScaleFactor((Component)c), width, height);
        Graphics2D gBlurred = (Graphics2D)blurred.getGraphics();
        gBlurred.setFont(graphics.getFont());
        gBlurred.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        float luminFactor = RadianceColorUtilities.getColorStrength(foregroundColor);
        gBlurred.setColor(echoColor);
        ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.04f, 0.06f, 0.04f, 0.06f, 0.04f, 0.06f, 0.04f, 0.06f, 0.04f}), 1, null);
        gBlurred.drawString(text, xOffset, yOffset);
        blurred = convolve.filter(blurred, null);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(c, luminFactor, g));
        double scaleFactor = RadianceCommonCortex.getScaleFactor((Component)c);
        graphics.drawImage(blurred, 0, 0, (int)((double)blurred.getWidth() / scaleFactor), (int)((double)blurred.getHeight() / scaleFactor), null);
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c, g));
        FontMetrics fm = graphics.getFontMetrics();
        RadianceTextUtilities.paintText((Graphics)graphics, new Rectangle(xOffset, yOffset - fm.getAscent(), width - xOffset, fm.getHeight()), text, -1, graphics.getFont(), foregroundColor, graphics.getClipBounds());
        graphics.dispose();
    }

    private static void paintText(Graphics g, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip, AffineTransform transform) {
        if (text == null || text.length() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(font);
        g2d.setColor(color);
        int dx = textRect.x;
        int dy = textRect.y + g2d.getFontMetrics().getAscent();
        if (clip != null) {
            g2d.clip(clip);
        }
        if (transform != null) {
            g2d.transform(transform);
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, text, mnemonicIndex, dx, dy);
        g2d.dispose();
    }

    public static void paintText(Graphics g, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip) {
        RadianceTextUtilities.paintText(g, textRect, text, mnemonicIndex, font, color, clip, null);
    }

    public static void paintVerticalText(Graphics g, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip, boolean isFromBottomToTop) {
        AffineTransform at;
        if (text == null || text.length() == 0) {
            return;
        }
        if (!isFromBottomToTop) {
            at = AffineTransform.getTranslateInstance(textRect.x + textRect.width, textRect.y);
            at.rotate(1.5707963267948966);
        } else {
            at = AffineTransform.getTranslateInstance(textRect.x, textRect.y + textRect.height);
            at.rotate(-1.5707963267948966);
        }
        Rectangle newRect = new Rectangle(0, 0, textRect.width, textRect.height);
        RadianceTextUtilities.paintText(g, newRect, text, mnemonicIndex, font, color, clip, at);
    }

    public static Color paintText(Graphics g, AbstractButton button, Rectangle textRect, String text, int mnemonicIndex) {
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        if (button instanceof JMenuItem) {
            float menuItemAlpha = RadianceColorSchemeUtilities.getAlpha(button, ComponentState.getState(button.getModel(), button, true));
            return RadianceTextUtilities.paintMenuItemText(g, (JMenuItem)button, textRect, text, mnemonicIndex, stateTransitionTracker.getModelStateInfo(), menuItemAlpha);
        }
        float buttonAlpha = RadianceColorSchemeUtilities.getAlpha(button, ComponentState.getState(button));
        return RadianceTextUtilities.paintText(g, (JComponent)button, textRect, text, mnemonicIndex, stateTransitionTracker.getModelStateInfo(), buttonAlpha);
    }

    public static Color paintText(Graphics g, JComponent component, Rectangle textRect, String text, int mnemonicIndex, ComponentState state, float textAlpha) {
        Color fgColor = RadianceTextUtilities.getForegroundColor(component, state, textAlpha);
        RadianceTextUtilities.paintText(g, textRect, text, mnemonicIndex, component.getFont(), fgColor, null);
        return fgColor;
    }

    public static Color paintText(Graphics g, JComponent component, Rectangle textRect, String text, int mnemonicIndex, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        Color fgColor = RadianceTextUtilities.getForegroundColor(component, text, modelStateInfo, textAlpha);
        RadianceTextUtilities.paintText(g, textRect, text, mnemonicIndex, component.getFont(), fgColor, null);
        return fgColor;
    }

    public static Color paintMenuItemText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text, int mnemonicIndex, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        Color fgColor = RadianceTextUtilities.getMenuComponentForegroundColor(menuItem, text, modelStateInfo, textAlpha);
        RadianceTextUtilities.paintText(g, textRect, text, mnemonicIndex, menuItem.getFont(), fgColor, null);
        return fgColor;
    }

    public static Color getForegroundColor(JComponent component, ComponentState state, float textAlpha) {
        Color fgColor;
        boolean toEnforceFgColor = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null;
        Color color = fgColor = toEnforceFgColor ? component.getForeground() : RadianceColorSchemeUtilities.getColorScheme(component, state).getForegroundColor();
        if (textAlpha < 1.0f) {
            Color bgFillColor = RadianceColorUtilities.getBackgroundFillColor(component);
            fgColor = RadianceColorUtilities.getInterpolatedColor(fgColor, bgFillColor, textAlpha);
        }
        return fgColor;
    }

    public static Color getForegroundColor(JComponent component, String text, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        Color fgColor;
        boolean toEnforceFgColor = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null;
        Color color = fgColor = toEnforceFgColor ? component.getForeground() : RadianceColorUtilities.getForegroundColor(component, modelStateInfo);
        if (textAlpha < 1.0f) {
            Color bgFillColor = RadianceColorUtilities.getBackgroundFillColor(component);
            fgColor = RadianceColorUtilities.getInterpolatedColor(fgColor, bgFillColor, textAlpha);
        }
        return fgColor;
    }

    public static Color getMenuComponentForegroundColor(JMenuItem menuComponent, String text, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        if (text == null || text.length() == 0) {
            return null;
        }
        Color fgColor = RadianceColorUtilities.getMenuComponentForegroundColor(menuComponent, modelStateInfo);
        if (textAlpha < 1.0f) {
            Color bgFillColor = RadianceColorUtilities.getBackgroundFillColor(menuComponent);
            fgColor = RadianceColorUtilities.getInterpolatedColor(fgColor, bgFillColor, textAlpha);
        }
        return fgColor;
    }

    public static Color getTextBackgroundFillColor(JComponent comp) {
        TextUI ui;
        Color backgroundFillColor = RadianceColorUtilities.getBackgroundFillColor(comp);
        JTextComponent componentForTransitions = RadianceCoreUtilities.getTextComponentForTransitions(comp);
        if (componentForTransitions != null && (ui = componentForTransitions.getUI()) instanceof TransitionAwareUI) {
            TransitionAwareUI trackable = (TransitionAwareUI)((Object)ui);
            StateTransitionTracker stateTransitionTracker = trackable.getTransitionTracker();
            float lightnessFactor = RadianceColorSchemeUtilities.getColorScheme(componentForTransitions, componentForTransitions.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED).isDark() ? 0.1f : 0.4f;
            Color lighterFill = RadianceColorUtilities.getLighterColor(backgroundFillColor, lightnessFactor);
            lighterFill = RadianceColorUtilities.getInterpolatedColor(lighterFill, backgroundFillColor, 0.6);
            float selectionStrength = stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.SELECTION);
            float rolloverStrength = stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.ROLLOVER);
            backgroundFillColor = RadianceColorUtilities.getInterpolatedColor(lighterFill, backgroundFillColor, Math.max(selectionStrength, rolloverStrength) / 4.0f);
        }
        return backgroundFillColor;
    }

    public static Color getTextSelectionBackground(JTextComponent comp) {
        TransitionAwareUI ui = (TransitionAwareUI)((Object)comp.getUI());
        StateTransitionTracker stateTransitionTracker = ui.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState state = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        if (state == ComponentState.ENABLED) {
            state = ComponentState.SELECTED;
        }
        Color result = RadianceCoreUtilities.getTextSelectionBackground(comp, state);
        if (!state.isDisabled() && activeStates != null && activeStates.size() > 1) {
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float alpha;
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == state) continue;
                if (activeState == ComponentState.ENABLED) {
                    activeState = ComponentState.SELECTED;
                }
                if ((contribution = activeEntry.getValue().getContribution()) == 0.0f || (alpha = RadianceColorSchemeUtilities.getAlpha(comp, activeState)) == 0.0f) continue;
                Color active = RadianceCoreUtilities.getTextSelectionBackground(comp, activeState);
                result = RadianceColorUtilities.getInterpolatedColor(result, active, 1.0f - contribution * alpha);
            }
        }
        return result;
    }

    public static Color getTextSelectionForeground(JTextComponent comp) {
        TransitionAwareUI ui = (TransitionAwareUI)((Object)comp.getUI());
        StateTransitionTracker stateTransitionTracker = ui.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState state = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        if (state == ComponentState.ENABLED) {
            state = ComponentState.SELECTED;
        }
        Color result = RadianceCoreUtilities.getTextSelectionForeground(comp, state);
        if (!state.isDisabled() && activeStates != null && activeStates.size() > 1) {
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float alpha;
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == state) continue;
                if (activeState == ComponentState.ENABLED) {
                    activeState = ComponentState.SELECTED;
                }
                if ((contribution = activeEntry.getValue().getContribution()) == 0.0f || (alpha = RadianceColorSchemeUtilities.getAlpha(comp, activeState)) == 0.0f) continue;
                Color active = RadianceCoreUtilities.getTextSelectionForeground(comp, activeState);
                result = RadianceColorUtilities.getInterpolatedColor(result, active, 1.0f - contribution * alpha);
            }
        }
        return result;
    }

    public static void paintTextCompBackground(Graphics g, JComponent comp) {
        TextUI ui;
        Graphics2D g2d = (Graphics2D)g.create();
        BackgroundPaintingUtils.update(g2d, comp, false);
        Color backgroundFillColor = RadianceTextUtilities.getTextBackgroundFillColor(comp);
        g2d.setColor(backgroundFillColor);
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(comp);
        g2d.fill(new Rectangle2D.Float(borderStrokeWidth / 2.0f, borderStrokeWidth / 2.0f, (float)comp.getWidth() - borderStrokeWidth, (float)comp.getHeight() - borderStrokeWidth));
        ComponentState state = comp.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = null;
        JTextComponent componentForTransitions = RadianceCoreUtilities.getTextComponentForTransitions(comp);
        if (componentForTransitions != null && (ui = componentForTransitions.getUI()) instanceof TransitionAwareUI) {
            TransitionAwareUI trackable = (TransitionAwareUI)((Object)ui);
            StateTransitionTracker stateTransitionTracker = trackable.getTransitionTracker();
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            state = modelStateInfo.getCurrModelState();
            activeStates = modelStateInfo.getStateContributionMap();
        }
        if (componentForTransitions != null && !componentForTransitions.isEditable()) {
            return;
        }
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(comp);
        RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(comp, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, state);
        Color borderColor = borderPainter.getRepresentativeColor(baseBorderScheme);
        if (!state.isDisabled() && activeStates != null && activeStates.size() > 1) {
            for (Map.Entry entry : activeStates.entrySet()) {
                float alpha;
                float contribution;
                ComponentState activeState = (ComponentState)entry.getKey();
                if (activeState == state || (contribution = ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution()) == 0.0f || (alpha = RadianceColorSchemeUtilities.getAlpha(componentForTransitions, activeState)) == 0.0f) continue;
                RadianceColorScheme activeBorderScheme = RadianceColorSchemeUtilities.getColorScheme(componentForTransitions, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, activeState);
                Color activeBorderColor = borderPainter.getRepresentativeColor(activeBorderScheme);
                borderColor = RadianceColorUtilities.getInterpolatedColor(borderColor, activeBorderColor, 1.0f - contribution * alpha);
            }
        }
        if (RadianceTextUtilities.hasRadianceTextBorder(comp)) {
            int shadowHeight = 6;
            int n = state.isDisabled() ? 16 : 32;
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, RadianceColorUtilities.getAlphaColor(borderColor, n), 0.0f, shadowHeight, RadianceColorUtilities.getAlphaColor(borderColor, 0)));
            float yTop = RadianceSizeUtils.getBorderStrokeWidth(comp);
            g2d.fill(new Rectangle2D.Float(borderStrokeWidth, yTop, (float)comp.getWidth() - 2.0f * borderStrokeWidth, shadowHeight));
        }
        g2d.dispose();
    }

    private static boolean hasRadianceTextBorder(JComponent comp) {
        Border border = comp.getBorder();
        if (border instanceof RadianceTextComponentBorder) {
            return true;
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            return compoundBorder.getOutsideBorder() instanceof RadianceTextComponentBorder || compoundBorder.getInsideBorder() instanceof RadianceTextComponentBorder;
        }
        return false;
    }
}

