/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.util.EnumSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JRootPane;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;

public class RadianceWidgetManager {
    private static RadianceWidgetManager instance;
    private Set<RadianceThemingSlices.WidgetType> globalAllowed = EnumSet.noneOf(RadianceThemingSlices.WidgetType.class);
    private Set<RadianceThemingSlices.WidgetType> globalDisallowed = EnumSet.noneOf(RadianceThemingSlices.WidgetType.class);
    private WeakHashMap<JRootPane, Set<RadianceThemingSlices.WidgetType>> specificAllowed = new WeakHashMap();
    private WeakHashMap<JRootPane, Set<RadianceThemingSlices.WidgetType>> specificDisallowed = new WeakHashMap();

    public static synchronized RadianceWidgetManager getInstance() {
        if (instance == null) {
            instance = new RadianceWidgetManager();
        }
        return instance;
    }

    private RadianceWidgetManager() {
    }

    public void register(JRootPane rootPane, boolean isAllowed, RadianceThemingSlices.WidgetType ... radianceWidgets) {
        if (rootPane == null) {
            for (RadianceThemingSlices.WidgetType widget : radianceWidgets) {
                if (isAllowed) {
                    this.globalAllowed.add(widget);
                    this.globalDisallowed.remove((Object)widget);
                    continue;
                }
                this.globalDisallowed.add(widget);
                this.globalAllowed.remove((Object)widget);
            }
        } else {
            Set<RadianceThemingSlices.WidgetType> toAddTo = null;
            Set<RadianceThemingSlices.WidgetType> toRemoveFrom = null;
            if (isAllowed) {
                toAddTo = this.specificAllowed.get(rootPane);
                if (toAddTo == null) {
                    toAddTo = EnumSet.noneOf(RadianceThemingSlices.WidgetType.class);
                    this.specificAllowed.put(rootPane, toAddTo);
                }
                toRemoveFrom = this.specificDisallowed.get(rootPane);
            } else {
                toAddTo = this.specificDisallowed.get(rootPane);
                if (toAddTo == null) {
                    toAddTo = EnumSet.noneOf(RadianceThemingSlices.WidgetType.class);
                    this.specificDisallowed.put(rootPane, toAddTo);
                }
                toRemoveFrom = this.specificAllowed.get(rootPane);
            }
            for (RadianceThemingSlices.WidgetType widget : radianceWidgets) {
                toAddTo.add(widget);
                if (toRemoveFrom == null) continue;
                toRemoveFrom.remove((Object)widget);
            }
        }
    }

    public boolean isAllowed(JRootPane rootPane, RadianceThemingSlices.WidgetType widget) {
        if (this.specificDisallowed.containsKey(rootPane) && this.specificDisallowed.get(rootPane).contains((Object)widget)) {
            return false;
        }
        if (this.specificAllowed.containsKey(rootPane) && this.specificAllowed.get(rootPane).contains((Object)widget)) {
            return true;
        }
        if (this.globalDisallowed.contains((Object)widget)) {
            return false;
        }
        return this.globalAllowed.contains((Object)widget);
    }
}

