/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.border.Border;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;

public class RadianceEtchedBorder
implements Border {
    private Color getHighlightColor(Component c) {
        RadianceColorScheme colorScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        return colorScheme.getSeparatorPrimaryColor();
    }

    private Color getShadowColor(Component c) {
        RadianceColorScheme colorScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        return colorScheme.getSeparatorSecondaryColor();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            graphics1X.setStroke(new BasicStroke(1.0f, 0, 1));
            graphics1X.setColor(this.getShadowColor(c));
            graphics1X.draw(new Rectangle2D.Float(0.0f, 0.0f, (float)scaledWidth - 2.0f, (float)scaledHeight - 2.0f));
            graphics1X.setColor(this.getHighlightColor(c));
            graphics1X.drawLine(1, 1, 1, scaledHeight - 3);
            graphics1X.drawLine(1, 1, scaledWidth - 3, 1);
            graphics1X.drawLine(scaledWidth - 1, 0, scaledWidth - 1, scaledHeight - 1);
            graphics1X.drawLine(0, scaledHeight - 1, scaledWidth - 2, scaledHeight - 1);
        });
        graphics.dispose();
        RadianceCommonCortex.installDesktopHints((Graphics2D)((Graphics2D)g), (Font)c.getFont());
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(2, 2, 2, 2);
    }
}

