/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeDrawingUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTableUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class RadianceTableCellBorder
implements Border,
UIResource {
    protected Insets myInsets;
    protected RadianceTableUI ui;
    protected RadianceTableUI.TableCellId cellId;
    protected float alpha;
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();

    public RadianceTableCellBorder(Insets insets, RadianceTableUI ui, RadianceTableUI.TableCellId cellId) {
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.ui = ui;
        this.cellId = cellId;
        this.alpha = 1.0f;
    }

    private void paintBorderImpl(JComponent c, Graphics g, int x, int y, int width, int height) {
        ComponentState currState;
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        float radius = 0.0f;
        StateTransitionTracker stateTransitionTracker = this.ui.getStateTransitionTracker(this.cellId);
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker == null ? null : stateTransitionTracker.getModelStateInfo();
        ComponentState componentState = currState = modelStateInfo == null ? this.ui.getCellState(this.cellId) : modelStateInfo.getCurrModelState();
        if (currState.isDisabled()) {
            currState = ComponentState.DISABLED_SELECTED;
        }
        BladeUtils.populateColorScheme(this.mutableBorderColorScheme, c, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, false);
        BladeDrawingUtils.paintBladeBorder(c, graphics, x, y, width, height, radius, this.mutableBorderColorScheme);
        graphics.dispose();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBorderImpl((JComponent)c, g, x, y, width, height);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

