/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.pushingpixels.radiance.common.api.filter.RadianceAbstractFilter;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.HashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class ColorSchemeFilter
extends RadianceAbstractFilter {
    private int[] interpolated;
    private static final int MAPSTEPS = 512;
    private static final LazyResettableHashMap<ColorSchemeFilter> filters = new LazyResettableHashMap("ColorSchemeFilter");
    private float originalBrightnessFactor;
    private float alpha;

    public static ColorSchemeFilter getColorSchemeFilter(RadianceColorScheme scheme, float originalBrightnessFactor, float alpha) {
        HashMapKey key = RadianceCoreUtilities.getHashKey(scheme.getDisplayName(), Float.valueOf(originalBrightnessFactor), Float.valueOf(alpha));
        ColorSchemeFilter filter = filters.get(key);
        if (filter == null) {
            filter = new ColorSchemeFilter(scheme, originalBrightnessFactor, alpha);
            filters.put(key, filter);
        }
        return filter;
    }

    public static int[] getInterpolatedColors(RadianceColorScheme scheme) {
        int brightness;
        TreeMap<Integer, Color> schemeColorMapping = new TreeMap<Integer, Color>();
        int ultraLight = scheme.getUltraLightColor().getRGB();
        int extraLight = scheme.getExtraLightColor().getRGB();
        int light = scheme.getLightColor().getRGB();
        int mid = scheme.getMidColor().getRGB();
        int dark = scheme.getDarkColor().getRGB();
        int ultraDark = scheme.getUltraDarkColor().getRGB();
        if (ultraLight == extraLight && ultraLight == light && ultraLight == mid && ultraLight == dark && ultraLight == ultraDark) {
            Color lighter = RadianceColorUtilities.deriveByBrightness(scheme.getLightColor(), 0.2f);
            Color darker = RadianceColorUtilities.deriveByBrightness(scheme.getLightColor(), -0.2f);
            schemeColorMapping.put(RadianceColorUtilities.getColorBrightness(lighter.getRGB()), lighter);
            schemeColorMapping.put(RadianceColorUtilities.getColorBrightness(light), scheme.getLightColor());
            schemeColorMapping.put(RadianceColorUtilities.getColorBrightness(darker.getRGB()), darker);
        } else {
            schemeColorMapping.put(RadianceColorUtilities.getColorBrightness(ultraLight), scheme.getUltraLightColor());
            schemeColorMapping.put(RadianceColorUtilities.getColorBrightness(extraLight), scheme.getExtraLightColor());
            schemeColorMapping.put(RadianceColorUtilities.getColorBrightness(light), scheme.getLightColor());
            schemeColorMapping.put(RadianceColorUtilities.getColorBrightness(mid), scheme.getMidColor());
            schemeColorMapping.put(RadianceColorUtilities.getColorBrightness(dark), scheme.getDarkColor());
            schemeColorMapping.put(RadianceColorUtilities.getColorBrightness(ultraDark), scheme.getUltraDarkColor());
        }
        ArrayList schemeBrightness = new ArrayList(schemeColorMapping.keySet());
        Collections.sort(schemeBrightness);
        int lowestSchemeBrightness = (Integer)schemeBrightness.get(0);
        int highestSchemeBrightness = (Integer)schemeBrightness.get(schemeBrightness.size() - 1);
        boolean hasSameBrightness = highestSchemeBrightness == lowestSchemeBrightness;
        TreeMap<Integer, Color> stretchedColorMapping = new TreeMap<Integer, Color>();
        for (Map.Entry entry : schemeColorMapping.entrySet()) {
            brightness = (Integer)entry.getKey();
            int stretched = hasSameBrightness ? brightness : 255 - 255 * (highestSchemeBrightness - brightness) / (highestSchemeBrightness - lowestSchemeBrightness);
            stretchedColorMapping.put(stretched, (Color)entry.getValue());
        }
        schemeBrightness = new ArrayList(stretchedColorMapping.keySet());
        Collections.sort(schemeBrightness);
        int[] interpolated = new int[512];
        block1: for (int i = 0; i < 512; ++i) {
            brightness = (int)(256.0 * (double)i / 512.0);
            if (schemeBrightness.contains(brightness)) {
                interpolated[i] = ((Color)stretchedColorMapping.get(brightness)).getRGB();
                continue;
            }
            if (hasSameBrightness) {
                interpolated[i] = ((Color)stretchedColorMapping.get(lowestSchemeBrightness)).getRGB();
                continue;
            }
            int currIndex = 0;
            while (true) {
                int currStopValue = (Integer)schemeBrightness.get(currIndex);
                int nextStopValue = (Integer)schemeBrightness.get(currIndex + 1);
                if (brightness > currStopValue && brightness < nextStopValue) {
                    Color currStopColor = (Color)stretchedColorMapping.get(currStopValue);
                    Color nextStopColor = (Color)stretchedColorMapping.get(nextStopValue);
                    interpolated[i] = RadianceColorUtilities.getInterpolatedRGB(currStopColor, nextStopColor, 1.0 - (double)(brightness - currStopValue) / (double)(nextStopValue - currStopValue));
                    continue block1;
                }
                ++currIndex;
            }
        }
        return interpolated;
    }

    private ColorSchemeFilter(RadianceColorScheme scheme, float originalBrightnessFactor, float alpha) {
        if (scheme == null) {
            throw new IllegalArgumentException("Color scheme cannot be null");
        }
        this.originalBrightnessFactor = originalBrightnessFactor;
        this.alpha = alpha;
        this.interpolated = ColorSchemeFilter.getInterpolatedColors(scheme);
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        this.getPixels(src, 0, 0, width, height, pixels);
        this.mixColor(pixels);
        this.setPixels(dst, 0, 0, width, height, pixels);
        return dst;
    }

    private void mixColor(int[] pixels) {
        for (int i = 0; i < pixels.length; ++i) {
            int argb = pixels[i];
            int brightness = RadianceColorUtilities.getColorBrightness(argb);
            int a = argb >>> 24 & 0xFF;
            int r = argb >>> 16 & 0xFF;
            int g = argb >>> 8 & 0xFF;
            int b = argb >>> 0 & 0xFF;
            float[] hsb = Color.RGBtoHSB(r, g, b, null);
            int pixelColor = this.interpolated[brightness * 512 / 256];
            int ri = pixelColor >>> 16 & 0xFF;
            int gi = pixelColor >>> 8 & 0xFF;
            int bi = pixelColor >>> 0 & 0xFF;
            float[] hsbi = Color.RGBtoHSB(ri, gi, bi, null);
            hsb[0] = hsbi[0];
            hsb[1] = hsbi[1];
            hsb[2] = this.originalBrightnessFactor >= 0.0f ? this.originalBrightnessFactor * hsb[2] + (1.0f - this.originalBrightnessFactor) * hsbi[2] : hsb[2] * hsbi[2] * (1.0f + this.originalBrightnessFactor);
            int result = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            int finalAlpha = (int)((float)a * this.alpha);
            pixels[i] = finalAlpha << 24 | (result >> 16 & 0xFF) << 16 | (result >> 8 & 0xFF) << 8 | result & 0xFF;
        }
    }
}

