/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class CheckBoxMenuItemIcon
implements Icon,
UIResource {
    private int size;
    private JMenuItem menuItem;
    private BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableMarkColorScheme = new BladeColorScheme();

    public CheckBoxMenuItemIcon(JMenuItem menuItem, int size) {
        this.menuItem = menuItem;
        this.size = size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)this.menuItem.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(this.menuItem);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(this.menuItem);
        ComponentState currState = modelStateInfo.getCurrModelState();
        float visibility = stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.SELECTION);
        boolean isCheckMarkFadingOut = !currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION);
        float alpha = RadianceColorSchemeUtilities.getAlpha(this.menuItem, currState);
        BladeUtils.populateColorScheme(this.mutableFillColorScheme, this.menuItem, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, false);
        BladeUtils.populateColorScheme(this.mutableBorderColorScheme, this.menuItem, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, false);
        BladeUtils.populateColorScheme(this.mutableMarkColorScheme, this.menuItem, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, false);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        BladeIconUtils.drawCheckBox(graphics, this.menuItem, fillPainter, borderPainter, this.size, currState, this.mutableFillColorScheme, this.mutableMarkColorScheme, this.mutableBorderColorScheme, visibility, 0.0f, isCheckMarkFadingOut, alpha);
        graphics.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

