/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.internal.animation.IconGlowTracker;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.ScaleAwareImageWrapperIcon;

public class GlowingIcon
implements Icon {
    private Icon delegate;
    private IconGlowTracker iconGlowTracker;
    private Map<Float, Icon> iconMap;
    private float glowDampeningFactor = 3.0f;

    public GlowingIcon(Icon delegate, IconGlowTracker iconGlowTracker) {
        this.delegate = delegate;
        this.iconGlowTracker = iconGlowTracker;
        this.iconMap = new HashMap<Float, Icon>();
    }

    public void setDampeningFactor(float dampeningFactor) {
        this.glowDampeningFactor = dampeningFactor;
    }

    @Override
    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.delegate == null) {
            return;
        }
        float fadePos = this.iconGlowTracker.getIconGlowPosition();
        Object toPaint = this.iconMap.get(Float.valueOf(fadePos));
        if (toPaint == null) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            double scale = RadianceCommonCortex.getScaleFactor((Component)c);
            BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, width, height);
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            this.delegate.paintIcon(c, graphics, 0, 0);
            int pixelWidth = image.getWidth();
            int pixelHeight = image.getHeight();
            for (int i = 0; i < pixelWidth; ++i) {
                for (int j = 0; j < pixelHeight; ++j) {
                    int rgba = image.getRGB(i, j);
                    int transp = rgba >>> 24 & 0xFF;
                    double coef = Math.sin(Math.PI * 2 * (double)fadePos / 2.0) / (double)this.glowDampeningFactor;
                    Color newColor = coef >= 0.0 ? RadianceColorUtilities.getLighterColor(new Color(rgba), coef) : RadianceColorUtilities.getDarkerColor(new Color(rgba), -coef);
                    image.setRGB(i, j, transp << 24 | newColor.getRed() << 16 | newColor.getGreen() << 8 | newColor.getBlue());
                }
            }
            toPaint = new ScaleAwareImageWrapperIcon(image, scale);
            this.iconMap.put(Float.valueOf(fadePos), (Icon)toPaint);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(x, y);
        toPaint.paintIcon(c, g, 0, 0);
        g2d.dispose();
    }
}

