/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.widget.text;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeHighlightableTransitionAwareIcon;
import org.pushingpixels.radiance.theming.internal.blade.BladeTransitionAwareIcon;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class EditContextMenuWidget
extends RadianceThemingWidget<JTextComponent> {
    private MouseListener menuMouseListener;
    private static final int ICON_SIZE = 14;

    @Override
    public void installListeners() {
        this.menuMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            private void handleMouseEvent(MouseEvent e) {
                if (!WidgetUtilities.hasTextEditContextMenu((JTextComponent)EditContextMenuWidget.this.jcomp)) {
                    return;
                }
                if (!e.isPopupTrigger()) {
                    return;
                }
                ((JTextComponent)EditContextMenuWidget.this.jcomp).requestFocus(true);
                JPopupMenu editMenu = new JPopupMenu();
                editMenu.add(EditContextMenuWidget.this.getCutItem());
                editMenu.add(EditContextMenuWidget.this.getCopyItem());
                editMenu.add(EditContextMenuWidget.this.getPasteItem());
                editMenu.addSeparator();
                editMenu.add(EditContextMenuWidget.this.getDeleteItem());
                editMenu.add(EditContextMenuWidget.this.getSelectAllItem());
                editMenu.applyComponentOrientation(((JTextComponent)EditContextMenuWidget.this.jcomp).getComponentOrientation());
                Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), EditContextMenuWidget.this.jcomp);
                if (((JTextComponent)EditContextMenuWidget.this.jcomp).getComponentOrientation().isLeftToRight()) {
                    editMenu.show(EditContextMenuWidget.this.jcomp, pt.x, pt.y);
                } else {
                    editMenu.show(EditContextMenuWidget.this.jcomp, pt.x - editMenu.getPreferredSize().width, pt.y);
                }
            }
        };
        ((JTextComponent)this.jcomp).addMouseListener(this.menuMouseListener);
    }

    @Override
    public void uninstallListeners() {
        ((JTextComponent)this.jcomp).removeMouseListener(this.menuMouseListener);
        this.menuMouseListener = null;
    }

    private JMenuItem getCutItem() {
        JMenuItem result = new JMenuItem(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("EditMenu.cut"));
        result.setEnabled(((JTextComponent)this.jcomp).isEditable() && ((JTextComponent)this.jcomp).isEnabled() && ((JTextComponent)this.jcomp).getSelectedText() != null);
        BladeHighlightableTransitionAwareIcon icon = new BladeHighlightableTransitionAwareIcon(result, () -> (TransitionAwareUI)((Object)result.getUI()), new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                RadianceThemingCortex.GlobalScope.getIconPack().getTextCutActionIcon(14, scheme).paintIcon(null, (Graphics)g, 0, 0);
            }

            @Override
            public Dimension getIconDimension() {
                return new Dimension(14, 14);
            }
        }, RadianceThemingSlices.ComponentStateFacet.ARM);
        result.setIcon(icon);
        result.addActionListener(actionEvent -> ((JTextComponent)this.jcomp).cut());
        return result;
    }

    private JMenuItem getCopyItem() {
        JMenuItem result = new JMenuItem(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("EditMenu.copy"));
        result.setEnabled(((JTextComponent)this.jcomp).isEnabled() && ((JTextComponent)this.jcomp).getSelectedText() != null);
        BladeHighlightableTransitionAwareIcon icon = new BladeHighlightableTransitionAwareIcon(result, () -> (TransitionAwareUI)((Object)result.getUI()), new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                RadianceThemingCortex.GlobalScope.getIconPack().getTextCopyActionIcon(14, scheme).paintIcon(null, (Graphics)g, 0, 0);
            }

            @Override
            public Dimension getIconDimension() {
                return new Dimension(14, 14);
            }
        }, RadianceThemingSlices.ComponentStateFacet.ARM);
        result.setIcon(icon);
        result.addActionListener(actionEvent -> ((JTextComponent)this.jcomp).copy());
        return result;
    }

    private JMenuItem getPasteItem() {
        JMenuItem result = new JMenuItem(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("EditMenu.paste"));
        boolean isEnabled = false;
        if (((JTextComponent)this.jcomp).isEditable() && ((JTextComponent)this.jcomp).isEnabled()) {
            Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            isEnabled = contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
        result.setEnabled(isEnabled);
        BladeHighlightableTransitionAwareIcon icon = new BladeHighlightableTransitionAwareIcon(result, () -> (TransitionAwareUI)((Object)result.getUI()), new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                RadianceThemingCortex.GlobalScope.getIconPack().getTextPasteActionIcon(14, scheme).paintIcon(null, (Graphics)g, 0, 0);
            }

            @Override
            public Dimension getIconDimension() {
                return new Dimension(14, 14);
            }
        }, RadianceThemingSlices.ComponentStateFacet.ARM);
        result.setIcon(icon);
        result.addActionListener(actionEvent -> ((JTextComponent)this.jcomp).paste());
        return result;
    }

    private JMenuItem getDeleteItem() {
        JMenuItem result = new JMenuItem(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("EditMenu.delete"));
        result.setEnabled(((JTextComponent)this.jcomp).isEditable() && ((JTextComponent)this.jcomp).isEnabled() && ((JTextComponent)this.jcomp).getSelectedText() != null);
        BladeHighlightableTransitionAwareIcon icon = new BladeHighlightableTransitionAwareIcon(result, () -> (TransitionAwareUI)((Object)result.getUI()), new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                RadianceThemingCortex.GlobalScope.getIconPack().getTextDeleteActionIcon(14, scheme).paintIcon(null, (Graphics)g, 0, 0);
            }

            @Override
            public Dimension getIconDimension() {
                return new Dimension(14, 14);
            }
        }, RadianceThemingSlices.ComponentStateFacet.ARM);
        result.setIcon(icon);
        result.addActionListener(actionEvent -> ((JTextComponent)this.jcomp).replaceSelection(null));
        return result;
    }

    private JMenuItem getSelectAllItem() {
        JMenuItem result = new JMenuItem(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("EditMenu.selectAll"));
        result.setEnabled(((JTextComponent)this.jcomp).isEnabled() && ((JTextComponent)this.jcomp).getDocument().getLength() > 0);
        BladeHighlightableTransitionAwareIcon icon = new BladeHighlightableTransitionAwareIcon(result, () -> (TransitionAwareUI)((Object)result.getUI()), new BladeTransitionAwareIcon.Delegate(){

            @Override
            public void drawColorSchemeIcon(Graphics2D g, RadianceColorScheme scheme, float alpha) {
                RadianceThemingCortex.GlobalScope.getIconPack().getTextSelectAllActionIcon(14, scheme).paintIcon(null, (Graphics)g, 0, 0);
            }

            @Override
            public Dimension getIconDimension() {
                return new Dimension(14, 14);
            }
        }, RadianceThemingSlices.ComponentStateFacet.ARM);
        result.setIcon(icon);
        result.addActionListener(actionEvent -> ((JTextComponent)this.jcomp).selectAll());
        return result;
    }
}

