/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.widget.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;

public class LockBorderWidget
extends RadianceThemingWidget<JTextComponent> {
    private PropertyChangeListener propertyChangeListener;
    private boolean isUninstalling = false;
    private static final String ORIGINAL_BORDER = "radiance.theming.internal.lockBorder.original";

    @Override
    public void installListeners() {
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("border".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (ORIGINAL_BORDER.equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (this.isUninstalling) {
                    return;
                }
                boolean hasLockIcon = LockBorderWidget.hasLockIcon(this.jcomp);
                if (hasLockIcon) {
                    this.installLockBorder();
                } else {
                    this.restoreOriginalBorder();
                }
            });
        };
        ((JTextComponent)this.jcomp).addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallListeners() {
        ((JTextComponent)this.jcomp).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    public void uninstallUI() {
        this.isUninstalling = true;
        Border original = (Border)((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER);
        if (original != null) {
            ((JTextComponent)this.jcomp).setBorder(original);
        }
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        if (LockBorderWidget.hasLockIcon(this.jcomp)) {
            Border currBorder = ((JTextComponent)this.jcomp).getBorder();
            ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, currBorder);
            ((JTextComponent)this.jcomp).setBorder(new LockBorder(currBorder));
        }
    }

    @Override
    public void uninstallDefaults() {
        this.isUninstalling = true;
        ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, null);
    }

    private void installLockBorder() {
        if (((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER) instanceof Border) {
            return;
        }
        Border currBorder = ((JTextComponent)this.jcomp).getBorder();
        if (currBorder != null) {
            ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, currBorder);
            ((JTextComponent)this.jcomp).setBorder(new LockBorder(currBorder));
        }
    }

    private void restoreOriginalBorder() {
        if (((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER) instanceof Border) {
            Border originalBorder = (Border)((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER);
            ((JTextComponent)this.jcomp).setBorder(originalBorder);
            ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, null);
        }
    }

    private static boolean hasLockIcon(Component comp) {
        boolean isEditableTextComponent;
        if (!RadianceCoreUtilities.toShowExtraWidgets(comp)) {
            return false;
        }
        if (comp instanceof JPasswordField) {
            return false;
        }
        boolean bl = isEditableTextComponent = comp instanceof JTextComponent ? ((JTextComponent)comp).isEditable() : false;
        if (comp instanceof JComponent) {
            if (!isEditableTextComponent && Boolean.TRUE.equals(((JComponent)comp).getClientProperty("radiance.theming.internal.widget.hasLockIcon"))) {
                return true;
            }
            if (Boolean.FALSE.equals(((JComponent)comp).getClientProperty("radiance.theming.internal.widget.hasLockIcon"))) {
                return false;
            }
        }
        return !isEditableTextComponent && Boolean.TRUE.equals(UIManager.get("radiance.theming.internal.widget.hasLockIcon"));
    }

    private static class LockBorder
    implements Border,
    UIResource {
        private Border originalBorder;

        public LockBorder(Border originalBorder) {
            this.originalBorder = originalBorder != null ? originalBorder : new EmptyBorder(0, 0, 0, 0);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Icon lockIcon = RadianceImageCreator.getSmallLockIcon(RadianceColorSchemeUtilities.getColorScheme(c, ComponentState.ENABLED), c);
            Insets origInsets = this.originalBorder.getBorderInsets(c);
            if (c.getComponentOrientation().isLeftToRight()) {
                return new Insets(origInsets.top, origInsets.left, origInsets.bottom, Math.max(origInsets.right, lockIcon.getIconWidth() + 2));
            }
            return new Insets(origInsets.top, Math.max(origInsets.left, lockIcon.getIconWidth() + 2), origInsets.bottom, origInsets.right);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.originalBorder.isBorderOpaque();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.originalBorder.paintBorder(c, g, x, y, width, height);
            Icon lockIcon = RadianceImageCreator.getSmallLockIcon(RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED), c);
            int offsetY = 1;
            if (c.getParent() instanceof JViewport) {
                JViewport viewport = (JViewport)c.getParent();
                if (viewport.getScrollMode() != 0) {
                    viewport.setScrollMode(0);
                }
                Rectangle viewRect = viewport.getViewRect();
                offsetY = c.getHeight() - viewRect.y - viewRect.height;
            }
            int iconY = y + height - lockIcon.getIconHeight() - offsetY;
            if (c.getComponentOrientation().isLeftToRight()) {
                lockIcon.paintIcon(c, g, x + width - lockIcon.getIconWidth(), iconY);
            } else {
                lockIcon.paintIcon(c, g, x, iconY);
            }
        }
    }
}

