/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.api.swing;

import java.awt.Component;
import org.pushingpixels.trident.api.Timeline;

public class SwingComponentTimeline
extends Timeline {
    private boolean forceUiUpdate;

    public static Builder componentBuilder(Component component) {
        return new Builder(component);
    }

    private SwingComponentTimeline(Component mainTimelineComp, boolean forceUiUpdate) {
        super(mainTimelineComp);
        if (mainTimelineComp == null) {
            throw new IllegalArgumentException("Must have non-null component");
        }
        this.forceUiUpdate = forceUiUpdate;
    }

    @Override
    protected boolean shouldForceUiUpdate() {
        return this.forceUiUpdate;
    }

    public static class Builder
    extends Timeline.BaseBuilder<SwingComponentTimeline, Builder, Component> {
        private boolean forceUiUpdate;

        public Builder(Component mainObject) {
            super(mainObject);
        }

        public Builder setForceUiUpdate(boolean forceUiUpdate) {
            this.forceUiUpdate = forceUiUpdate;
            return this;
        }

        @Override
        public SwingComponentTimeline build() {
            SwingComponentTimeline timeline = new SwingComponentTimeline((Component)this.mainObject, false);
            this.configureBaseTimeline(timeline);
            timeline.forceUiUpdate = this.forceUiUpdate;
            return timeline;
        }
    }
}

