/*
 * Decompiled with CFR 0.152.
 */
package de.schlund.pfixcore.example;

import de.schlund.pfixcore.example.DataBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.pustefixframework.web.mvc.filter.Filter;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.beans.support.SortDefinition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class ContextData {
    private List<DataBean> list = new ArrayList();
    private PagedListHolder<DataBean> dataList;

    public ContextData() {
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            long id = i;
            StringBuilder name = new StringBuilder();
            for (int j = 0; j < 5; ++j) {
                name.append((char)(random.nextInt(26) + 65));
            }
            StringBuilder description = new StringBuilder();
            for (int j = 0; j < 20; ++j) {
                description.append((char)(random.nextInt(26) + 65));
            }
            DataBean dataBean = new DataBean();
            dataBean.setId(id);
            dataBean.setName(name.toString());
            dataBean.setDescription(description.toString());
            dataBean.setEnabled(random.nextBoolean());
            this.list.add(dataBean);
            this.dataList = new PagedListHolder(this.list);
        }
    }

    public Page<DataBean> getDataList(Pageable pageable, Filter filter) {
        if (filter != null) {
            ArrayList<DataBean> filteredList = new ArrayList<DataBean>();
            for (DataBean bean : this.list) {
                if (filter.isSatisfiedBy((Object)bean)) {
                    filteredList.add(bean);
                }
                this.dataList = new PagedListHolder(filteredList);
            }
        } else {
            this.dataList = new PagedListHolder(this.list);
        }
        if (pageable.getSort() != null) {
            Sort.Order order = (Sort.Order)pageable.getSort().iterator().next();
            this.dataList.setSort((SortDefinition)new MutableSortDefinition(order.getProperty(), true, order.isAscending()));
            this.dataList.resort();
        }
        this.dataList.setPageSize(pageable.getPageSize());
        this.dataList.setPage(pageable.getPageNumber());
        return new PageImpl(this.dataList.getPageList(), pageable, (long)this.dataList.getSource().size());
    }

    public DataBean getData(long dataId) {
        for (DataBean dataBean : this.list) {
            if (dataBean.getId() != dataId) continue;
            return dataBean;
        }
        return null;
    }
}

