/*
 * Decompiled with CFR 0.152.
 */
package de.schlund.pfixcore.example;

import de.schlund.pfixcore.beans.InsertStatus;
import de.schlund.pfixcore.example.ContextEncodingTest;
import de.schlund.pfixxml.ResultDocument;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.w3c.dom.Element;

public class ContextEncodingTest {
    private static final String DEFAULT_TEXT = "abcd\u00e4\u00f6\u00fc\u00df";
    private String text = "abcd\u00e4\u00f6\u00fc\u00df";
    private String encoding = "";
    private File file;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @InsertStatus
    public void serializeToXML(Element elem) {
        ResultDocument.addTextChild((Element)elem, (String)"encoding", (String)this.encoding);
        ResultDocument.addTextChild((Element)elem, (String)"original", (String)this.text);
        if (this.file != null) {
            ResultDocument.addTextChild((Element)elem, (String)"file", (String)this.file.getAbsolutePath());
        }
        try {
            String utfEnc = URLEncoder.encode(this.text, "UTF-8");
            ResultDocument.addTextChild((Element)elem, (String)"urlenc-utf", (String)utfEnc);
            String isoEnc = URLEncoder.encode(this.text, "ISO-8859-1");
            ResultDocument.addTextChild((Element)elem, (String)"urlenc-iso", (String)isoEnc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ResultDocument.addObject((Element)elem, (String)"alphabet", (Object)new RussianAlphabet(this));
    }
}

