/*
 * Decompiled with CFR 0.152.
 */
package de.schlund.pfixcore.example;

import de.schlund.pfixcore.beans.InitResource;
import de.schlund.pfixcore.beans.InsertStatus;
import de.schlund.pfixxml.ResultDocument;
import de.schlund.pfixxml.multipart.UploadFile;
import org.w3c.dom.Element;

public class ContextFileUpload {
    private UploadFile[] uploadedFiles;
    private String comment;

    @InitResource
    public void initialize() {
    }

    @InsertStatus
    public void printStatus(ResultDocument resdoc, Element elem) {
        if (this.comment != null) {
            ResultDocument.addTextChild((Element)elem, (String)"comment", (String)this.comment);
        }
        if (this.uploadedFiles != null) {
            for (UploadFile file : this.uploadedFiles) {
                Element fileElem = resdoc.createSubNode(elem, "file");
                fileElem.setAttribute("name", file.getName());
                fileElem.setAttribute("mimetype", file.getMimeType());
                fileElem.setAttribute("exceedsSizeLimit", String.valueOf(file.exceedsSizeLimit()));
                if (file.exceedsSizeLimit()) continue;
                fileElem.setAttribute("localname", file.getLocalFile().getName());
                fileElem.setAttribute("size", String.valueOf(file.getSize()));
            }
        }
    }

    public void setFiles(UploadFile[] uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public UploadFile[] getFiles() {
        return this.uploadedFiles;
    }
}

