/*
 * Decompiled with CFR 0.152.
 */
package de.schlund.pfixcore.example;

import de.schlund.pfixcore.example.ContextCounter;
import de.schlund.pfixcore.example.StatusCodeLib;
import de.schlund.pfixcore.example.iwrapper.CounterInput;
import de.schlund.pfixcore.workflow.Context;
import org.pustefixframework.web.mvc.InputHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class CounterSetHandler
implements InputHandler<CounterInput> {
    @Autowired
    private Context context;
    private ContextCounter contextCounter;

    public void handleSubmittedData(CounterInput counter) {
        Integer count = counter.getSet();
        if (count != null) {
            this.contextCounter.setCounter(count.intValue());
            if (count > 9) {
                this.context.addPageMessage(StatusCodeLib.COUNTER_WARN_GREATER_9, new String[]{"" + count}, "error");
                this.context.prohibitContinue();
            } else if (count > 5) {
                this.context.addPageMessage(StatusCodeLib.COUNTER_WARN_GREATER_5, new String[]{"" + count}, "warn");
            } else if (count > 3) {
                this.context.addPageMessage(StatusCodeLib.COUNTER_INFO_GREATER_3, new String[]{"" + count}, "info");
            }
        }
    }

    public void retrieveCurrentStatus(CounterInput counter) {
        counter.setStringValSet("" + this.contextCounter.getCounter());
    }

    public boolean needsData() {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public boolean prerequisitesMet() {
        return true;
    }

    @Autowired
    public void setContextCounter(ContextCounter contextCounter) {
        this.contextCounter = contextCounter;
    }
}

