/*
 * Decompiled with CFR 0.152.
 */
package de.schlund.pfixcore.example;

import de.schlund.pfixcore.example.ContextTShirt;
import de.schlund.pfixcore.example.StatusCodeLib;
import de.schlund.pfixcore.example.iwrapper.TShirt;
import org.pustefixframework.web.mvc.InputHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class TShirtHandler
implements InputHandler<TShirt> {
    private ContextTShirt cts;

    public void handleSubmittedData(TShirt tshirt) {
        Integer color = tshirt.getColor();
        String size = tshirt.getSize();
        Integer[] feature = tshirt.getFeature();
        if (size.equals("L") && color.equals(new Integer(2))) {
            tshirt.addSCodeSize(StatusCodeLib.TSHIRT_SIZECOLOR_OUTOF_STOCK, new String[]{"L", "2"}, "note");
            return;
        }
        this.cts.setSize(size);
        this.cts.setColor(color);
        if (feature != null) {
            this.cts.setFeature(feature);
        } else {
            this.cts.setFeature(new Integer[]{new Integer(-1)});
        }
    }

    public void retrieveCurrentStatus(TShirt tshirt) {
        if (!this.cts.needsData()) {
            tshirt.setColor(this.cts.getColor());
            tshirt.setSize(this.cts.getSize());
            tshirt.setFeature(this.cts.getFeature());
        }
    }

    public boolean needsData() {
        return this.cts.needsData();
    }

    public boolean prerequisitesMet() {
        return true;
    }

    public boolean isActive() {
        return true;
    }

    @Autowired
    public void setContextTShirt(ContextTShirt cts) {
        this.cts = cts;
    }
}

